/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class AtomicPower
extends Cartridge {
    protected boolean exportA000Ram;
    protected boolean exportRam;
    protected final byte[] ram = new byte[8192];
    protected boolean freezed = false;
    protected int currentRomBank;
    protected final byte[][] romLBanks;
    protected final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return AtomicPower.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            AtomicPower.this.currentRomBank = value >> 3 & 3;
            if ((value & 0xE7) == 34) {
                value = (byte)(value ^ 3);
                AtomicPower.this.exportA000Ram = true;
                AtomicPower.this.exportRam = false;
            } else {
                AtomicPower.this.exportA000Ram = false;
                boolean bl = AtomicPower.this.exportRam = (value & 0x20) != 0;
                if ((value & 0x40) != 0 && AtomicPower.this.freezed) {
                    AtomicPower.this.pla.setNMI(false);
                }
            }
            AtomicPower.this.pla.setGameExrom(true, true, (value & 1) == 0, (value & 2) == 2);
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            if (AtomicPower.this.exportRam) {
                return AtomicPower.this.ram[address & 0x1FFF];
            }
            return AtomicPower.this.romLBanks[AtomicPower.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            if (AtomicPower.this.exportRam) {
                AtomicPower.this.ram[address & 0x1FFF] = value;
            }
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            if (AtomicPower.this.exportA000Ram) {
                return AtomicPower.this.ram[address & 0x1FFF];
            }
            return AtomicPower.this.romLBanks[AtomicPower.this.currentRomBank][address & 0x1FFF];
        }
    };
    private final Event newCartRomConfig = new Event("AtomicPower freeze"){

        @Override
        public void event() {
            AtomicPower.this.io1Bank.write(56832, (byte)3);
            AtomicPower.this.freezed = true;
        }
    };

    public AtomicPower(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romLBanks = new byte[4][8192];
        for (int i = 0; i < 4; ++i) {
            dis.readFully(chipHeader);
            if (chipHeader[12] != -96 && chipHeader[14] != 64 && (chipHeader[11] & 0xFF) > 3) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romLBanks[bank]);
        }
    }

    @Override
    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
        if (!this.exportA000Ram) {
            return;
        }
        for (int i = 10; i < 12; ++i) {
            Bank writeHook;
            final Bank origBank = cpuWriteMap[i];
            cpuWriteMap[i] = writeHook = new Bank(){

                @Override
                public void write(int address, byte value) {
                    AtomicPower.this.ram[address & 0x1FFF] = value;
                    origBank.write(address, value);
                }
            };
        }
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.romlBank;
    }

    @Override
    public void reset() {
        super.reset();
        this.io1Bank.write(56832, (byte)0);
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public void doFreeze() {
        this.pla.setNMI(true);
        this.pla.getCPU().getEventScheduler().schedule(this.newCartRomConfig, 3L, Event.Phase.PHI1);
    }
}

