/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class SDCard {
    protected static final byte MMC_CARD_IDLE = 0;
    protected static final byte MMC_CARD_RESET = 1;
    protected static final byte MMC_CARD_INIT = 2;
    protected static final byte MMC_CARD_READ = 3;
    protected static final byte MMC_CARD_DUMMY_READ = 4;
    protected static final byte MMC_CARD_WRITE = 5;
    protected static final byte MMC_CARD_DUMMY_WRITE = 6;
    protected static final byte MMC_CARD_RETURN_WRITE = 7;
    protected static final byte MMC_CARD_INSERTED = 0;
    protected static final byte MMC_CARD_NOTINSERTED = 1;
    protected static final byte MMC_SPIMODE_READ = 1;
    protected static final int CARD_TYPE_MMC = 1;
    protected static final int CARD_TYPE_SDHC = 3;
    protected int cardType = 1;
    protected boolean cardRw;
    protected RandomAccessFile imageFile;
    protected long imagePointer;
    protected int writeSequence;
    protected byte cardInserted;
    protected byte cardState;
    protected byte cardResetCount;
    protected int blockSize;
    protected int readFirstbyte;
    protected byte[] cmdBuffer = new byte[9];
    protected int cmdBufferPointer;
    protected int readBufferReadptr;
    protected int readBufferWriteptr;
    byte[] readBuffer = new byte[4096];
    protected byte cardSelected = 0;
    protected byte triggerMode = 0;

    protected void clearCmdBuffer() {
        Arrays.fill(this.cmdBuffer, (byte)0);
        this.cmdBufferPointer = 0;
    }

    protected void readBufferSet(byte[] data, int size) {
        int dataPos = 0;
        while (size != 0) {
            byte value;
            this.readBuffer[this.readBufferWriteptr] = value = data[dataPos++];
            ++this.readBufferWriteptr;
            this.readBufferWriteptr &= 0xFFF;
            --size;
        }
    }

    protected byte readBufferGetbyte() {
        byte value = 0;
        if (this.readBufferReadptr != this.readBufferWriteptr) {
            value = this.readBuffer[this.readBufferReadptr];
            ++this.readBufferReadptr;
            this.readBufferReadptr &= 0xFFF;
        }
        return value;
    }

    protected void resetCard() {
        this.triggerModeWrite((byte)0);
        this.cardSelectedWrite((byte)0);
        this.cardResetCount = 0;
        this.imagePointer = 0L;
        this.blockSize = 512;
        this.clearCmdBuffer();
    }

    public byte cardInserted() {
        return this.cardInserted;
    }

    byte setCardInserted(byte value) {
        byte oldvalue = this.cardInserted();
        this.cardInserted = value;
        return oldvalue;
    }

    public int setCardType(int value) {
        int oldvalue = this.cardType;
        this.cardType = value;
        return oldvalue;
    }

    public byte mmcBusy() {
        return 0;
    }

    public boolean cardWriteEnabled() {
        return this.cardRw;
    }

    public byte cardSelectedRead() {
        return this.cardSelected;
    }

    public void cardSelectedWrite(byte value) {
        this.cardSelected = value;
    }

    public byte enable8mhzRead() {
        return 0;
    }

    public void spi_mmc_enable_8mhz_write(byte value) {
    }

    public byte triggerModeRead() {
        return this.triggerMode;
    }

    public void triggerModeWrite(byte value) {
        this.triggerMode = value;
    }

    public byte dataRead() {
        switch (this.cardState) {
            case 7: {
                this.cardState = 0;
                return -1;
            }
            case 1: {
                switch (this.cardResetCount) {
                    case 0: {
                        this.cardResetCount = (byte)(this.cardResetCount + 1);
                        return 0;
                    }
                    case 1: {
                        this.cardResetCount = (byte)(this.cardResetCount + 1);
                        return 1;
                    }
                    case 2: {
                        this.cardResetCount = (byte)(this.cardResetCount + 1);
                        return 1;
                    }
                    case 3: {
                        this.cardResetCount = (byte)(this.cardResetCount + 1);
                        return 0;
                    }
                    case 4: {
                        this.cardResetCount = (byte)(this.cardResetCount + 1);
                        return 1;
                    }
                    case 5: {
                        this.cardResetCount = 0;
                        return 1;
                    }
                }
                break;
            }
            case 2: {
                return 0;
            }
            case 3: 
            case 4: {
                if (this.triggerModeRead() == 1) {
                    if (this.readFirstbyte != this.blockSize + 5) {
                        ++this.readFirstbyte;
                    }
                    if (this.readFirstbyte == this.blockSize + 3) {
                        return 0;
                    }
                    if (this.readFirstbyte == this.blockSize + 4) {
                        return 1;
                    }
                    if (this.readFirstbyte == this.blockSize + 5) {
                        return 0;
                    }
                } else {
                    if (this.readFirstbyte != this.blockSize + 2) {
                        ++this.readFirstbyte;
                    }
                    if (this.readFirstbyte == this.blockSize + 1) {
                        return 0;
                    }
                    if (this.readFirstbyte == this.blockSize + 2) {
                        return 1;
                    }
                }
                if (this.readFirstbyte == 0) {
                    return -1;
                }
                if (this.readFirstbyte == 1) {
                    return -2;
                }
                if (this.readFirstbyte == 2 && this.triggerModeRead() == 1) {
                    return -2;
                }
                if (0 == this.cardInserted() && this.cardState != 4) {
                    byte val = this.readBufferGetbyte();
                    return val;
                }
                return 0;
            }
        }
        return 0;
    }

    protected long getAddr() {
        long addr;
        if (this.cardType == 3) {
            addr = (long)this.cmdBuffer[5] * 256L + (long)this.cmdBuffer[4] * 65536L + (long)this.cmdBuffer[3] * 0x1000000L + (long)this.cmdBuffer[2] * 0x100000000L;
            addr <<= 1;
        } else {
            addr = this.cmdBuffer[5] + this.cmdBuffer[4] * 256 + this.cmdBuffer[3] * 65536 + this.cmdBuffer[2] * 0x1000000;
        }
        return addr;
    }

    protected void executeCmd() {
        switch (this.cmdBuffer[1]) {
            case -1: {
                this.cardState = 0;
                break;
            }
            case 64: {
                this.resetCard();
                this.cardState = 1;
                break;
            }
            case 65: {
                this.cardState = (byte)2;
                break;
            }
            case 72: {
                if (this.cardType == 1) {
                    byte[] cmdresp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    this.cardState = (byte)3;
                    this.readFirstbyte = 0;
                    this.readBufferSet(cmdresp, 512);
                    break;
                }
                byte[] cmdresp = new byte[]{1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.cardState = (byte)3;
                this.readFirstbyte = 1;
                this.readBufferSet(cmdresp, 512);
                break;
            }
            case 73: {
                if (0 == this.cardInserted()) {
                    byte[] csdresp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    this.cardState = (byte)3;
                    this.readFirstbyte = 0;
                    this.readBufferSet(csdresp, 512);
                    break;
                }
                this.cardState = (byte)4;
                this.readFirstbyte = 0;
                break;
            }
            case 74: {
                if (0 == this.cardInserted()) {
                    byte[] cidresp = new byte[]{0, 0, 0, 0, 22, 9, 3, 5, 50, 51, 0, 0, 0, 0, 0};
                    this.cardState = (byte)3;
                    this.readFirstbyte = 0;
                    this.readBufferReadptr = 0;
                    this.readBufferWriteptr = 0;
                    this.readBufferSet(cidresp, 16);
                    break;
                }
                this.cardState = (byte)4;
                this.readFirstbyte = 0;
                break;
            }
            case 76: {
                this.cardState = 0;
                break;
            }
            case 80: {
                this.cardState = 0;
                this.blockSize = this.cmdBuffer[5] + this.cmdBuffer[4] * 256 + this.cmdBuffer[3] * 65536 + this.cmdBuffer[2] * 0x1000000;
                break;
            }
            case 81: {
                if (0 == this.cardInserted()) {
                    this.cardState = (byte)3;
                    this.readFirstbyte = 0;
                    long currentAddressPointer = this.getAddr();
                    try {
                        this.imageFile.seek(currentAddressPointer);
                        byte[] readbuf = new byte[4096];
                        this.imageFile.seek(currentAddressPointer);
                        if (currentAddressPointer >= this.imageFile.length() || this.imageFile.read(readbuf, 1, this.blockSize) <= 0) break;
                        this.readBufferReadptr = 0;
                        this.readBufferWriteptr = 0;
                        this.readBufferSet(readbuf, this.blockSize);
                    }
                    catch (IOException e) {
                        this.cardState = (byte)4;
                    }
                    break;
                }
                this.cardState = (byte)4;
                this.readFirstbyte = 0;
                break;
            }
            case 88: {
                if (0 == this.cardInserted() && this.blockSize > 0) {
                    long currentAddressPointer = this.getAddr();
                    this.writeSequence = 0;
                    this.cardState = (byte)5;
                    break;
                }
                this.writeSequence = 0;
                this.cardState = (byte)6;
                break;
            }
            case 105: {
                byte[] cmdresp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.cardState = (byte)3;
                this.readFirstbyte = 0;
                this.readBufferSet(cmdresp, 512);
                break;
            }
            case 119: {
                if (this.cardType == 1) break;
                byte[] cmdresp = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.cardState = (byte)3;
                this.readFirstbyte = 0;
                this.readBufferSet(cmdresp, 512);
                break;
            }
            case 122: {
                if (this.cardType == 3) {
                    byte[] cmdresp = new byte[]{0, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    this.cardState = (byte)3;
                    this.readFirstbyte = 0;
                    this.readBufferSet(cmdresp, 512);
                    break;
                }
                byte[] cmdresp = new byte[]{0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.cardState = (byte)3;
                this.readFirstbyte = 0;
                this.readBufferSet(cmdresp, 512);
            }
        }
    }

    protected void writeToCmdBuffer(byte mmcreplayCmdChar) {
        if (this.cmdBufferPointer == 0 && mmcreplayCmdChar < -1) {
            if (mmcreplayCmdChar == 81) {
                this.cmdBuffer[0] = -1;
                ++this.cmdBufferPointer;
            } else {
                return;
            }
        }
        if (this.cmdBufferPointer == 1 && mmcreplayCmdChar == -1) {
            this.cmdBufferPointer = 0;
            return;
        }
        this.cmdBuffer[this.cmdBufferPointer] = mmcreplayCmdChar;
        ++this.cmdBufferPointer;
        if (this.cmdBufferPointer > 8 || this.cmdBufferPointer > 7 && this.cmdBuffer[1] == 64 || this.cmdBufferPointer > 8 && this.cmdBuffer[1] == 72 || this.cmdBufferPointer > 8 && this.cmdBuffer[1] == 73 || this.cmdBufferPointer > 8 && this.cmdBuffer[1] == 74 || this.cmdBufferPointer > 8 && this.cmdBuffer[1] == 80 || this.cmdBufferPointer > 8 && this.cmdBuffer[1] == 81) {
            this.executeCmd();
            this.clearCmdBuffer();
        }
    }

    protected void writeToMMC(byte value) {
        switch (this.writeSequence) {
            case 0: {
                if (value != -2) break;
                ++this.writeSequence;
                this.imagePointer = 0L;
                break;
            }
            case 1: {
                if (this.cardState == 5) {
                    try {
                        this.imageFile.write(value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println("could not write to mmc image file");
                    }
                }
                ++this.imagePointer;
                if (this.imagePointer != (long)this.blockSize) break;
                ++this.writeSequence;
                break;
            }
            case 2: {
                ++this.writeSequence;
                break;
            }
            case 3: {
                this.cardState = (byte)7;
            }
        }
    }

    public void dataWrite(byte value) {
        if (this.cardState == 5 || this.cardState == 6) {
            this.writeToMMC(value);
        } else {
            this.writeToCmdBuffer(value);
        }
    }

    public int mmc_open_card_image(String name, boolean rw) throws IOException {
        String imageFilename = name;
        this.setCardInserted((byte)1);
        if (imageFilename == null) {
            System.out.println("sd card image name not set");
            return 1;
        }
        if (this.imageFile != null) {
            this.closeCardImage();
        }
        if (rw) {
            this.imageFile = new RandomAccessFile(imageFilename, "rw");
        }
        if (this.imageFile == null) {
            this.imageFile = new RandomAccessFile(imageFilename, "r");
            if (this.imageFile == null) {
                System.out.printf("could not open sd card image: %s\n", imageFilename);
                return 1;
            }
            this.setCardInserted((byte)0);
            System.out.printf("opened sd card image (ro): %s\n", imageFilename);
        } else {
            this.setCardInserted((byte)0);
            System.out.printf("opened sd card image (rw): %s\n", imageFilename);
        }
        this.cardRw = rw;
        return 0;
    }

    public void closeCardImage() {
        if (this.imageFile != null) {
            try {
                this.imageFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.imageFile = null;
            this.setCardInserted((byte)1);
        }
    }
}

