/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import libsidplay.common.Event;
import libsidplay.components.Directory;
import libsidplay.components.cart.supported.ActionReplay;
import libsidplay.components.cart.supported.AtomicPower;
import libsidplay.components.cart.supported.Comal80;
import libsidplay.components.cart.supported.EasyFlash;
import libsidplay.components.cart.supported.EpyxFastLoad;
import libsidplay.components.cart.supported.Expert;
import libsidplay.components.cart.supported.FinalV1;
import libsidplay.components.cart.supported.FinalV3;
import libsidplay.components.cart.supported.MikroAss;
import libsidplay.components.cart.supported.Normal;
import libsidplay.components.cart.supported.Rex;
import libsidplay.components.cart.supported.Zaxxon;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Cartridge {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    public final PLA pla;
    private boolean nmiState;
    private boolean irqState;

    protected Cartridge(PLA pla) {
        this.pla = pla;
    }

    public Bank getRoml() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getRomh() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getUltimaxMemory() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO1() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO2() {
        return this.pla.getDisconnectedBusBank();
    }

    public static Cartridge readImage(PLA pla, InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] header = new byte[64];
        dis.readFully(header);
        if (!new String(header, 0, 16, ISO88591).equals("C64 CARTRIDGE   ")) {
            throw new RuntimeException("File is not a .CRT file");
        }
        Type type = Type.values()[(header[22] & 0xFF) << 8 | header[23] & 0xFF];
        switch (type) {
            case ACTION_REPLAY: {
                return new ActionReplay(dis, pla);
            }
            case NORMAL: {
                return new Normal(dis, pla);
            }
            case FINAL_CARTRIDGE_III: {
                return new FinalV3(dis, pla);
            }
            case EXPERT_CARTRIDGE: {
                return new Expert(dis, pla);
            }
            case ATOMIC_POWER: {
                return new AtomicPower(dis, pla);
            }
            case EPYX_FASTLOAD: {
                return new EpyxFastLoad(dis, pla);
            }
            case REX_UTILITY: {
                return new Rex(dis, pla);
            }
            case FINAL_CARTRIDGE_I: {
                return new FinalV1(dis, pla);
            }
            case ZAXXON__SUPER_ZAXXON: {
                return new Zaxxon(dis, pla);
            }
            case COMAL_80: {
                return new Comal80(dis, pla);
            }
            case MIKRO_ASSEMBLER: {
                return new MikroAss(dis, pla);
            }
            case EASYFLASH: {
                return new EasyFlash(dis, pla);
            }
        }
        throw new RuntimeException("Cartridges of format: " + (Object)((Object)type) + " unsupported");
    }

    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
    }

    public static Cartridge nullCartridge(PLA pla) {
        return new Cartridge(pla){

            @Override
            public String toString() {
                return "";
            }
        };
    }

    public void reset() {
        this.nmiState = false;
        this.irqState = false;
    }

    public final void freeze() {
        this.pla.getCPU().getEventScheduler().scheduleThreadSafe(new Event("Freeze TS"){

            @Override
            public void event() {
                Cartridge.this.doFreeze();
            }
        });
    }

    protected void doFreeze() {
    }

    public void changedNMI(boolean state) {
    }

    public void changedIRQ(boolean state) {
    }

    public void changedBA(boolean state) {
    }

    public void setNMI(boolean state) {
        if (state ^ this.nmiState) {
            this.pla.setNMI(state);
            this.nmiState = state;
        }
    }

    public void setIRQ(boolean state) {
        if (state ^ this.irqState) {
            this.pla.setIRQ(state);
            this.irqState = state;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static Directory getDirectory(File file) throws IOException {
        Directory dir = new Directory();
        FileInputStream is = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(is);
        byte[] header = new byte[64];
        dis.readFully(header);
        if (!new String(header, 0, 16, ISO88591).equals("C64 CARTRIDGE   ")) {
            return dir;
        }
        Type type = Type.values()[(header[22] & 0xFF) << 8 | header[23] & 0xFF];
        dir.setTitle(type.toString().replace('_', '-').getBytes(ISO88591));
        dir.setId(String.valueOf(file.length() >> 10).getBytes(ISO88591));
        ((InputStream)is).close();
        return dir;
    }

    static enum Type {
        NORMAL,
        ACTION_REPLAY,
        KCS_POWER_CARTRIDGE,
        FINAL_CARTRIDGE_III,
        SIMONS_BASIC,
        OCEAN_TYPE_1,
        EXPERT_CARTRIDGE,
        FUN_PLAY__POWER_PLAY,
        SUPER_GAMES,
        ATOMIC_POWER,
        EPYX_FASTLOAD,
        WESTERMANN_LEARNING,
        REX_UTILITY,
        FINAL_CARTRIDGE_I,
        MAGIC_FORMEL,
        C64_GAME_SYSTEM__SYSTEM_3,
        WARPSPEED,
        DINAMIC,
        ZAXXON__SUPER_ZAXXON,
        MAGIC_DESK__DOMARK__HES_AUSTRALIA,
        SUPER_SNAPSHOT_5,
        COMAL_80,
        STRUCTURED_BASIC,
        ROSS,
        DELA_EP64,
        DELA_EP7X8,
        DELA_EP256,
        REX_EP256,
        MIKRO_ASSEMBLER,
        RESERVED,
        ACTION_REPLAY_4,
        STARDOS,
        EASYFLASH;

    }
}

