/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import libsidplay.components.DirEntry;
import libsidplay.components.Directory;
import libsidplay.components.c1541.D64;
import libsidplay.components.c1541.G64;
import libsidplay.components.c1541.GCR;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.components.c1541.NIB;

public abstract class DiskImage {
    protected static final int DIR_TRACK_1541 = 18;
    protected static final int MIN_TRACKS_1541 = 35;
    protected static final int EXT_TRACKS_1541 = 40;
    protected static final int MAX_TRACKS_1541 = 42;
    protected static final int[] RAW_TRACK_SIZE = new int[]{6250, 6666, 7142, 7692};
    protected static final int[] SPEED_MAP_1541 = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected int[] trackSize = new int[70];
    protected RandomAccessFile fd;
    protected String fileName;
    protected boolean readOnly;
    protected int tracks;
    protected GCR gcr;
    protected IExtendImageListener extendImageListener;
    private static final int MAX_SECTORS_PER_TRACK = 30;
    private static final int MAX_OVERALL_SECTORS = 1260;
    private static final int NR_ENTRIES_PER_BLOCK = 7;
    private static final int DIR_ENTRY_SIZE = 32;

    protected DiskImage(GCR gcr, String fileName, RandomAccessFile fd, boolean readOnly) {
        this.gcr = gcr;
        this.fileName = fileName;
        this.fd = fd;
        this.readOnly = readOnly;
    }

    public static final DiskImage attach(GCR gcr, File file) throws IOException {
        String headerString;
        RandomAccessFile fd;
        assert (file != null);
        boolean readOnly = false;
        try {
            fd = new RandomAccessFile(file, "rw");
        }
        catch (IOException e) {
            fd = new RandomAccessFile(file, "r");
            readOnly = true;
        }
        byte[] header = new byte[Math.max("GCR-1541".length(), "MNIB-1541-RAW".length())];
        fd.readFully(header, 0, header.length);
        fd.seek(0L);
        try {
            headerString = new String(header, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No ISO-8859-1 encoding!");
        }
        DiskImage image = headerString.startsWith("GCR-1541") ? new G64(gcr, file.getName(), fd, readOnly) : (headerString.startsWith("MNIB-1541-RAW") ? new NIB(gcr, file.getName(), fd, readOnly) : new D64(gcr, file.getName(), fd, readOnly));
        try {
            ((DiskImage)image).attach();
        }
        catch (IOException e) {
            image.fd.close();
            throw e;
        }
        return image;
    }

    protected abstract void attach() throws IOException;

    public final void detach() throws IOException {
        this.fd.close();
    }

    public final void setExtendImagePolicy(IExtendImageListener listener) {
        this.extendImageListener = listener;
    }

    public abstract void gcrDataWriteback(int var1) throws IOException;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public static final Directory getDirectory(File file) throws IOException {
        Directory dir = new Directory();
        final DiskImage img = DiskImage.attach(new GCR(), file);
        int[] arrCyclicAccessInfo = new int[1260];
        byte[] sectorBytes = new byte[260];
        img.getDiskSector(18, 0, sectorBytes);
        int afterBamInfos = 145;
        int freeBlocks = 0;
        for (int i = 1; i <= 35; ++i) {
            if (i == 18) continue;
            freeBlocks += sectorBytes[5 + (i - 1) * 4] & 0xFF;
        }
        byte[] diskName = new byte[16];
        byte[] diskID = new byte[5];
        System.arraycopy(sectorBytes, afterBamInfos, diskName, 0, diskName.length);
        System.arraycopy(sectorBytes, afterBamInfos + 18, diskID, 0, diskID.length);
        dir.setSingleSided((sectorBytes[4] & 0x80) == 0);
        dir.setTitle(diskName);
        dir.setId(diskID);
        dir.setFreeBlocks(freeBlocks);
        byte[] currSector = new byte[260];
        int nextTrack = 18;
        int nextSector = 1;
        int currNextSector = 0;
        int currNextTrack = 0;
        int nextEntry = -1;
        while (true) {
            if (nextEntry < 7) {
                ++nextEntry;
            } else {
                if (currNextTrack == 0) break;
                nextTrack = currNextTrack;
                nextSector = currNextSector;
                nextEntry = 0;
            }
            if (!img.getDiskSector(nextTrack, nextSector, currSector) || nextEntry == 0 && currNextTrack != 0 && arrCyclicAccessInfo[nextSector] != 0) break;
            int n = nextSector;
            arrCyclicAccessInfo[n] = arrCyclicAccessInfo[n] + 1;
            currNextTrack = currSector[1] & 0xFF;
            currNextSector = currSector[2] & 0xFF;
            byte[] entryBytes = new byte[32];
            System.arraycopy(currSector, 1 + nextEntry * 32, entryBytes, 0, 32);
            byte fileType = entryBytes[2];
            if (fileType == 0) continue;
            final byte firstFileTrack = entryBytes[3];
            final byte firstFileSector = entryBytes[4];
            byte[] fn = new byte[16];
            System.arraycopy(entryBytes, 5, fn, 0, 16);
            byte lowByte = entryBytes[30];
            byte highByte = entryBytes[31];
            int nrSectors = (lowByte & 0xFF) + ((highByte & 0xFF) << 8);
            dir.getDirEntries().add(new DirEntry(nrSectors, fn, fileType){

                @Override
                public void save(File autostartFile) throws IOException {
                    img.save(autostartFile, firstFileTrack, firstFileSector);
                }
            });
        }
        img.detach();
        return dir;
    }

    private boolean getDiskSector(int track, int sector, byte[] currSector) {
        if (track < 1 || track > this.tracks) {
            return false;
        }
        this.gcr.setHalfTrack(track << 1, this.trackSize[track - 1], this.trackSize[track - 1]);
        int gcrDataPos = this.gcr.findSectorHeader(track, sector, this.trackSize[track - 1]);
        if (gcrDataPos != -1) {
            if ((gcrDataPos = this.gcr.findSectorData(gcrDataPos, this.trackSize[track - 1])) == -1) {
                System.err.println(String.format("Could not find data sync of T:%d S:%d.", track, sector));
                return false;
            }
            this.gcr.convertGCRToSector(currSector, gcrDataPos, this.trackSize[track - 1]);
            if (currSector[0] != 7) {
                System.err.println(String.format("Could not find data block id of T:%d S:%d.", track, sector));
                return false;
            }
            return true;
        }
        System.err.println(String.format("Could not find header of T:%d S:%d.", track, sector));
        return false;
    }

    public final boolean save(File file, byte startTrack, byte startSector) throws IOException {
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));
        byte[] currSector = new byte[260];
        int[] arrCyclicAccessInfo = new int[1260];
        for (int i = 0; i < arrCyclicAccessInfo.length; ++i) {
            arrCyclicAccessInfo[i] = 0;
        }
        byte nextTrack = startTrack;
        byte nextSector = startSector;
        while (true) {
            if (!this.getDiskSector(nextTrack, nextSector, currSector)) {
                dout.close();
                return false;
            }
            int offset = nextTrack * 30 + nextSector;
            if (arrCyclicAccessInfo[offset] != 0) {
                dout.close();
                return false;
            }
            int n = offset;
            arrCyclicAccessInfo[n] = arrCyclicAccessInfo[n] + 1;
            if (currSector[1] == 0) {
                dout.write(currSector, 3, 254);
                dout.close();
                return true;
            }
            dout.write(currSector, 3, 254);
            nextTrack = currSector[1];
            nextSector = currSector[2];
        }
    }
}

