/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.OvImageIcon;
import libsidplay.components.c1541.VIA6522BC;
import libsidplay.components.c1541.VIA6522DC;
import libsidplay.components.iec.IECBus;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.mem.IC1541_1;
import libsidplay.mem.IC1541_2;
import libsidplay.mem.IC1541_II_1;
import libsidplay.mem.IC1541_II_2;

public final class C1541 {
    protected static final OvImageIcon FLOPPYICON = new OvImageIcon(C1541.class.getResource("icons/cbm1541c.png"));
    protected static final OvImageIcon FLOPPYICON_G = new OvImageIcon(C1541.class.getResource("icons/cbm1541c_g.png"));
    protected static final OvImageIcon FLOPPYICON_RG = new OvImageIcon(C1541.class.getResource("icons/cbm1541c_rg.png"));
    protected static final OvImageIcon FLOPPYICON_II = new OvImageIcon(C1541.class.getResource("icons/1541_ii.png"));
    protected static final OvImageIcon FLOPPYICON_II_R = new OvImageIcon(C1541.class.getResource("icons/1541_ii_r.png"));
    protected static final OvImageIcon FLOPPYICON_II_RG = new OvImageIcon(C1541.class.getResource("icons/1541_ii_rg.png"));
    private static final int ROM_SIZE = 16384;
    private static final int RAM_SIZE = 2048;
    private static final int RAM_EXP_SIZE = 8192;
    protected static final int EXP_RAM_BANKS = 5;
    private boolean powerOn;
    private final int id;
    private FloppyType floppyType;
    private final EventScheduler context = new EventScheduler();
    private final MOS6510 cpu;
    private final VIA6522BC viaBc;
    private final VIA6522DC viaDc;
    private final byte[] ram = new byte[2048];
    private final byte[] rom = new byte[16384];
    private byte[] customC1541Rom;
    private final byte[][] ramExpand = new byte[5][];
    private final boolean[] ramExpEnabled = new boolean[5];
    private int irqCount;

    public C1541(IECBus iecBus, int deviceID, FloppyType type) {
        this.id = deviceID;
        this.cpu = new MOS6510(this.context){

            @Override
            public byte cpuRead(int address) {
                int ramExpSelect = address >> 13;
                if (ramExpSelect > 0 && ramExpSelect <= 5 && C1541.this.getRAMExpEnabled()[ramExpSelect - 1]) {
                    return C1541.this.getRAMExpand()[ramExpSelect - 1][address & 0x1FFF];
                }
                if (address < 32768) {
                    int chip = address & 0x1C00;
                    if (chip < 2048) {
                        return C1541.this.getRAM()[address & 0x7FF];
                    }
                    if (chip == 6144) {
                        return C1541.this.getBusController().read(address & 0xF);
                    }
                    if (chip == 7168) {
                        return C1541.this.getDiskController().read(address & 0xF);
                    }
                    return -1;
                }
                return C1541.this.getROM()[address & 0x3FFF];
            }

            @Override
            public void cpuWrite(int address, byte data) {
                int ramExpSelect = address >> 13;
                if (ramExpSelect > 0 && ramExpSelect <= 5 && C1541.this.getRAMExpEnabled()[ramExpSelect - 1]) {
                    C1541.this.getRAMExpand()[ramExpSelect - 1][address & 0x1FFF] = data;
                }
                if (address < 32768) {
                    int chip = address & 0x1C00;
                    if (chip < 2048) {
                        C1541.this.getRAM()[address & 0x7FF] = data;
                    }
                    if (chip == 6144) {
                        C1541.this.getBusController().write(address & 0xF, data);
                    }
                    if (chip == 7168) {
                        C1541.this.getDiskController().write(address & 0xF, data);
                    }
                }
            }

            @Override
            public boolean getFlagV() {
                C1541.this.getDiskController().rotateDisk();
                return super.getFlagV();
            }

            @Override
            public void setFlagV(boolean state) {
                C1541.this.getDiskController().rotateDisk();
                super.setFlagV(state);
            }
        };
        this.viaBc = new VIA6522BC(deviceID, iecBus){

            @Override
            protected long cpuClk() {
                return C1541.this.getEventScheduler().getTime(Event.Phase.PHI2);
            }

            @Override
            protected void alarmSet(Event alarm, long ti) {
                C1541.this.getEventScheduler().scheduleAbsolute(alarm, ti, Event.Phase.PHI1);
            }

            @Override
            protected void alarmUnset(Event alarm) {
                C1541.this.getEventScheduler().cancel(alarm);
            }

            @Override
            protected void setIRQ(boolean state) {
                C1541.this.signalIRQ(state);
            }
        };
        this.viaDc = new VIA6522DC(deviceID, this.cpu){

            @Override
            protected long cpuClk() {
                return C1541.this.getEventScheduler().getTime(Event.Phase.PHI2);
            }

            @Override
            protected void alarmSet(Event alarm, long ti) {
                C1541.this.getEventScheduler().scheduleAbsolute(alarm, ti, Event.Phase.PHI1);
            }

            @Override
            protected void alarmUnset(Event alarm) {
                C1541.this.getEventScheduler().cancel(alarm);
            }

            @Override
            protected void setIRQ(boolean state) {
                C1541.this.signalIRQ(state);
            }

            @Override
            public void diskAttachedDetached(String imageName, boolean attached) {
                String name = attached ? imageName : null;
                FLOPPYICON.setImageName(name);
                FLOPPYICON_G.setImageName(name);
                FLOPPYICON_RG.setImageName(name);
                FLOPPYICON_II.setImageName(name);
                FLOPPYICON_II_R.setImageName(name);
                FLOPPYICON_II_RG.setImageName(name);
            }
        };
        this.setFloppyType(type);
        for (int i = 0; i < 5; ++i) {
            this.ramExpand[i] = new byte[8192];
        }
    }

    public final EventScheduler getEventScheduler() {
        return this.context;
    }

    public final MOS6510 getCPU() {
        return this.cpu;
    }

    public final VIA6522BC getBusController() {
        return this.viaBc;
    }

    public final VIA6522DC getDiskController() {
        return this.viaDc;
    }

    public final byte[] getRAM() {
        return this.ram;
    }

    public final byte[] getROM() {
        return this.rom;
    }

    public final boolean[] getRAMExpEnabled() {
        return this.ramExpEnabled;
    }

    public final byte[][] getRAMExpand() {
        return this.ramExpand;
    }

    public final int getID() {
        return this.id;
    }

    public final void setPowerOn(boolean on) {
        this.powerOn = on;
    }

    public final void setFloppyType(FloppyType type) {
        this.floppyType = type;
        this.setRom();
    }

    public final void setRamExpansion(int select, boolean expand) {
        assert (select < 5);
        this.ramExpEnabled[select] = expand;
    }

    protected void signalIRQ(boolean state) {
        if (state) {
            if (this.irqCount++ == 0) {
                this.cpu.triggerIRQ();
            }
        } else if (--this.irqCount == 0) {
            this.cpu.clearIRQ();
        }
    }

    public final void reset() {
        this.context.reset();
        this.cpu.triggerRST();
        this.viaBc.reset();
        this.viaDc.reset();
        this.irqCount = 0;
        Arrays.fill(this.ram, (byte)0);
        for (int i = 0; i < 5; ++i) {
            Arrays.fill(this.ramExpand[i], (byte)0);
        }
    }

    private void setRom() {
        if (this.customC1541Rom != null) {
            System.arraycopy(this.customC1541Rom, 0, this.rom, 0, 16384);
        } else if (this.floppyType == FloppyType.C1541) {
            System.arraycopy(IC1541_1.C1541_C000, 0, this.rom, 0, 8192);
            System.arraycopy(IC1541_2.C1541_E000, 0, this.rom, 8192, 8192);
        } else {
            System.arraycopy(IC1541_II_1.C1541_II_C000, 0, this.rom, 0, 8192);
            System.arraycopy(IC1541_II_2.C1541_II_E000, 0, this.rom, 8192, 8192);
        }
    }

    public final void setCustomKernalRom(byte[] c1541Rom) {
        this.customC1541Rom = c1541Rom;
    }

    public final OvImageIcon getIcon() {
        if (this.floppyType == FloppyType.C1541) {
            if (this.powerOn) {
                if (this.viaDc.isLEDOn()) {
                    return FLOPPYICON_RG;
                }
                return FLOPPYICON_G;
            }
            return FLOPPYICON;
        }
        if (this.powerOn) {
            if (this.viaDc.isLEDOn()) {
                return FLOPPYICON_II_RG;
            }
            return FLOPPYICON_II_R;
        }
        return FLOPPYICON_II;
    }

    public static enum FloppyType {
        C1541,
        C1541_II;

    }
}

