/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1530;

import java.io.File;
import java.io.IOException;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1530.Tap;

public class TapeImage {
    private Tap tap;
    private File tapeFile;

    public final boolean imageAttach(Datasette datasette, File tapeFile) throws IOException {
        Tap newTap = new Tap();
        if (!newTap.open(tapeFile)) {
            System.err.printf("Cannot open file '%s'\n", tapeFile.getName());
            return false;
        }
        this.imageDetach(datasette);
        this.tapeFile = tapeFile;
        this.tap = newTap;
        datasette.setTapeImage(newTap);
        System.out.printf("TAP image '%s' attached.\n", tapeFile.getName());
        System.out.println(String.format("TAP image version: %d, system: %d.", newTap.version, newTap.system));
        return true;
    }

    final void imageDetach(Datasette datasette) throws IOException {
        if (this.tap == null || this.tapeFile == null) {
            return;
        }
        System.out.printf("Detaching TAP image '%s'.\n", this.tapeFile.getName());
        datasette.setTapeImage(null);
        this.tap.close();
        this.tapeFile = null;
        this.tap = null;
    }

    public String getName() {
        return this.tapeFile != null ? this.tapeFile.getName() : "";
    }

    public String toString() {
        return this.getName();
    }
}

