/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1530;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class Tap {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    public static final int TAP_HDR_SIZE = 20;
    public static final int TAP_HDR_MAGIC_OFFSET = 0;
    public static final int TAP_HDR_VERSION = 12;
    public static final int TAP_HDR_SYSTEM = 13;
    public static final int TAP_HDR_LEN = 16;
    RandomAccessFile fd;
    long size;
    byte version;
    byte system;
    long currentFilePosition;
    int offset = 20;
    int cycleCounter;
    int cycleCounterTotal;
    int counter;
    private boolean readOnly;
    boolean hasChanged;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean readHeader() {
        byte[] buf = new byte[20];
        try {
            this.fd.readFully(buf);
        }
        catch (IOException e) {
            return false;
        }
        String checkName = new String(buf, 0, 12, ISO88591);
        if (!checkName.startsWith("C64-TAPE-RAW") && !checkName.startsWith("C16-TAPE-RAW")) {
            return false;
        }
        this.version = buf[12];
        this.system = buf[13];
        return true;
    }

    public final boolean open(File tapeFile) throws IOException {
        if (!this.readOnly) {
            try {
                this.fd = new RandomAccessFile(tapeFile, "rw");
                this.readOnly = false;
            }
            catch (IOException e) {
                this.fd = new RandomAccessFile(tapeFile, "r");
                this.readOnly = true;
            }
        }
        if (!this.readHeader()) {
            this.fd.close();
            return false;
        }
        this.size = this.fd.length() - 20L;
        if (this.size < 3L) {
            this.fd.close();
            return false;
        }
        return true;
    }

    public final void close() throws IOException {
        if (this.fd != null) {
            if (this.hasChanged) {
                this.fd.seek(16L);
                this.writeFilesize(new int[]{(int)this.size});
            }
            this.fd.close();
            this.fd = null;
        }
    }

    private void writeFilesize(int[] buf) throws IOException {
        ByteBuffer b = ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN);
        b.asIntBuffer().put(buf, 0, 1);
        b.rewind();
        this.fd.write(b.array(), 0, 4);
    }

    final void seekStart() throws IOException {
        this.currentFilePosition = 0L;
        this.fd.seek(this.offset);
    }
}

