/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1530;

import java.io.File;
import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.OvImageIcon;
import libsidplay.components.c1530.Tap;
import libsidplay.components.c1530.TapeImage;

public abstract class Datasette {
    private static final OvImageIcon datasette = new OvImageIcon(Datasette.class.getResource("icons/datassette.png"));
    private static final OvImageIcon datasette_g = new OvImageIcon(Datasette.class.getResource("icons/datassette_g.png"));
    private static final OvImageIcon datasette_r = new OvImageIcon(Datasette.class.getResource("icons/datassette_r.png"));
    private static final int MAX_COUNTER = 1000;
    private static final double DS_D = 1.27E-5;
    private static final double DS_R = 0.0107;
    private static final double DS_V_PLAY = 0.0476;
    private static final double DS_G = 0.525;
    private static final double DS_RPS_FAST = 4.0;
    private static final double DS_C1 = 1193.0354789250737;
    private static final double DS_C2 = 709839.4196788392;
    private static final double DS_C3 = 842.51968503937;
    private final TapeImage img = new TapeImage();
    private static final int MOTOR_DELAY = 32000;
    private static final int TAP_BUFFER_LENGTH = 100000;
    private static final int DATASETTE_MAX_GAP = 100000;
    protected Control mode = Control.STOP;
    protected Tap currentImage;
    private final byte[] tapBuffer = new byte[100000];
    protected long nextTap;
    protected long lastTap;
    private final boolean resetDatasetteWithMainCPU;
    private final int zeroGapDelay;
    private int fullwave;
    private long fullwaveGap;
    protected boolean motor;
    protected long lastWriteClk;
    private long motorStopClk;
    private final EventScheduler context;
    private int lastCounter;
    private final Event event;
    private long longGapPending;
    private long longGapElapsed;
    private int lastDirection;
    private int counterOffset;

    public final void insertTape(File tapeFile) throws IOException {
        this.ejectTape();
        this.img.imageAttach(this, tapeFile);
        this.updateIcons();
    }

    public final void ejectTape() throws IOException {
        this.img.imageDetach(this);
        this.updateIcons();
    }

    private void updateIcons() {
        datasette.setImageName(this.img.toString());
        datasette_g.setImageName(this.img.toString());
        datasette_r.setImageName(this.img.toString());
    }

    public Datasette(EventScheduler ctx) {
        this.context = ctx;
        this.resetDatasetteWithMainCPU = true;
        this.zeroGapDelay = 20000;
        this.event = new Event("Datasette"){

            @Override
            public void event() {
                try {
                    Datasette.this.readBit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void updateCounter() {
        if (this.currentImage == null) {
            return;
        }
        this.currentImage.counter = (1000 - this.counterOffset + (int)(0.525 * (Math.sqrt((double)this.currentImage.cycleCounter / this.context.getCyclesPerSecond() * 1193.0354789250737 + 709839.4196788392) - 842.51968503937))) % 1000;
        if (this.lastCounter != this.currentImage.counter) {
            this.lastCounter = this.currentImage.counter;
        }
    }

    protected void resetCounter() {
        if (this.currentImage == null) {
            return;
        }
        this.counterOffset = (1000 + (int)(0.525 * (Math.sqrt((double)this.currentImage.cycleCounter / this.context.getCyclesPerSecond() * 1193.0354789250737 + 709839.4196788392) - 842.51968503937))) % 1000;
        this.updateCounter();
    }

    private boolean moveBufferForward(int offset) {
        if (this.nextTap + (long)offset >= this.lastTap) {
            try {
                this.currentImage.fd.seek(this.currentImage.currentFilePosition + (long)this.currentImage.offset);
            }
            catch (IOException e) {
                System.err.println("Cannot read in tap-file.");
                return false;
            }
            try {
                this.lastTap = this.currentImage.fd.read(this.tapBuffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            this.nextTap = 0L;
            if (this.nextTap >= this.lastTap) {
                return false;
            }
        }
        return true;
    }

    private boolean moveBufferBack(int offset) {
        if (this.nextTap + (long)offset < 0L) {
            this.nextTap = this.currentImage.currentFilePosition >= 100000L ? 100000L : this.currentImage.currentFilePosition;
            try {
                this.currentImage.fd.seek(this.currentImage.currentFilePosition - this.nextTap + (long)this.currentImage.offset);
            }
            catch (IOException e) {
                System.err.println("Cannot read in tap-file.");
                return false;
            }
            try {
                this.lastTap = this.currentImage.fd.read(this.tapBuffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (this.nextTap > this.lastTap) {
                return false;
            }
        }
        return true;
    }

    private boolean fetchGap(GapDir gd, long readTap) {
        if (readTap >= this.lastTap || readTap < 0L) {
            return false;
        }
        gd.gap = this.tapBuffer[(int)readTap] & 0xFF;
        if (this.currentImage.version == 0 || gd.gap != 0L) {
            gd.gap <<= 3;
        } else {
            if (readTap >= this.lastTap - 3L) {
                return false;
            }
            gd.dir *= 4;
            gd.gap = (this.tapBuffer[(int)(readTap + 1L)] & 0xFF) + ((this.tapBuffer[(int)(readTap + 2L)] & 0xFF) << 8) + ((this.tapBuffer[(int)(readTap + 3L)] & 0xFF) << 16);
        }
        if (0L == gd.gap) {
            gd.gap = this.zeroGapDelay;
        }
        return true;
    }

    private long readGapForward() {
        return this.nextTap;
    }

    private long readGapBackwardV0() {
        return this.nextTap - 1L;
    }

    private long readGapBackwardV1(long readTap) throws Exception {
        long rememberFileSeekPosition = this.currentImage.currentFilePosition;
        this.currentImage.currentFilePosition -= 4L;
        this.nextTap -= 4L;
        int nonZerosInARow = 0;
        while (nonZerosInARow < 3 && this.currentImage.currentFilePosition != 0L) {
            if (!this.moveBufferBack(-1)) {
                return readTap;
            }
            --this.currentImage.currentFilePosition;
            --this.nextTap;
            if (this.tapBuffer[(int)this.nextTap] != 0) {
                ++nonZerosInARow;
                continue;
            }
            nonZerosInARow = 0;
        }
        while (this.currentImage.currentFilePosition < rememberFileSeekPosition - 4L) {
            if (!this.moveBufferForward(1)) {
                throw new Exception();
            }
            if (this.tapBuffer[(int)this.nextTap] != 0) {
                ++this.currentImage.currentFilePosition;
                ++this.nextTap;
                continue;
            }
            this.currentImage.currentFilePosition += 4L;
            this.nextTap += 4L;
        }
        if (!this.moveBufferForward(4)) {
            throw new Exception();
        }
        long newReadTap = this.nextTap;
        this.nextTap += rememberFileSeekPosition - this.currentImage.currentFilePosition;
        this.currentImage.currentFilePosition = rememberFileSeekPosition;
        return newReadTap;
    }

    private long readGap(int direction) {
        GapDir gapDir;
        long readTap = 0L;
        long gap = 0L;
        if (this.currentImage.system != 2) {
            if (direction < 0 && !this.moveBufferBack(direction * 4)) {
                return 0L;
            }
            if (direction > 0 && !this.moveBufferForward(direction * 4)) {
                return 0L;
            }
            if (direction > 0) {
                readTap = this.readGapForward();
            } else if (this.currentImage.version == 0 || this.nextTap < 4L || 0 != this.tapBuffer[(int)(this.nextTap - 4L)]) {
                readTap = this.readGapBackwardV0();
            } else {
                try {
                    readTap = this.readGapBackwardV1(readTap);
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            gapDir = new GapDir(gap, direction);
            if (!this.fetchGap(gapDir, readTap)) {
                return 0L;
            }
            gap = gapDir.gap;
            direction = gapDir.dir;
            this.nextTap += (long)direction;
            this.currentImage.currentFilePosition += (long)direction;
        }
        if (this.currentImage.system == 2 && this.currentImage.version == 1) {
            if (0 == this.fullwave) {
                if (direction < 0 && !this.moveBufferBack(direction * 4)) {
                    return 0L;
                }
                if (direction > 0 && !this.moveBufferForward(direction * 4)) {
                    return 0L;
                }
                if (direction > 0) {
                    readTap = this.readGapForward();
                } else if (this.currentImage.version == 0 || this.nextTap < 4L || 0 != this.tapBuffer[(int)(this.nextTap - 4L)]) {
                    readTap = this.readGapBackwardV0();
                } else {
                    try {
                        readTap = this.readGapBackwardV1(readTap);
                    }
                    catch (Exception e) {
                        return 0L;
                    }
                }
                gapDir = new GapDir(gap, direction);
                if (!this.fetchGap(gapDir, readTap)) {
                    return 0L;
                }
                gap = gapDir.gap;
                direction = gapDir.dir;
                this.fullwaveGap = gap;
                this.nextTap += (long)direction;
                this.currentImage.currentFilePosition += (long)direction;
            } else {
                gap = this.fullwaveGap;
            }
            this.fullwave ^= 1;
        } else if (this.currentImage.system == 2 && this.currentImage.version == 2) {
            if (direction < 0 && !this.moveBufferBack(direction * 4)) {
                return 0L;
            }
            if (direction > 0 && !this.moveBufferForward(direction * 4)) {
                return 0L;
            }
            if (direction > 0) {
                readTap = this.readGapForward();
            } else if (this.currentImage.version == 0 || this.nextTap < 4L || 0 != this.tapBuffer[(int)(this.nextTap - 4L)]) {
                readTap = this.readGapBackwardV0();
            } else {
                try {
                    readTap = this.readGapBackwardV1(readTap);
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            gapDir = new GapDir(gap, direction);
            if (!this.fetchGap(gapDir, readTap)) {
                return 0L;
            }
            gap = gapDir.gap;
            direction = gapDir.dir;
            gap *= 2L;
            this.fullwave ^= 1;
            this.nextTap += (long)direction;
            this.currentImage.currentFilePosition += (long)direction;
        }
        return gap;
    }

    protected void readBit() throws IOException {
        long gap;
        double speedOfTape = 0.0476;
        int direction = 1;
        this.context.cancel(this.event);
        if (this.currentImage == null) {
            return;
        }
        if (this.motorStopClk > 0L && this.context.getTime(Event.Phase.PHI1) >= this.motorStopClk) {
            this.motorStopClk = 0L;
            this.motor = false;
        }
        if (!this.motor) {
            return;
        }
        switch (this.mode) {
            case START: {
                direction = 1;
                speedOfTape = 0.0476;
                this.setFlag(0L == this.longGapPending);
                break;
            }
            case FORWARD: {
                direction = 1;
                speedOfTape = 7.619047619047619 * Math.sqrt(7.596622363792407E-6 / this.context.getCyclesPerSecond() * (double)this.currentImage.cycleCounter + 0.0045198840315228824);
                break;
            }
            case REWIND: {
                direction = -1;
                speedOfTape = 7.619047619047619 * Math.sqrt(7.596622363792407E-6 / this.context.getCyclesPerSecond() * (double)(this.currentImage.cycleCounterTotal - this.currentImage.cycleCounter) + 0.0045198840315228824);
                break;
            }
            case RECORD: 
            case STOP: {
                return;
            }
            default: {
                System.err.println("Unknown datasette mode.");
                return;
            }
        }
        if (direction + this.lastDirection == 0) {
            gap = this.readGap(direction);
            this.longGapPending = this.longGapElapsed;
            this.longGapElapsed = gap - this.longGapElapsed;
        }
        if (this.longGapPending != 0L) {
            gap = this.longGapPending;
            this.longGapPending = 0L;
        } else {
            gap = this.readGap(direction);
            if (gap != 0L) {
                this.longGapElapsed = 0L;
            }
        }
        if (0L == gap) {
            this.control(Control.STOP);
            return;
        }
        if (gap > 100000L) {
            this.longGapPending = gap - 100000L;
            gap = 100000L;
        }
        this.longGapElapsed += gap;
        this.lastDirection = direction;
        this.currentImage.cycleCounter = direction > 0 ? (int)((long)this.currentImage.cycleCounter + gap) : (int)((long)this.currentImage.cycleCounter - gap);
        this.context.schedule(this.event, (long)((double)gap * 0.0476 / speedOfTape));
        this.updateCounter();
    }

    public final void setTapeImage(Tap image) throws IOException {
        this.currentImage = image;
        this.nextTap = 0L;
        this.lastTap = 0L;
        this.internalReset();
        if (image != null) {
            long gap;
            this.currentImage.cycleCounterTotal = 0;
            do {
                gap = this.readGap(1);
                this.currentImage.cycleCounterTotal = (int)((long)this.currentImage.cycleCounterTotal + gap);
            } while (gap != 0L);
            this.currentImage.currentFilePosition = 0L;
            this.nextTap = 0L;
            this.lastTap = 0L;
            this.fullwave = 0;
        }
    }

    protected void forward() {
        if (this.context.isPending(this.event)) {
            this.context.cancel(this.event);
        }
        this.context.schedule(this.event, 1000L);
    }

    protected void rewind() {
        if (this.context.isPending(this.event)) {
            this.context.cancel(this.event);
        }
        this.context.schedule(this.event, 1000L);
    }

    protected void internalReset() throws IOException {
        if (this.currentImage != null) {
            if (this.mode == Control.START || this.mode == Control.FORWARD || this.mode == Control.REWIND) {
                this.context.cancel(this.event);
            }
            this.control(Control.STOP);
            this.currentImage.seekStart();
            this.currentImage.cycleCounter = 0;
            this.counterOffset = 0;
            this.longGapPending = 0L;
            this.longGapElapsed = 0L;
            this.lastDirection = 0;
            this.motorStopClk = 0L;
            this.updateCounter();
            this.fullwave = 0;
            this.lastCounter = -1;
        }
    }

    public final void reset() {
        if (this.resetDatasetteWithMainCPU) {
            try {
                this.internalReset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void startMotor() throws IOException {
        this.currentImage.fd.seek(this.currentImage.currentFilePosition + (long)this.currentImage.offset);
        if (!this.context.isPending(this.event)) {
            this.context.schedule(this.event, 32000L);
        }
    }

    public final void control(final Control command) {
        if (this.currentImage == null) {
            return;
        }
        this.context.scheduleThreadSafe(new Event("Datasette command"){

            @Override
            public void event() {
                try {
                    switch (command) {
                        case RESET_COUNTER: {
                            Datasette.this.resetCounter();
                            break;
                        }
                        case RESET: {
                            Datasette.this.internalReset();
                        }
                        case STOP: {
                            Datasette.this.mode = Control.STOP;
                            Datasette.this.lastWriteClk = 0L;
                            break;
                        }
                        case START: {
                            Datasette.this.mode = Control.START;
                            Datasette.this.lastWriteClk = 0L;
                            if (!Datasette.this.motor) break;
                            Datasette.this.startMotor();
                            break;
                        }
                        case FORWARD: {
                            Datasette.this.mode = Control.FORWARD;
                            Datasette.this.forward();
                            Datasette.this.lastWriteClk = 0L;
                            if (!Datasette.this.motor) break;
                            Datasette.this.startMotor();
                            break;
                        }
                        case REWIND: {
                            Datasette.this.mode = Control.REWIND;
                            Datasette.this.rewind();
                            Datasette.this.lastWriteClk = 0L;
                            if (!Datasette.this.motor) break;
                            Datasette.this.startMotor();
                            break;
                        }
                        case RECORD: {
                            if (Datasette.this.currentImage.isReadOnly()) break;
                            Datasette.this.mode = Control.RECORD;
                            Datasette.this.lastWriteClk = 0L;
                            break;
                        }
                        default: {
                            System.err.println("Unknown datasette mode.");
                        }
                    }
                    Datasette.this.nextTap = 0L;
                    Datasette.this.lastTap = 0L;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public final void setMotor(boolean flag) {
        if (this.currentImage != null) {
            if (flag) {
                this.motorStopClk = 0L;
                if (!this.motor) {
                    this.lastWriteClk = 0L;
                    try {
                        this.startMotor();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.motor = true;
                }
            }
            if (!flag && this.motor && this.motorStopClk == 0L) {
                this.motorStopClk = this.context.getTime(Event.Phase.PHI1) + 32000L;
                if (!this.context.isPending(this.event)) {
                    this.context.scheduleAbsolute(this.event, this.motorStopClk, Event.Phase.PHI1);
                }
            }
        }
    }

    private void bitWrite() throws IOException {
        long clk = this.context.getTime(Event.Phase.PHI1);
        long writeTime = clk - this.lastWriteClk;
        if (writeTime < 8L) {
            return;
        }
        if (writeTime < 2048L) {
            this.lastWriteClk += writeTime & 0x7F8L;
            byte writeGap = (byte)(writeTime >> 3);
            try {
                this.currentImage.fd.write(writeGap);
            }
            catch (IOException e) {
                this.control(Control.STOP);
                return;
            }
            ++this.currentImage.currentFilePosition;
        } else {
            this.lastWriteClk = clk;
            try {
                this.currentImage.fd.write(0);
            }
            catch (IOException e) {
                this.control(Control.STOP);
                return;
            }
            ++this.currentImage.currentFilePosition;
            if (this.currentImage.version >= 1) {
                byte[] longGap = new byte[]{(byte)(writeTime & 0xFFL), (byte)(writeTime >> 8 & 0xFFL), (byte)(writeTime >> 16 & 0xFFL)};
                try {
                    this.currentImage.fd.write(longGap);
                }
                catch (IOException e) {
                    this.control(Control.STOP);
                    return;
                }
                this.currentImage.currentFilePosition += (long)longGap.length;
            }
        }
        if (this.currentImage.size < this.currentImage.currentFilePosition) {
            this.currentImage.size = this.currentImage.currentFilePosition;
        }
        this.currentImage.cycleCounter = (int)((long)this.currentImage.cycleCounter + writeTime);
        if (this.currentImage.cycleCounterTotal < this.currentImage.cycleCounter) {
            this.currentImage.cycleCounterTotal = this.currentImage.cycleCounter;
        }
        this.currentImage.hasChanged = true;
        this.updateCounter();
    }

    public final void toggleWriteBit(boolean writeBit) {
        if (this.currentImage != null && writeBit && this.mode == Control.RECORD && this.motor) {
            if (this.lastWriteClk == 0L) {
                this.lastWriteClk = this.context.getTime(Event.Phase.PHI2);
            } else {
                try {
                    this.bitWrite();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean getMotor() {
        return this.motor;
    }

    public int getCounter() {
        if (this.currentImage == null) {
            return 0;
        }
        return this.currentImage.counter;
    }

    public int getProgress() {
        if (!this.motor) {
            return 100;
        }
        if (this.currentImage == null || this.currentImage.cycleCounterTotal == 0) {
            return 0;
        }
        return (int)((float)this.currentImage.cycleCounter / (float)this.currentImage.cycleCounterTotal * 100.0f);
    }

    public boolean getTapeSense() {
        return this.mode != Control.STOP;
    }

    public abstract void setFlag(boolean var1);

    public OvImageIcon getIcon() {
        if (this.motor && this.mode == Control.START) {
            return datasette_g;
        }
        if (this.motor && this.mode == Control.RECORD) {
            return datasette_r;
        }
        return datasette;
    }

    public static enum Control {
        STOP,
        START,
        FORWARD,
        REWIND,
        RECORD,
        RESET,
        RESET_COUNTER;

    }

    protected static final class GapDir {
        protected long gap;
        protected int dir;

        protected GapDir(long g, int d) {
            this.gap = g;
            this.dir = d;
        }
    }
}

