/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components;

import applet.filefilter.DiskFileFilter;
import applet.filefilter.TuneFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import libsidplay.components.DirEntry;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.cart.Cartridge;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.T64;
import libsidutils.zip.ZipEntryFileProxy;
import sidplay.ini.IniConfig;

public class Directory {
    private boolean singleSided = true;
    private byte[] title;
    private byte[] id;
    private List<DirEntry> dirEntries = new ArrayList<DirEntry>();
    private int freeBlocks = -1;
    private String statusLine;
    private static TuneFileFilter tuneFilter = new TuneFileFilter();
    private static DiskFileFilter diskFilter = new DiskFileFilter();

    public void setTitle(byte[] diskName) {
        this.title = diskName;
    }

    public void setId(byte[] diskID) {
        this.id = diskID;
    }

    public void setSingleSided(boolean single) {
        this.singleSided = single;
    }

    public void setFreeBlocks(int blocks) {
        this.freeBlocks = blocks;
    }

    public List<DirEntry> getDirEntries() {
        return this.dirEntries;
    }

    public String getStatusLine() {
        if (this.statusLine == null) {
            if (this.freeBlocks != -1) {
                return String.format("%-3d BLOCKS FREE.", this.freeBlocks);
            }
            return null;
        }
        return this.statusLine;
    }

    public void setStatusLine(String line) {
        this.statusLine = line;
    }

    public String toString() {
        StringBuilder header = new StringBuilder();
        header.append(this.singleSided ? "0 " : "1 ");
        header.append(DirEntry.convertFilename(this.title, -1));
        if (this.id != null) {
            header.append(" ");
            for (int i = 0; i < this.id.length; ++i) {
                header.append((char)(this.id[i] & 0xFF));
            }
        }
        return header.toString();
    }

    public static final Directory getDirectory(File file, IniConfig cfg) throws IOException {
        if (file.getName().toLowerCase().endsWith(".gz")) {
            return Directory.gzToDir(file, cfg);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return Directory.zipToDir(file);
        }
        if (diskFilter.accept(file)) {
            return DiskImage.getDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".t64")) {
            return T64.getDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".crt")) {
            return Cartridge.getDirectory(file);
        }
        if (tuneFilter.accept(file)) {
            return SidTune.getDirectory(file, cfg);
        }
        return null;
    }

    protected static Directory gzToDir(File file, IniConfig cfg) throws IOException {
        File outFile = ZipEntryFileProxy.extractFromGZ(file);
        return Directory.getDirectory(outFile, cfg);
    }

    protected static Directory zipToDir(File file) throws ZipException, IOException {
        Directory dir = new Directory();
        dir.setId(null);
        byte[] diskName = DirEntry.asciiTopetscii(Directory.getShortenedString(file.getName(), 20), Integer.MAX_VALUE);
        dir.setTitle(diskName);
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            String dirEntryStr = ze.getName();
            dirEntryStr = Directory.getShortenedString(dirEntryStr, 20);
            DirEntry dirEntry = new DirEntry(0, DirEntry.asciiTopetscii(dirEntryStr, Integer.MAX_VALUE), -1){

                @Override
                public void save(File autostartFile) throws IOException {
                }
            };
            dir.getDirEntries().add(dirEntry);
        }
        zf.close();
        String hint = "PLEASE ENTER ZIP LIKE A DIR.";
        dir.setStatusLine(hint);
        return dir;
    }

    protected static String getShortenedString(String str, int max) {
        int extIdx = str.lastIndexOf(46);
        if (str.length() > max && extIdx != -1) {
            str = str.substring(0, Math.min(max - str.substring(extIdx).length(), extIdx)) + str.substring(extIdx);
        }
        return str;
    }
}

