/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import resid_builder.resid.ISIDDefs;

public abstract class SIDEmu {
    protected final EventScheduler context;
    protected long lastTime;
    private final byte[] registers = new byte[32];

    public SIDEmu(EventScheduler context) {
        this.context = context;
    }

    public byte readInternalRegister(int addr) {
        return this.registers[addr];
    }

    public void write(int addr, byte data) {
        this.registers[addr] = data;
    }

    protected int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastTime);
        this.lastTime = now;
        return diff;
    }

    public abstract void reset(byte var1);

    public abstract byte read(int var1);

    public abstract void clock();

    public abstract void setEnabled(int var1, boolean var2);

    public abstract void setFilter(boolean var1);

    public abstract ISIDDefs.ChipModel getChipModel();
}

