/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.nio.ByteBuffer;
import java.util.HashMap;

public class Reloc65 {
    private static final int BUF = 26;
    private final File65 file = new File65();
    private final char[] cmp = new char[]{'\u0001', '\u0000', 'o', '6', '5'};

    public ByteBuffer reloc65(byte[] buf, int fsize, int addr, HashMap<String, Integer> globals) {
        boolean tflag = false;
        boolean dflag = false;
        boolean bflag = false;
        boolean zflag = false;
        int tbase = 0;
        int dbase = 0;
        int bbase = 0;
        int zbase = 0;
        int extract = 0;
        this.file.globals = globals;
        this.file.buf = buf;
        tflag = true;
        tbase = addr;
        extract = 1;
        for (int i = 0; i < 5; ++i) {
            if ((this.file.buf[i] & 0xFF) == this.cmp[i]) continue;
            return null;
        }
        int mode = (this.file.buf[7] & 0xFF) * 256 + (this.file.buf[6] & 0xFF);
        if ((mode & 0x2000) != 0) {
            return null;
        }
        if ((mode & 0x4000) != 0) {
            return null;
        }
        int hlen = 26 + this.read_options(this.file.buf, 26);
        this.file.tbase = (this.file.buf[9] & 0xFF) * 256 + (this.file.buf[8] & 0xFF);
        this.file.tlen = (this.file.buf[11] & 0xFF) * 256 + (this.file.buf[10] & 0xFF);
        this.file.tdiff = tflag ? tbase - this.file.tbase : 0;
        this.file.dbase = (this.file.buf[13] & 0xFF) * 256 + (this.file.buf[12] & 0xFF);
        this.file.dlen = (this.file.buf[15] & 0xFF) * 256 + (this.file.buf[14] & 0xFF);
        this.file.ddiff = dflag ? dbase - this.file.dbase : 0;
        this.file.bbase = (this.file.buf[17] & 0xFF) * 256 + (this.file.buf[16] & 0xFF);
        this.file.bdiff = bflag ? bbase - this.file.bbase : 0;
        this.file.zbase = (this.file.buf[21] & 0xFF) * 256 + (this.file.buf[20] & 0xFF);
        this.file.zdiff = zflag ? zbase - this.file.zbase : 0;
        this.file.segt = this.file.buf;
        int segtPos = hlen;
        this.file.segd = this.file.segt;
        int sedPos = segtPos + this.file.tlen;
        this.file.utab = this.file.segd;
        int utabPos = sedPos + this.file.dlen;
        this.file.rttab = this.file.utab;
        int rttabPos = utabPos + this.read_undef(this.file.utab, utabPos, this.file);
        this.file.rdtab = this.file.rttab;
        this.file.extab = this.file.rdtab;
        int rdtabPos = this.reloc_seg(this.file.segt, segtPos, this.file.tlen, this.file.rttab, rttabPos, this.file);
        int extabPos = this.reloc_seg(this.file.segd, sedPos, this.file.dlen, this.file.rdtab, rdtabPos, this.file);
        this.reloc_globals(this.file.extab, extabPos, this.file);
        if (tflag) {
            this.file.buf[9] = (byte)(tbase >> 8 & 0xFF);
            this.file.buf[8] = (byte)(tbase & 0xFF);
        }
        if (dflag) {
            this.file.buf[13] = (byte)(dbase >> 8 & 0xFF);
            this.file.buf[12] = (byte)(dbase & 0xFF);
        }
        if (bflag) {
            this.file.buf[17] = (byte)(bbase >> 8 & 0xFF);
            this.file.buf[16] = (byte)(bbase & 0xFF);
        }
        if (zflag) {
            this.file.buf[21] = (byte)(zbase >> 8 & 0xFF);
            this.file.buf[20] = (byte)(zbase & 0xFF);
        }
        this.file.ud = null;
        switch (extract) {
            case 0: {
                return ByteBuffer.wrap(buf, 0, fsize);
            }
            case 1: {
                return ByteBuffer.wrap(this.file.segt, segtPos, this.file.tlen);
            }
            case 2: {
                return ByteBuffer.wrap(this.file.segd, sedPos, this.file.dlen);
            }
        }
        return null;
    }

    private int read_options(byte[] buf, int pos) {
        int l = 0;
        int c = buf[pos + 0] & 0xFF;
        while (c != 0) {
            c = buf[pos + (l += (c &= 0xFF))] & 0xFF;
        }
        return ++l;
    }

    private int read_undef(byte[] buf, int pos, File65 fp) {
        int l = 2;
        int n = (buf[pos + 0] & 0xFF) + 256 * (buf[pos + 1] & 0xFF);
        fp.ud = new String[n];
        for (int i = 0; i < n; ++i) {
            byte[] tmp = new byte[32];
            for (int j = 0; j < buf.length; ++j) {
                if (buf[pos + l + j] == 0) {
                    fp.ud[i] = new String(tmp, 0, j);
                    break;
                }
                tmp[j] = buf[pos + l + j];
            }
            while (buf[pos + l++] != 0) {
            }
        }
        return l;
    }

    private int reloc_seg(byte[] buf, int bufPos, int len, byte[] rtab, int rtabPos, File65 fp) {
        int adr = -1;
        while (rtab[rtabPos] != 0) {
            if ((rtab[rtabPos] & 0xFF) == 255) {
                adr += 254;
                ++rtabPos;
                continue;
            }
            adr += rtab[rtabPos] & 0xFF;
            int type = rtab[++rtabPos] & 0xE0;
            int seg = rtab[rtabPos] & 7;
            ++rtabPos;
            switch (type) {
                case 128: {
                    int old = (buf[bufPos + adr] & 0xFF) + 256 * (buf[bufPos + adr + 1] & 0xFF);
                    int newv = seg != 0 ? old + this.reldiff(seg, fp) : old + Reloc65.find_global(rtab, rtabPos, fp);
                    buf[bufPos + adr] = (byte)(newv & 0xFF);
                    buf[bufPos + adr + 1] = (byte)(newv >> 8 & 0xFF);
                    break;
                }
                case 64: {
                    int old = (buf[bufPos + adr] & 0xFF) * 256 + (rtab[rtabPos] & 0xFF);
                    int newv = seg != 0 ? old + this.reldiff(seg, fp) : old + Reloc65.find_global(rtab, rtabPos, fp);
                    buf[bufPos + adr] = (byte)(newv >> 8 & 0xFF);
                    rtab[rtabPos] = (byte)(newv & 0xFF);
                    ++rtabPos;
                    break;
                }
                case 32: {
                    int old = buf[bufPos + adr] & 0xFF;
                    int newv = seg != 0 ? old + this.reldiff(seg, fp) : old + Reloc65.find_global(rtab, rtabPos, fp);
                    buf[bufPos + adr] = (byte)(newv & 0xFF);
                }
            }
            if (seg != 0) continue;
            rtabPos += 2;
        }
        if (adr > len) {
            System.err.println("reloc65: Warning: relocation table entries past segment end!\n");
        }
        return ++rtabPos;
    }

    static int find_global(byte[] bp, int bpPos, File65 fp) {
        int nl = (bp[bpPos + 0] & 0xFF) + 256 * (bp[bpPos + 1] & 0xFF);
        String name = fp.ud[nl];
        return fp.globals.get(name);
    }

    private int reloc_globals(byte[] buf, int bufPos, File65 fp) {
        int n = (buf[bufPos + 0] & 0xFF) + 256 * (buf[bufPos + 1] & 0xFF);
        bufPos += 2;
        while (n != 0) {
            while (buf[bufPos++] != 0) {
            }
            int seg = buf[bufPos] & 0xFF;
            int old = (buf[bufPos + 1] & 0xFF) + 256 * (buf[bufPos + 2] & 0xFF);
            int newv = seg != 0 ? old + this.reldiff(seg, fp) : old + Reloc65.find_global(buf, bufPos + 1, fp);
            buf[bufPos + 1] = (byte)(newv & 0xFF);
            buf[bufPos + 2] = (byte)(newv >> 8 & 0xFF);
            bufPos += 3;
            --n;
        }
        return bufPos;
    }

    private int reldiff(int s, File65 fp) {
        return s == 2 ? fp.tdiff : (s == 3 ? fp.ddiff : (s == 4 ? fp.bdiff : (s == 5 ? fp.zdiff : 0)));
    }

    static class File65 {
        byte[] buf;
        int tbase;
        int tlen;
        int dbase;
        int dlen;
        int bbase;
        int zbase;
        int tdiff;
        int ddiff;
        int bdiff;
        int zdiff;
        public String[] ud;
        byte[] segt;
        byte[] segd;
        byte[] utab;
        byte[] rttab;
        byte[] rdtab;
        byte[] extab;
        HashMap<String, Integer> globals;

        File65() {
        }
    }
}

