/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import hardsid_builder.HardSIDBuilder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import libsidplay.C1541Runner;
import libsidplay.C64;
import libsidplay.SameThreadC1541Runner;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.ISID2Types;
import libsidplay.common.SIDEmu;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.DisconnectedParallelCable;
import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.iec.IECBus;
import libsidplay.components.iec.SerialIECDevice;
import libsidplay.components.mos6510.IMOS6510Disassembler;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos6526.MOS6526;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.printer.mps803.MPS803;
import libsidplay.sidtune.SidTune;
import resid_builder.ReSID;

public class Player {
    protected final C64 c64;
    protected final Datasette datasette;
    protected final IECBus iecBus = new IECBus();
    protected final SerialIECDevice[] serialDevices;
    protected final C1541[] floppies;
    protected final C1541Runner c1541Runner;
    protected final MPS803 printer = new MPS803(this.iecBus, 4, 7){

        @Override
        public void setBusy(boolean flag) {
            Player.this.c64.cia2.setFlag(flag);
        }

        @Override
        public long clk() {
            return Player.this.c64.context.getTime(Event.Phase.PHI2);
        }
    };
    protected SidTune tune;
    protected String command;
    protected boolean printerEnabled;
    protected boolean drivesEnabled;

    public Player() {
        this.c64 = new C64(){

            @Override
            public void printerUserportWriteData(byte data) {
                if (Player.this.printerEnabled) {
                    Player.this.printer.printerUserportWriteData(data);
                }
            }

            @Override
            public void printerUserportWriteStrobe(boolean strobe) {
                if (Player.this.printerEnabled) {
                    Player.this.printer.printerUserportWriteStrobe(strobe);
                }
            }

            @Override
            public byte readFromIECBus() {
                if (Player.this.drivesEnabled) {
                    Player.this.c1541Runner.synchronize(0L);
                    return Player.this.iecBus.readFromIECBus();
                }
                return -128;
            }

            @Override
            public void writeToIECBus(byte data) {
                if (Player.this.drivesEnabled) {
                    Player.this.c1541Runner.synchronize(1L);
                    Player.this.iecBus.writeToIECBus(data);
                }
            }

            @Override
            public boolean getTapeSense() {
                return Player.this.datasette.getTapeSense();
            }

            @Override
            public void setMotor(boolean state) {
                Player.this.datasette.setMotor(state);
            }

            @Override
            public void toggleWriteBit(boolean state) {
                Player.this.datasette.toggleWriteBit(state);
            }
        };
        this.datasette = new Datasette(this.c64.getEventScheduler()){

            @Override
            public void setFlag(boolean flag) {
                Player.this.c64.cia1.setFlag(flag);
            }
        };
        C1541 c1541 = new C1541(this.iecBus, 8, C1541.FloppyType.C1541);
        this.floppies = new C1541[]{c1541};
        this.serialDevices = new SerialIECDevice[]{this.printer};
        this.iecBus.setFloppies(this.floppies);
        this.iecBus.setSerialDevices(this.serialDevices);
        this.c1541Runner = new SameThreadC1541Runner(this.c64.getEventScheduler(), c1541.getEventScheduler());
        this.connectC64AndC1541WithParallelCable(false);
    }

    public void setClock(ISID2Types.Clock cpuFreq) {
        this.c64.setClock(cpuFreq);
        this.c1541Runner.setClockDivider(cpuFreq);
        for (SerialIECDevice device : this.serialDevices) {
            device.setClock(cpuFreq);
        }
    }

    public void reset() throws InterruptedException {
        this.c64.reset();
        this.iecBus.reset();
        this.datasette.reset();
        for (C1541 floppy : this.floppies) {
            floppy.reset();
        }
        this.enableFloppyDiskDrives(this.drivesEnabled);
        for (SerialIECDevice serialDevice : this.serialDevices) {
            serialDevice.reset();
        }
        if (this.tune != null) {
            this.c64.setPlayAddr(this.tune.getInfo().playAddr);
            this.c64.getEventScheduler().schedule(new Event("Tune init event"){

                @Override
                public void event() throws InterruptedException {
                    byte[] ram = Player.this.c64.getRAM();
                    int address = Player.this.tune.placeProgramInMemory(ram);
                    if (address != -1) {
                        for (int i = 0; i < 2; ++i) {
                            SIDEmu s = Player.this.c64.getSID(i);
                            if (s == null) continue;
                            s.write(24, (byte)15);
                        }
                        Player.this.c64.getCPU().forcedJump(address);
                    } else {
                        ram[631] = 82;
                        ram[632] = 85;
                        ram[633] = 78;
                        ram[634] = 58;
                        ram[635] = 13;
                        ram[198] = 5;
                    }
                }
            }, this.tune.getInitDelay());
        } else {
            this.c64.getEventScheduler().schedule(new Event("Autostart event"){

                @Override
                public void event() throws InterruptedException {
                    if (Player.this.command != null) {
                        byte[] ram = Player.this.c64.getRAM();
                        for (int i = 0; i < Math.min(Player.this.command.length(), 16); ++i) {
                            ram[631 + i] = (byte)Player.this.command.charAt(i);
                        }
                        ram[198] = (byte)Math.min(Player.this.command.length(), 16);
                        if (Player.this.command.startsWith("LOAD\r")) {
                            Player.this.datasette.control(Datasette.Control.START);
                        }
                        Player.this.command = null;
                    }
                }
            }, 2500000L);
        }
    }

    public void play(int numOfEvents) throws InterruptedException {
        for (int i = 0; i < numOfEvents; ++i) {
            this.c64.getEventScheduler().clock();
        }
    }

    public int time() {
        EventScheduler c = this.c64.getEventScheduler();
        return (int)((double)c.getTime(Event.Phase.PHI2) / c.getCyclesPerSecond());
    }

    public void mute(int sidNum, int voice, boolean enable) {
        SIDEmu s = this.c64.getSID(sidNum);
        if (s != null) {
            s.setEnabled(voice, enable);
        }
    }

    public void turnPrinterOnOff(boolean on) {
        this.printerEnabled = on;
        this.printer.turnPrinterOnOff(on);
    }

    public void enableFloppyDiskDrives(final boolean on) {
        for (C1541 floppy : this.floppies) {
            floppy.setPowerOn(on);
        }
        if (on) {
            this.c64.getEventScheduler().scheduleThreadSafe(new Event("Begin C64-C1541 sync"){

                @Override
                public void event() {
                    Player.this.c1541Runner.reset();
                    Player.this.drivesEnabled = on;
                }
            });
        } else {
            this.c64.getEventScheduler().scheduleThreadSafe(new Event("End C64-C1541 sync"){

                @Override
                public void event() {
                    Player.this.c1541Runner.cancel();
                    Player.this.drivesEnabled = on;
                }
            });
        }
    }

    public void connectC64AndC1541WithParallelCable(boolean connected) {
        IParallelCable cable = connected ? this.makeCableBetweenC64AndC1541() : new DisconnectedParallelCable();
        this.c64.setParallelCable(cable);
        for (C1541 floppy : this.floppies) {
            floppy.getBusController().setParallelCable(cable);
        }
    }

    private final IParallelCable makeCableBetweenC64AndC1541() {
        return new IParallelCable(){
            protected byte parallelCableCpuValue = (byte)-1;
            protected final byte[] parallelCableDriveValue = new byte[]{-1, -1, -1, -1};

            @Override
            public void driveWrite(byte data, boolean handshake, int dnr) {
                Player.this.c64.cia2.setFlag(handshake);
                this.parallelCableDriveValue[dnr & 0xFFFFFFF7] = data;
            }

            @Override
            public byte driveRead(boolean handshake) {
                Player.this.c64.cia2.setFlag(handshake);
                return this.parallelCableValue();
            }

            private byte parallelCableValue() {
                byte val = this.parallelCableCpuValue;
                for (C1541 floppy : Player.this.floppies) {
                    val = (byte)(val & this.parallelCableDriveValue[floppy.getID() & 0xFFFFFFF7]);
                }
                return val;
            }

            @Override
            public void c64Write(byte data) {
                Player.this.c1541Runner.synchronize(0L);
                this.parallelCableCpuValue = data;
            }

            @Override
            public byte c64Read() {
                Player.this.c1541Runner.synchronize(0L);
                return this.parallelCableValue();
            }

            @Override
            public void pulse() {
                Player.this.c1541Runner.synchronize(0L);
                for (C1541 floppy : Player.this.floppies) {
                    floppy.getBusController().signal(2, 0);
                }
            }
        };
    }

    public void installJiffyDOS(InputStream c64KernalStream, InputStream c1541KernalStream) throws IOException {
        DataInputStream dis = null;
        byte[] c64Kernal = new byte[8192];
        try {
            dis = new DataInputStream(c64KernalStream);
            dis.readFully(c64Kernal);
            this.getC64().setCustomKernal(c64Kernal);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
        dis = null;
        byte[] c1541Kernal = new byte[16384];
        try {
            dis = new DataInputStream(c1541KernalStream);
            dis.readFully(c1541Kernal);
            for (C1541 floppy : this.floppies) {
                floppy.setCustomKernalRom(c1541Kernal);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public void uninstallJiffyDOS() throws IOException {
        this.getC64().setCustomKernal(null);
        for (C1541 floppy : this.floppies) {
            floppy.setCustomKernalRom(null);
        }
    }

    public final void setDebug(IMOS6510Disassembler disassembler) {
        this.c64.getCPU().setDebug(disassembler);
    }

    public final C64 getC64() {
        return this.c64;
    }

    public Datasette getDatasette() {
        return this.datasette;
    }

    public C1541[] getFloppies() {
        return this.floppies;
    }

    public final MPS803 getPrinter() {
        return this.printer;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public void setTune(SidTune tune) {
        this.tune = tune;
    }

    public final SidTune getTune() {
        return this.tune;
    }

    public String getCredits() {
        StringBuffer credits = new StringBuffer();
        credits.append("Java Version and User Interface (v2.5):\n\tCopyright (C) 2007-2011 Ken H\u00e4ndel\n\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("Distortion Simulation and development: Antti S. Lankila\n\thttp://bel.fi/~alankila/c64-sw/\n");
        credits.append("Network SID Device:\n\tSupported by Wilfred Bos, The Netherlands\n\thttp://www.acid64.com\n");
        credits.append("Testing and Feedback: Nata, founder of proNoise\n\thttp://www.nata.netau.net/\n");
        credits.append("graphical output:\n\t(C) 2007 Joakim Eriksson\n\t(C) 2009, 2010 Antti S. Lankila\n");
        credits.append("MP3 encoder/decoder (jump3r), based on Lame\n\tCopyright (C) 2010-2011  Ken H\u00e4ndel\n\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("This product uses the database of Game Base 64 (GB64)\n\thttp://www.gb64.com/\n");
        credits.append("MP3 downloads from Stone Oakvalley's Authentic SID Collection (SOASC=):\n\thttp://www.6581-8580.com/\n");
        credits.append("This product includes software developed by the SWIXML Project\n\thttp://www.swixml.org/\n");
        credits.append("Drag and Drop support: Robert Harder\n\thttp://iharder.sourceforge.net\n");
        credits.append("PSID to PRG converter (PSID64 v0.9):\n\tCopyright (C) 2001-2007  Roland Hermans\n\thttp://sourceforge.net/projects/psid64/\n");
        credits.append("Video-Capture (QuickTimeDemo):\n\tCopyright (C) 2008-2010  Werner Randelshofer\n\thttp://www.randelshofer.ch/\n");
        credits.append("An Optimizing Hybrid LZ77 RLE Data Compression Program (Pucrunch 22.11.2008):\n\tCopyright (C) 1997-2008 Pasi 'Albert' Ojala\n\thttp://www.cs.tut.fi/~albert/Dev/pucrunch/\n");
        credits.append("SID dump file (SIDDump V1.04):\n\tCopyright (C) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("HVSC playroutine identity scanner (SIDId V1.07):\n\tCopyright (C) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("High Voltage Music Engine Collection (HVMEC V1.0):\n\tCopyright (C) 2011 by Stefano Tognon and Stephan Parth\n");
        credits.append("C1541 Floppy Disk Drive Emulation:\n\tCopyright (C) 2010 VICE (the Versatile Commodore Emulator)\n\thttp://www.viceteam.org/\n");
        credits.append("Based on libsidplay v2.1.1 engine:\n\tCopyright (C) 2000 Simon White sidplay2@yahoo.com\n\thttp://sidplay2.sourceforge.net\n");
        credits.append(MOS6510.credits());
        credits.append(MOS6526.credits());
        credits.append(VIC.credits());
        credits.append(HardSIDBuilder.credits());
        credits.append(ReSID.credits());
        return credits.toString();
    }
}

