/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.IReSIDExtension;
import libsidplay.common.ISID2Types;
import libsidplay.common.SIDEmu;
import libsidplay.components.OvImageIcon;
import libsidplay.components.c1530.DatasetteEnvironment;
import libsidplay.components.c1541.C1541Environment;
import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.supported.GeoRAM;
import libsidplay.components.cart.supported.MMC64;
import libsidplay.components.cart.supported.REU;
import libsidplay.components.joystick.IJoystick;
import libsidplay.components.keyboard.Keyboard;
import libsidplay.components.mos6510.IMOS6510Extension;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos6526.MOS6526;
import libsidplay.components.mos656x.MOS6567;
import libsidplay.components.mos656x.MOS6569;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;
import libsidplay.components.printer.UserportPrinterEnvironment;
import libsidplay.components.ram.SystemRAMBank;

public abstract class C64
implements DatasetteEnvironment,
C1541Environment,
UserportPrinterEnvironment {
    public static final int MAX_SIDS = 2;
    private static final MOS6526.Model CIAMODEL = MOS6526.Model.MOS6526;
    protected ISID2Types.Clock clock;
    protected final PLA pla;
    private final MOS6510 cpu;
    protected final MOS6526 cia1;
    protected final MOS6526 cia2;
    protected final Keyboard keyboard;
    protected IParallelCable parallelCable;
    protected final VIC palVic;
    protected final VIC ntscVic;
    protected final SystemRAMBank ramBank = new SystemRAMBank();
    protected final EventScheduler context;
    protected int callsToPlayRoutine;
    protected int playAddr;
    protected IMOS6510Extension playRoutineObserver;
    protected final IJoystick[] joystickPort = new IJoystick[2];
    private final DisconnectedJoystick disconnectedJoystick = new DisconnectedJoystick();
    private final SIDBank sidBank = new SIDBank();
    private final ZeroRAMBank zeroRAMBank = new ZeroRAMBank();

    public void setPlayAddr(int playAddr) {
        this.playAddr = playAddr;
    }

    public final int callsToPlayRoutineSinceLastTime() {
        int val = this.callsToPlayRoutine;
        this.callsToPlayRoutine = 0;
        return val;
    }

    public final void setParallelCable(IParallelCable parallelCable) {
        this.parallelCable = parallelCable;
    }

    public C64() {
        this.context = new EventScheduler();
        this.pla = new PLA(this.context, this.sidBank, this.zeroRAMBank, this.ramBank);
        this.cpu = new MOS6510(this.context){

            @Override
            public byte cpuRead(int address) {
                return C64.this.pla.cpuRead(address);
            }

            @Override
            public void cpuWrite(int address, byte value) {
                C64.this.pla.cpuWrite(address, value);
            }

            @Override
            protected void doJSR() {
                super.doJSR();
                if (this.Register_ProgramCounter == C64.this.playAddr) {
                    if (C64.this.playRoutineObserver != null) {
                        long time = this.context.getTime(Event.Phase.PHI2);
                        C64.this.playRoutineObserver.fetch(time);
                    }
                    ++C64.this.callsToPlayRoutine;
                }
            }
        };
        this.pla.setCpu(this.cpu);
        this.palVic = new MOS6569(this.pla, this.context);
        this.ntscVic = new MOS6567(this.pla, this.context);
        this.pla.setVic(this.palVic);
        this.cia1 = new MOS6526(this.context, CIAMODEL){

            @Override
            public void interrupt(boolean state) {
                C64.this.pla.setIRQ(state);
            }

            @Override
            public void writePRA(byte data) {
            }

            @Override
            public void writePRB(byte data) {
                if ((data & 0x10) == 0) {
                    C64.this.getVIC().triggerLightpen();
                } else {
                    C64.this.getVIC().clearLightpen();
                }
            }

            @Override
            public byte readPRA() {
                byte prbOut = (byte)(this.regs[1] | ~this.regs[3]);
                prbOut = (byte)(prbOut & C64.this.joystickPort[0].getValue());
                byte kbd = C64.this.keyboard.readColumn(prbOut);
                byte joy = C64.this.joystickPort[1].getValue();
                return (byte)(kbd & joy);
            }

            @Override
            public byte readPRB() {
                byte praOut = (byte)(this.regs[0] | ~this.regs[2]);
                praOut = (byte)(praOut & C64.this.joystickPort[1].getValue());
                byte kbd = C64.this.keyboard.readRow(praOut);
                byte joy = C64.this.joystickPort[0].getValue();
                return (byte)(kbd & joy);
            }

            @Override
            public void pulse() {
            }
        };
        this.pla.setCia1(this.cia1);
        this.cia2 = new MOS6526(this.context, CIAMODEL){

            @Override
            public void interrupt(boolean state) {
                C64.this.pla.setNMI(state);
            }

            @Override
            public void writePRA(byte data) {
                C64.this.pla.setVicMemBase((~data & 3) << 14);
                C64.this.writeToIECBus(~data);
                C64.this.printerUserportWriteStrobe((~data & 4) != 0);
            }

            @Override
            public void writePRB(byte data) {
                C64.this.parallelCable.c64Write(data);
            }

            @Override
            public byte readPRA() {
                return (byte)(C64.this.readFromIECBus() | 0x3F);
            }

            @Override
            public byte readPRB() {
                return C64.this.parallelCable.c64Read();
            }

            @Override
            public void pulse() {
                C64.this.parallelCable.pulse();
                C64.this.printerUserportWriteData(this.regs[1]);
            }

            @Override
            public void reset() {
                super.reset();
                C64.this.printerUserportWriteStrobe(true);
                C64.this.printerUserportWriteData((byte)-1);
            }
        };
        this.pla.setCia2(this.cia2);
        this.keyboard = new Keyboard(){

            @Override
            public void restore() {
                C64.this.pla.setNMI(true);
                C64.this.pla.setNMI(false);
            }
        };
        this.setJoystick(0, null);
        this.setJoystick(1, null);
    }

    public void reset() throws InterruptedException {
        this.context.reset();
        this.keyboard.reset();
        this.pla.reset();
        this.cpu.triggerRST();
        this.cia1.reset();
        this.cia2.reset();
        this.sidBank.reset();
        this.getVIC().reset();
        this.zeroRAMBank.reset();
        this.ramBank.reset();
        this.callsToPlayRoutine = 0;
        this.playAddr = -1;
    }

    public SIDEmu getSID(int chipNo) {
        return this.sidBank.getSID(chipNo);
    }

    public void setSID(int chipNo, SIDEmu sidemu) {
        this.sidBank.setSID(chipNo, sidemu);
    }

    public void setSecondSIDAddress(int secondSidChipBase) {
        this.sidBank.setSIDMapping(54272, 0);
        this.sidBank.setSIDMapping(secondSidChipBase, 1);
    }

    public void setSidWriteListener(int chipNo, IReSIDExtension listener) {
        this.sidBank.setSidWriteListener(chipNo, listener);
    }

    public byte[] getRAM() {
        return this.ramBank.array();
    }

    public MOS6510 getCPU() {
        return this.cpu;
    }

    public void setPlayRoutineObserver(IMOS6510Extension observer) {
        this.playRoutineObserver = observer;
    }

    public VIC getVIC() {
        return this.clock == ISID2Types.Clock.PAL ? this.palVic : this.ntscVic;
    }

    public void setClock(ISID2Types.Clock clock) {
        this.clock = clock;
        this.context.setCyclesPerSecond(clock.getCpuFrequency());
        this.cia1.setDayOfTimeRate(clock.getCyclesPerFrame());
        this.cia2.setDayOfTimeRate(clock.getCyclesPerFrame());
        this.pla.setVic(this.getVIC());
    }

    public ISID2Types.Clock getClock() {
        return this.clock;
    }

    public EventScheduler getEventScheduler() {
        return this.context;
    }

    public void setCustomKernal(final byte[] kernalRom) {
        if (kernalRom == null) {
            this.pla.setCustomKernalRomBank(null);
        } else {
            this.pla.setCustomKernalRomBank(new Bank(){

                @Override
                public byte read(int address) {
                    return kernalRom[address & 0x1FFF];
                }

                @Override
                public void write(int address, byte value) {
                    throw new RuntimeException("This bank should never be mapped to W mode");
                }
            });
        }
    }

    public void insertRAMExpansion(RAMExpansion type, int sizeKB) throws IOException {
        this.pla.setCartridge(null);
        switch (type) {
            case GEORAM: {
                this.pla.setCartridge(new GeoRAM(this.pla, null, sizeKB));
                break;
            }
            case REU: {
                this.pla.setCartridge(REU.readImage(this.pla, null, sizeKB));
                break;
            }
            default: {
                throw new RuntimeException("RAM expansion is not supported.");
            }
        }
    }

    public void insertRAMExpansion(RAMExpansion type, File file) throws IOException {
        this.pla.setCartridge(null);
        FileInputStream is = null;
        try {
            GeoRAM cart;
            is = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(is);
            switch (type) {
                case GEORAM: {
                    long length = file.length();
                    cart = new GeoRAM(this.pla, dis, (int)(length >> 10));
                    break;
                }
                default: {
                    throw new RuntimeException("RAM expansion is not supported.");
                }
            }
            this.pla.setCartridge(cart);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public void insertCartridge(File cartFile) throws IOException {
        this.pla.setCartridge(null);
        FileInputStream is = null;
        try {
            Cartridge cart;
            is = new FileInputStream(cartFile);
            if (cartFile.getName().toLowerCase().endsWith(".reu")) {
                long length = cartFile.length();
                cart = REU.readImage(this.pla, is, (int)(length >> 10));
            } else {
                cart = cartFile.getName().toLowerCase().endsWith(".ima") ? new MMC64(this.pla, cartFile) : Cartridge.readImage(this.pla, is);
            }
            this.pla.setCartridge(cart);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public void ejectCartridge() {
        this.pla.setCartridge(null);
    }

    public Cartridge getCartridge() {
        return this.pla.getCartridge();
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public final void setJoystick(int portNumber, IJoystick joystickReader) {
        this.joystickPort[portNumber] = joystickReader == null ? this.disconnectedJoystick : joystickReader;
    }

    public final boolean isJoystickConnected(int portNumber) {
        return !this.joystickPort[portNumber].equals(this.disconnectedJoystick);
    }

    public OvImageIcon getIcon() {
        return this.pla.getIcon();
    }

    public static enum RAMExpansion {
        GEORAM,
        REU;

    }

    protected class ZeroRAMBank
    extends Bank {
        private byte dir;
        private byte data;
        private byte dataRead;
        private byte dataOut;
        private static final long C64_CPU_DATA_PORT_FALL_OFF_CYCLES = 350000L;
        private long dataSetClkBit6;
        private long dataSetClkBit7;
        private boolean dataSetBit6;
        private boolean dataSetBit7;
        private boolean dataFalloffBit6;
        private boolean dataFalloffBit7;
        private byte oldPortDataOut;
        private byte oldPortWriteBit;

        protected ZeroRAMBank() {
        }

        public void reset() {
            this.oldPortDataOut = (byte)-1;
            this.oldPortWriteBit = (byte)-1;
            this.data = (byte)63;
            this.dataOut = (byte)63;
            this.dataRead = (byte)63;
            this.dir = 0;
            this.dataSetBit6 = false;
            this.dataSetBit7 = false;
            this.dataFalloffBit6 = false;
            this.dataFalloffBit7 = false;
            this.updateCpuPort();
        }

        private void updateCpuPort() {
            this.dataOut = (byte)(this.dataOut & ~this.dir | this.data & this.dir);
            this.dataRead = (byte)((this.data | ~this.dir) & (this.dataOut | 0x17));
            C64.this.pla.setCpuPort(this.dataRead);
            if (0 == (this.dir & 0x20)) {
                this.dataRead = (byte)(this.dataRead & 0xDF);
            }
            if (0 == (this.dir & 0x10) && C64.this.getTapeSense()) {
                this.dataRead = (byte)(this.dataRead & 0xEF);
            }
            if ((this.dir & this.data & 0x20) != this.oldPortDataOut) {
                this.oldPortDataOut = (byte)(this.dir & this.data & 0x20);
                C64.this.setMotor(0 == this.oldPortDataOut);
            }
            if (((~this.dir | this.data) & 8) != this.oldPortWriteBit) {
                this.oldPortWriteBit = (byte)((~this.dir | this.data) & 8);
                C64.this.toggleWriteBit(((~this.dir | this.data) & 8) != 0);
            }
        }

        @Override
        public byte read(int address) {
            if (address == 0) {
                return this.dir;
            }
            if (address == 1) {
                if (this.dataFalloffBit6 || this.dataFalloffBit7) {
                    if (this.dataSetClkBit6 < C64.this.context.getTime(Event.Phase.PHI2)) {
                        this.dataFalloffBit6 = false;
                        this.dataSetBit6 = false;
                    }
                    if (this.dataSetClkBit7 < C64.this.context.getTime(Event.Phase.PHI2)) {
                        this.dataSetBit7 = false;
                        this.dataFalloffBit7 = false;
                    }
                }
                return (byte)(this.dataRead & 255 - (((!this.dataSetBit6 ? 1 : 0) << 6) + ((!this.dataSetBit7 ? 1 : 0) << 7)));
            }
            return C64.this.ramBank.read(address);
        }

        @Override
        public void write(int address, byte value) {
            if (address == 0) {
                if (this.dataSetBit7 && (value & 0x80) == 0 && !this.dataFalloffBit7) {
                    this.dataFalloffBit7 = true;
                    this.dataSetClkBit7 = C64.this.context.getTime(Event.Phase.PHI2) + 350000L;
                }
                if (this.dataSetBit6 && (value & 0x40) == 0 && !this.dataFalloffBit6) {
                    this.dataFalloffBit6 = true;
                    this.dataSetClkBit6 = C64.this.context.getTime(Event.Phase.PHI2) + 350000L;
                }
                if (this.dataSetBit7 && (value & 0x80) != 0 && this.dataFalloffBit7) {
                    this.dataFalloffBit7 = false;
                }
                if (this.dataSetBit6 && (value & 0x40) != 0 && this.dataFalloffBit6) {
                    this.dataFalloffBit6 = false;
                }
                this.dir = value;
                this.updateCpuPort();
                value = C64.this.pla.getDisconnectedBusBank().read(address);
            } else if (address == 1) {
                if ((this.dir & 0x80) != 0 && (value & 0x80) != 0) {
                    this.dataSetBit7 = true;
                }
                if ((this.dir & 0x40) != 0 && (value & 0x40) != 0) {
                    this.dataSetBit6 = true;
                }
                this.data = value;
                this.updateCpuPort();
                value = C64.this.pla.getDisconnectedBusBank().read(address);
            }
            C64.this.ramBank.write(address, value);
        }
    }

    protected class SIDBank
    extends Bank {
        private static final int MAPPER_SIZE = 32;
        private static final int REG_COUNT = 32;
        private final int[] sidmapper = new int[32];
        private final SIDEmu[] sidemu = new SIDEmu[2];
        private final IReSIDExtension[] sidWriteListener = new IReSIDExtension[2];

        protected SIDBank() {
        }

        public void reset() {
            for (SIDEmu s : this.sidemu) {
                if (s == null) continue;
                s.reset((byte)15);
            }
            Arrays.fill(this.sidWriteListener, null);
        }

        public void setSIDMapping(int address, int chipNum) {
            this.sidmapper[address >> 5 & 0x1F] = chipNum;
        }

        public void setSidWriteListener(int chipNum, IReSIDExtension listener) {
            this.sidWriteListener[chipNum] = listener;
        }

        @Override
        public byte read(int address) {
            int chipNum = this.sidmapper[address >> 5 & 0x1F];
            if (this.sidemu[chipNum] != null) {
                return this.sidemu[chipNum].read(address & 0x1F);
            }
            return -1;
        }

        @Override
        public void write(int address, byte value) {
            int chipNum = this.sidmapper[address >> 5 & 0x1F];
            if (this.sidemu[chipNum] != null) {
                this.sidemu[chipNum].write(address & 0x1F, value);
            }
            if (this.sidWriteListener[chipNum] != null) {
                long time = C64.this.context.getTime(Event.Phase.PHI2);
                this.sidWriteListener[chipNum].write(time, chipNum, address & 0x1F, value);
            }
        }

        public SIDEmu getSID(int chipNum) {
            return this.sidemu[chipNum];
        }

        public void setSID(int chipNum, SIDEmu s) {
            this.sidemu[chipNum] = s;
        }
    }

    protected static final class DisconnectedJoystick
    implements IJoystick {
        protected DisconnectedJoystick() {
        }

        @Override
        public byte getValue() {
            return -1;
        }
    }
}

