/*
 * Decompiled with CFR 0.152.
 */
package libpsid64;

public class Screen {
    static final byte[] scrtab = new byte[]{-128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 27, -65, 29, 30, 100, 39, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 93, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 3, 28, -65, 89, 93, -65, 34, 67, 1, 60, -65, 45, 82, 99, 15, -65, 50, 51, 39, 21, -65, -65, 44, 49, 15, 62, -65, -65, -65, 63, 65, 65, 65, 65, 65, 65, 65, 67, 69, 69, 69, 69, 73, 73, 73, 73, -65, 78, 79, 79, 79, 79, 79, 24, 79, 85, 85, 85, 85, 89, -65, -65, 1, 1, 1, 1, 1, 1, 1, 3, 5, 5, 5, 5, 9, 9, 9, 9, -65, 14, 15, 15, 15, 15, 15, -65, 15, 21, 21, 21, 21, 25, -65, 25};
    private static final int m_width = 40;
    private static final int m_height = 25;
    private static final int m_screenSize = 1000;
    private byte[] m_screen = new byte[1000];
    private int m_x;
    private int m_y;

    public void clear() {
        byte c = Screen.iso2scr((short)32);
        for (int i = 0; i < 1000; ++i) {
            this.m_screen[i] = c;
        }
    }

    public void home() {
        this.m_x = 0;
        this.m_y = 0;
    }

    public void move(int x, int y) {
        if (x < 40 && y < 25) {
            this.m_x = x;
            this.m_y = y;
        }
    }

    public void putchar(int c) {
        if (c == 10) {
            this.m_x = 0;
            this.moveDown();
        } else {
            int offs = this.offset(this.m_x, this.m_y);
            this.m_screen[offs] = Screen.iso2scr((short)c);
            this.moveRight();
        }
    }

    public void write(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.putchar(str.charAt(i));
        }
    }

    public void poke(int x, int y, short value) {
        if (x < 40 && y < 25) {
            int offs = this.offset(x, y);
            this.m_screen[offs] = (byte)value;
        }
    }

    public final byte[] getData() {
        return this.m_screen;
    }

    public int getDataSize() {
        return 1000;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public void moveRight() {
        if (this.m_x < 39) {
            ++this.m_x;
        }
    }

    public void moveDown() {
        if (this.m_y < 24) {
            ++this.m_y;
        }
    }

    public static byte iso2scr(short c) {
        return scrtab[c];
    }

    private int offset(int x, int y) {
        return x + 40 * y;
    }
}

