/*
 * Decompiled with CFR 0.152.
 */
package libpsid64;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import libpsid64.IPsidBoot;
import libpsid64.IPsidDrv;
import libpsid64.IPsidExtDriver;
import libpsid64.Screen;
import libsidplay.Reloc65;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.STIL;
import sidplay.ini.IniConfig;

public class Psid64 {
    public static final String PACKAGE = "psid64";
    public static final String VERSION = "0.9";
    public static final int MAX_BLOCKS = 4;
    public static final int MAX_PAGES = 256;
    public static final int NUM_MINDRV_PAGES = 2;
    public static final int NUM_EXTDRV_PAGES = 5;
    public static final int NUM_SCREEN_PAGES = 4;
    public static final int NUM_CHAR_PAGES = 8;
    public static final int STIL_EOT_SPACES = 10;
    public static final String DOCUMENTS_STIL_TXT = "DOCUMENTS" + System.getProperty("file.separator") + "STIL.txt";
    public static final String txt_relocOverlapsImage = "PSID64: relocation information overlaps the load image";
    public static final String txt_notEnoughC64Memory = "PSID64: C64 memory has no space for driver code";
    public static final String txt_fileIoError = "PSID64: File I/O error";
    public static final String txt_noSidTuneLoaded = "PSID64: No SID tune loaded";
    public static final String txt_noSidTuneConverted = "PSID64: No SID tune converted";
    private boolean m_blankScreen;
    private int m_initialSong;
    private final boolean m_verbose;
    private String m_hvscRoot;
    private SidTune m_tune;
    private File m_file;
    private String m_statusString;
    private STIL.STILEntry m_stilEntry;
    private Screen m_screen = new Screen();
    private String m_stilText;
    private short m_driverPage;
    private short m_screenPage;
    private short m_charPage;
    private short m_stilPage;
    private byte[] m_programData;
    private int m_programSize;
    private HashMap<String, Integer> globals;

    public Psid64() {
        this.m_verbose = true;
    }

    public void setInitialSong(int songNo) {
        this.m_initialSong = songNo;
    }

    public void setBlankScreen(boolean blank) {
        this.m_blankScreen = blank;
    }

    public boolean load(File file) {
        this.m_tune = null;
        try {
            this.m_tune = SidTune.load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_statusString = txt_noSidTuneLoaded;
            this.m_file = null;
            return false;
        }
        if (this.m_tune == null) {
            this.m_statusString = txt_noSidTuneLoaded;
            this.m_file = null;
            return false;
        }
        this.m_tune.selectSong(0);
        this.m_file = file;
        return true;
    }

    public boolean load(SidTune sidTune) {
        this.m_tune = sidTune;
        this.m_file = null;
        return true;
    }

    public boolean convert() {
        int i;
        int i2;
        block_t[] blocks = new block_t[4];
        for (int i3 = 0; i3 < blocks.length; ++i3) {
            blocks[i3] = new block_t();
        }
        int boot_size = IPsidBoot.psid_boot.length;
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        if (tuneInfo.compatibility == SidTune.Compatibility.RSID_BASIC) {
            return this.convertBASIC();
        }
        if (!this.formatStilText()) {
            return false;
        }
        this.findFreeSpace();
        if (this.m_driverPage == 0) {
            this.m_statusString = txt_notEnoughC64Memory;
            return false;
        }
        if (this.m_blankScreen) {
            this.m_screenPage = 0;
            this.m_charPage = 0;
            this.m_stilPage = 0;
        }
        DriverInfo driverInfo = new DriverInfo();
        this.initDriver(driverInfo);
        byte[] psid_mem = driverInfo.mem;
        int reloc_driverPos = driverInfo.reloc_driverPos;
        int driver_size = driverInfo.n;
        int numBlocks = 0;
        blocks[numBlocks].load = this.m_driverPage << 8;
        blocks[numBlocks].size = driver_size;
        blocks[numBlocks].data = psid_mem;
        blocks[numBlocks].dataOff = reloc_driverPos;
        blocks[numBlocks].description = "Driver code";
        blocks[++numBlocks].load = tuneInfo.loadAddr;
        blocks[numBlocks].size = tuneInfo.c64dataLen;
        byte[] c64buf = new byte[65536];
        this.m_tune.placeProgramInMemory(c64buf);
        blocks[numBlocks].data = c64buf;
        blocks[numBlocks].dataOff = tuneInfo.loadAddr;
        System.arraycopy(c64buf, tuneInfo.loadAddr, blocks[numBlocks].data, blocks[numBlocks].dataOff, blocks[numBlocks].data.length - blocks[numBlocks].dataOff);
        blocks[numBlocks].description = "Music data";
        ++numBlocks;
        if (this.m_screenPage != 0) {
            this.drawScreen();
            blocks[numBlocks].load = this.m_screenPage << 8;
            blocks[numBlocks].size = this.m_screen.getDataSize();
            blocks[numBlocks].data = this.m_screen.getData();
            blocks[numBlocks].dataOff = 0;
            blocks[numBlocks].description = "Screen";
            ++numBlocks;
        }
        if (this.m_stilPage != 0) {
            blocks[numBlocks].load = this.m_stilPage << 8;
            blocks[numBlocks].size = this.m_stilText.length();
            blocks[numBlocks].data = new byte[this.m_stilText.length() + 1];
            for (i2 = 0; i2 < this.m_stilText.length(); ++i2) {
                blocks[numBlocks].data[i2] = (byte)this.m_stilText.charAt(i2);
                blocks[numBlocks].dataOff = 0;
            }
            blocks[numBlocks].data[this.m_stilText.length()] = 0;
            blocks[numBlocks].description = "STIL text";
            ++numBlocks;
        }
        Arrays.sort(blocks, 0, numBlocks, new Comparator<block_t>(){

            @Override
            public int compare(block_t a, block_t b) {
                if (a.load < b.load) {
                    return -1;
                }
                if (a.load > b.load) {
                    return 1;
                }
                return 0;
            }
        });
        if (this.m_verbose) {
            int charset = this.m_charPage << 8;
            System.err.println("C64 memory map:");
            for (int i4 = 0; i4 < numBlocks; ++i4) {
                if (charset != 0 && blocks[i4].load > charset) {
                    System.err.println("  $" + this.toHexWord(charset) + "-$" + this.toHexWord(charset + 2048) + "  Character set");
                    charset = 0;
                }
                System.err.println("  $" + this.toHexWord(blocks[i4].load) + "-$" + this.toHexWord(blocks[i4].load + blocks[i4].size) + "  " + blocks[i4].description);
            }
            if (charset != 0) {
                System.err.println("  $" + this.toHexWord(charset) + "-$" + this.toHexWord(charset + 2048) + "  Character set");
            }
        }
        int size = 0;
        for (i2 = 0; i2 < numBlocks; ++i2) {
            size += blocks[i2].size;
        }
        this.m_programSize = boot_size + size;
        this.m_programData = new byte[this.m_programSize];
        int destPos = 0;
        System.arraycopy(IPsidBoot.psid_boot, 0, this.m_programData, destPos, boot_size);
        int addr = 19;
        int song = this.m_programData[destPos + addr] & 0xFF;
        song += (this.m_programData[destPos + addr + 1] & 0xFF) << 8;
        int initialSong = 1 <= this.m_initialSong && this.m_initialSong <= tuneInfo.songs ? this.m_initialSong : tuneInfo.startSong;
        this.m_programData[destPos + (song -= 2047)] = (byte)(initialSong - 1 & 0xFF);
        int eof = 2049 + boot_size - 2 + size;
        this.m_programData[destPos + addr++] = (byte)(eof & 0xFF);
        this.m_programData[destPos + addr++] = (byte)(eof >> 8);
        this.m_programData[destPos + addr++] = 0;
        this.m_programData[destPos + addr++] = 0;
        this.m_programData[destPos + addr++] = (byte)(size + 255 >> 8);
        this.m_programData[destPos + addr++] = (byte)(65536 - size & 0xFF);
        this.m_programData[destPos + addr++] = (byte)(65536 - size >> 8);
        this.m_programData[destPos + addr++] = (byte)(numBlocks - 1);
        this.m_programData[destPos + addr++] = (byte)this.m_charPage;
        int jmpAddr = this.m_driverPage << 8;
        this.m_programData[destPos + addr++] = (byte)(jmpAddr & 0xFF);
        this.m_programData[destPos + addr++] = (byte)(jmpAddr >> 8);
        this.m_programData[destPos + addr++] = (byte)(jmpAddr + 3 & 0xFF);
        this.m_programData[destPos + addr++] = (byte)(jmpAddr + 3 >> 8);
        for (i = 0; i < numBlocks; ++i) {
            int offs = addr + numBlocks - 1 - i;
            this.m_programData[destPos + offs] = (byte)(blocks[i].load & 0xFF);
            this.m_programData[destPos + offs + 4] = (byte)(blocks[i].load >> 8);
            this.m_programData[destPos + offs + 8] = (byte)(blocks[i].size & 0xFF);
            this.m_programData[destPos + offs + 12] = (byte)(blocks[i].size >> 8);
        }
        addr += 16;
        destPos += boot_size;
        for (i = 0; i < numBlocks; ++i) {
            System.arraycopy(blocks[i].data, blocks[i].dataOff, this.m_programData, destPos, blocks[i].size);
            destPos += blocks[i].size;
        }
        return true;
    }

    private boolean convertBASIC() {
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        int load = tuneInfo.loadAddr;
        int end = load + tuneInfo.c64dataLen;
        boolean bootCodeSize = false;
        this.m_programSize = 2 + tuneInfo.c64dataLen + 0;
        this.m_programData = null;
        this.m_programData = new byte[this.m_programSize];
        this.m_programData[0] = (byte)(load & 0xFF);
        this.m_programData[1] = (byte)(load >> 8);
        byte[] c64buf = new byte[65536];
        this.m_tune.placeProgramInMemory(c64buf);
        System.arraycopy(c64buf, load, this.m_programData, 2, tuneInfo.c64dataLen);
        if (this.m_verbose) {
            System.err.println("C64 memory map:");
            System.err.println("  $" + this.toHexWord(load) + "-$" + this.toHexWord(end) + "  BASIC program");
        }
        return true;
    }

    private String toHexWord(int i) {
        return String.format("%04x", i);
    }

    private DriverInfo initDriver(DriverInfo result) {
        byte[] psid_reloc;
        byte[] driver;
        int psid_size;
        result.reloc_driverPos = 0;
        result.n = 0;
        if (this.m_screenPage == 0) {
            psid_size = IPsidDrv.psid_driver.length;
            driver = IPsidDrv.psid_driver;
        } else {
            psid_size = IPsidExtDriver.psid_extdriver.length;
            driver = IPsidExtDriver.psid_extdriver;
        }
        byte[] psid_mem = psid_reloc = new byte[psid_size];
        System.arraycopy(driver, 0, psid_reloc, 0, psid_size);
        int reloc_addr = this.m_driverPage << 8;
        this.globals = new HashMap();
        int screen = this.m_screenPage << 8;
        this.globals.put("screen", screen);
        int screen_songnum = 0;
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        if (tuneInfo.songs > 1) {
            screen_songnum = screen + 400 + 24;
            if (tuneInfo.songs >= 100) {
                ++screen_songnum;
            }
            if (tuneInfo.songs >= 10) {
                ++screen_songnum;
            }
        }
        this.globals.put("screen_songnum", screen_songnum);
        this.globals.put("dd00", (this.m_screenPage & 0xC0) >> 6 ^ 3 | 4);
        short vsa = (short)((this.m_screenPage & 0x3C) << 2);
        short cba = (short)(this.m_charPage != 0 ? this.m_charPage >> 2 & 0xE : 6);
        this.globals.put("d018", vsa | cba);
        Reloc65 relocator = new Reloc65();
        ByteBuffer bp = relocator.reloc65(psid_reloc, psid_size, reloc_addr, this.globals);
        if (bp == null) {
            System.err.println("psid64: Relocation error.");
            return result;
        }
        psid_reloc = bp.array();
        int reloc_driverPos = bp.position();
        psid_size = bp.limit();
        int addr = 6;
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.initAddr != 0 ? 76 : 96);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.initAddr & 0xFF);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.initAddr >> 8);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.playAddr != 0 ? 76 : 96);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.playAddr & 0xFF);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.playAddr >> 8);
        psid_reloc[reloc_driverPos + addr++] = (byte)tuneInfo.songs;
        int speed = this.m_tune.getSongSpeedArray();
        psid_reloc[reloc_driverPos + addr++] = (byte)(speed & 0xFF);
        psid_reloc[reloc_driverPos + addr++] = (byte)(speed >> 8 & 0xFF);
        psid_reloc[reloc_driverPos + addr++] = (byte)(speed >> 16 & 0xFF);
        psid_reloc[reloc_driverPos + addr++] = (byte)(speed >> 24);
        psid_reloc[reloc_driverPos + addr++] = (byte)(tuneInfo.loadAddr < 794 ? 255 : 5);
        psid_reloc[reloc_driverPos + addr++] = this.iomap(tuneInfo.initAddr);
        psid_reloc[reloc_driverPos + addr++] = this.iomap(tuneInfo.playAddr);
        if (this.m_screenPage != 0) {
            psid_reloc[reloc_driverPos + addr++] = (byte)this.m_stilPage;
        }
        result.mem = psid_mem;
        result.reloc_driverPos = reloc_driverPos;
        result.n = psid_size;
        return result;
    }

    private byte iomap(int addr) {
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        if (tuneInfo.compatibility == SidTune.Compatibility.RSID) {
            return 0;
        }
        if (addr == 0) {
            return 0;
        }
        if (addr < 40960) {
            return 55;
        }
        if (addr < 53248) {
            return 54;
        }
        if (addr >= 57344) {
            return 53;
        }
        return 52;
    }

    private boolean addFlag(boolean hasFlags, String flagName) {
        if (hasFlags) {
            this.m_screen.write(", ");
        } else {
            hasFlags = true;
        }
        this.m_screen.write(flagName);
        return hasFlags;
    }

    private void drawScreen() {
        this.m_screen.clear();
        this.m_screen.move(5, 1);
        this.m_screen.write("PSID64 v0.9 by Roland Hermans!");
        this.m_screen.poke(4, 0, (short)112);
        this.m_screen.poke(35, 0, (short)110);
        this.m_screen.poke(4, 1, (short)93);
        this.m_screen.poke(35, 1, (short)93);
        this.m_screen.poke(4, 2, (short)109);
        this.m_screen.poke(35, 2, (short)125);
        for (int i = 0; i < 30; ++i) {
            this.m_screen.poke(5 + i, 0, (short)64);
            this.m_screen.poke(5 + i, 2, (short)64);
        }
        this.m_screen.move(0, 4);
        this.m_screen.write("Name   : ");
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        this.m_screen.write(tuneInfo.infoString[0].substring(0, Math.min(tuneInfo.infoString[0].length(), 31)));
        this.m_screen.write("\nAuthor : ");
        this.m_screen.write(tuneInfo.infoString[1].substring(0, Math.min(tuneInfo.infoString[1].length(), 31)));
        this.m_screen.write("\nRelease: ");
        this.m_screen.write(tuneInfo.infoString[2].substring(0, Math.min(tuneInfo.infoString[2].length(), 31)));
        this.m_screen.write("\nLoad   : $");
        this.m_screen.write(this.toHexWord(tuneInfo.loadAddr));
        this.m_screen.write("-$");
        this.m_screen.write(this.toHexWord(tuneInfo.loadAddr + tuneInfo.c64dataLen));
        this.m_screen.write("\nInit   : $");
        this.m_screen.write(this.toHexWord(tuneInfo.initAddr));
        this.m_screen.write("\nPlay   : ");
        if (tuneInfo.playAddr != 0) {
            this.m_screen.write("$");
            this.m_screen.write(this.toHexWord(tuneInfo.playAddr));
        } else {
            this.m_screen.write("N/A");
        }
        this.m_screen.write("\nSongs  : ");
        this.m_screen.write(String.format("%d", tuneInfo.songs));
        if (tuneInfo.songs > 1) {
            this.m_screen.write(" (now playing");
        }
        boolean hasFlags = false;
        this.m_screen.write("\nFlags  : ");
        if (tuneInfo.compatibility == SidTune.Compatibility.PSIDv1) {
            hasFlags = this.addFlag(hasFlags, "PlaySID");
        }
        hasFlags = this.addFlag(hasFlags, tuneInfo.clockSpeed.toString());
        hasFlags = this.addFlag(hasFlags, tuneInfo.sid1Model.toString());
        int sid2midNibbles = tuneInfo.sidChipBase2 >> 4 & 0xFF;
        if ((sid2midNibbles & 1) == 0 && (66 <= sid2midNibbles && sid2midNibbles <= 126 || 224 <= sid2midNibbles && sid2midNibbles <= 254)) {
            hasFlags = this.addFlag(hasFlags, tuneInfo.sid2Model.toString() + " at $" + this.toHexWord(tuneInfo.sidChipBase2));
        }
        if (!hasFlags) {
            this.m_screen.write("-");
        }
        this.m_screen.write("\nClock  :   :  :");
        this.m_screen.write("\n\n  ");
        if (tuneInfo.songs <= 1) {
            this.m_screen.write("   [1");
        } else if (tuneInfo.songs <= 10) {
            this.m_screen.write("  [1-");
            this.m_screen.putchar(tuneInfo.songs % 10 + 48);
        } else if (tuneInfo.songs <= 11) {
            this.m_screen.write(" [1-0, A");
        } else {
            this.m_screen.write("[1-0, A-");
            this.m_screen.putchar(tuneInfo.songs <= 36 ? tuneInfo.songs - 11 + 65 : 90);
        }
        this.m_screen.write("] Select song [+] Next song\n");
        this.m_screen.write("  [-] Previous song [DEL] Blank screen\n");
        if (tuneInfo.playAddr != 0) {
            this.m_screen.write("[~] Fast forward [LOCK] Show raster time\n");
        }
        this.m_screen.write("  [RUN/STOP] Stop [CTRL+CBM+DEL] Reset\n");
        this.m_screen.move(1, 24);
        this.m_screen.write("Website: http://psid64.sourceforge.net");
    }

    private boolean formatStilText() {
        STIL stil;
        String name;
        this.m_stilText = "";
        String str = "";
        if (this.m_stilEntry == null && this.m_file != null && null != (name = IniConfig.getCollectionRelName(this.m_file, this.m_hvscRoot)) && (stil = STIL.getInstance(this.m_hvscRoot)) != null) {
            this.m_stilEntry = stil.getSTIL(name);
        }
        if (this.m_stilEntry != null) {
            str = str + this.writeEntry(this.m_stilEntry);
        }
        int n = str.length();
        this.m_stilText = this.m_stilText.trim();
        for (int i = 0; i < 9; ++i) {
            this.m_stilText = this.m_stilText + (char)Screen.iso2scr((short)32);
        }
        boolean space = true;
        boolean realText = false;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(str.charAt(i))) {
                space = true;
                continue;
            }
            if (space) {
                this.m_stilText = this.m_stilText + (char)Screen.iso2scr((short)32);
                space = false;
            }
            this.m_stilText = this.m_stilText + (char)Screen.iso2scr((short)str.charAt(i));
            realText = true;
        }
        this.m_stilText = realText ? this.m_stilText + '\u00ff' : "";
        return true;
    }

    private String writeEntry(STIL.STILEntry stilEntry) {
        Iterator<STIL.Info> infosIt;
        StringBuffer buffer = new StringBuffer();
        if (stilEntry.filename != null) {
            buffer.append("Filename: ");
            buffer.append(stilEntry.filename.trim());
            buffer.append(" - ");
        }
        if (stilEntry.globalComment != null) {
            buffer.append(stilEntry.globalComment.trim());
        }
        Iterator<STIL.Info> iterator = infosIt = stilEntry.infos.iterator();
        while (iterator.hasNext()) {
            STIL.Info info = iterator.next();
            if (info.comment != null) {
                buffer.append(info.comment.trim());
            }
            if (info.name != null) {
                buffer.append(" Name: ");
                buffer.append(info.name.trim());
            }
            if (info.author != null) {
                buffer.append(" Author: ");
                buffer.append(info.author.trim());
            }
            if (info.title != null) {
                buffer.append(" Title: ");
                buffer.append(info.title.trim());
            }
            if (info.artist == null) continue;
            buffer.append(" Artist: ");
            buffer.append(info.artist.trim());
        }
        int subTuneNo = 1;
        for (STIL.TuneEntry entry : stilEntry.subtunes) {
            Iterator<STIL.Info> subtuneEntryIt;
            if (entry.globalComment != null) {
                buffer.append(entry.globalComment.trim());
            }
            Iterator<STIL.Info> subTuneIterator = subtuneEntryIt = entry.infos.iterator();
            while (subTuneIterator.hasNext()) {
                STIL.Info info = subTuneIterator.next();
                buffer.append(" SubTune #" + subTuneNo + ": ");
                if (info.name != null) {
                    buffer.append(" ");
                    buffer.append(info.name.trim());
                }
                if (info.author != null) {
                    buffer.append(" Author: ");
                    buffer.append(info.author.trim());
                }
                if (info.title != null) {
                    buffer.append(" Title: ");
                    buffer.append(info.title.trim());
                }
                if (info.artist != null) {
                    buffer.append(" Artist: ");
                    buffer.append(info.artist.trim());
                }
                if (info.comment == null) continue;
                buffer.append(" Comment: ");
                buffer.append(info.comment.trim());
            }
            ++subTuneNo;
        }
        return buffer.append("                                        ").toString();
    }

    private short findStilSpace(boolean[] pages, short scr, short chars, short driver, int size) {
        int firstPage = 0;
        for (int i = 0; i < 256; ++i) {
            if (!(pages[i] || scr != 0 && scr <= i && i < scr + 4 || chars != 0 && chars <= i && i < chars + 8) && (driver > i || i >= driver + 5)) continue;
            if (i - firstPage >= size) {
                return (short)firstPage;
            }
            firstPage = i + 1;
        }
        return 0;
    }

    private short findDriverSpace(boolean[] pages, short scr, short chars, int size) {
        short firstPage = 0;
        for (int i = 0; i < 256; ++i) {
            if (!pages[i] && (scr == 0 || scr > i || i >= scr + 4) && (chars == 0 || chars > i || i >= chars + 8)) continue;
            if (i - firstPage >= size) {
                return firstPage;
            }
            firstPage = (short)(i + 1);
        }
        return 0;
    }

    private void findFreeSpace() {
        int j;
        int i;
        SidTuneInfo tuneInfo = this.m_tune.getInfo();
        boolean[] pages = new boolean[256];
        int startp = tuneInfo.relocStartPage;
        short maxp = tuneInfo.relocPages;
        short stilSize = (short)(this.m_stilText.length() + 255 >> 8);
        this.m_screenPage = 0;
        this.m_driverPage = 0;
        this.m_charPage = 0;
        this.m_stilPage = 0;
        if (startp == 0) {
            int[] used = new int[]{0, 3, 160, 191, 208, 255, 0, 0};
            used[6] = tuneInfo.loadAddr >> 8;
            used[7] = tuneInfo.loadAddr + tuneInfo.c64dataLen - 1 >> 8;
            for (i = 0; i < 256; ++i) {
                pages[i] = false;
            }
            for (i = 0; i < used.length; i += 2) {
                for (j = used[i]; j <= used[i + 1]; ++j) {
                    pages[j] = true;
                }
            }
        } else if (startp != 255 && maxp != 0) {
            int endp = Math.min(startp + maxp, 256);
            if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || endp - 1 < 4 || 160 <= endp - 1 && endp - 1 <= 191 || endp - 1 >= 208) {
                return;
            }
            for (i = 0; i < 256; ++i) {
                pages[i] = startp > i || i >= endp;
            }
        } else {
            return;
        }
        short driver = 0;
        for (i = 0; i < 4; ++i) {
            short bank = (short)(((i & 1 ^ i >> 1) != 0 ? i ^ 3 : i) << 6);
            for (j = 0; j < 64; j += 4) {
                short scr;
                if ((bank & 0x40) == 0 && 16 <= j && j < 32 || pages[scr = (short)(bank + j)] || pages[scr + 1] || pages[scr + 2] || pages[scr + 3]) continue;
                if ((bank & 0x40) != 0) {
                    for (int k = 0; k < 64; k += 8) {
                        short chars;
                        if (k == (j & 0x38) || pages[chars = (short)(bank + k)] || pages[chars + 1] || pages[chars + 2] || pages[chars + 3] || pages[chars + 4] || pages[chars + 5] || pages[chars + 6] || pages[chars + 7] || (driver = this.findDriverSpace(pages, scr, chars, 5)) == 0) continue;
                        this.m_driverPage = driver;
                        this.m_screenPage = scr;
                        this.m_charPage = chars;
                        if (stilSize != 0) {
                            this.m_stilPage = this.findStilSpace(pages, scr, chars, driver, stilSize);
                        }
                        return;
                    }
                    continue;
                }
                driver = this.findDriverSpace(pages, scr, (short)0, 5);
                if (driver == 0) continue;
                this.m_driverPage = driver;
                this.m_screenPage = scr;
                if (stilSize != 0) {
                    this.m_stilPage = this.findStilSpace(pages, scr, (short)0, driver, stilSize);
                }
                return;
            }
        }
        if (driver == 0) {
            this.m_driverPage = driver = this.findDriverSpace(pages, (short)0, (short)0, 2);
        }
    }

    public boolean save(String fileName) {
        try {
            FileOutputStream outfile = new FileOutputStream(fileName);
            return this.write(outfile);
        }
        catch (IOException e) {
            this.m_statusString = "PSID64: File I/O error: " + e.getMessage();
            return false;
        }
    }

    public boolean write(OutputStream out) throws IOException {
        if (this.m_programData == null) {
            this.m_statusString = txt_noSidTuneConverted;
            return false;
        }
        for (int i = 0; i < this.m_programSize; ++i) {
            out.write(this.m_programData[i]);
        }
        out.close();
        return true;
    }

    public void setHVSC(String root) {
        this.m_hvscRoot = root;
    }

    public void setStilEntry(STIL.STILEntry stilEntry) {
        this.m_stilEntry = stilEntry;
    }

    public String getStatus() {
        return this.m_statusString;
    }

    protected static class DriverInfo {
        public byte[] mem;
        public int reloc_driverPos;
        public int n;

        protected DriverInfo() {
        }
    }

    protected static class block_t {
        protected int load;
        protected int size;
        protected byte[] data;
        protected int dataOff;
        protected String description;

        protected block_t() {
        }
    }
}

