/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import net.sf.asap.Pokey;

class PokeyPair {
    final Pokey basePokey = new Pokey();
    final Pokey extraPokey = new Pokey();
    private int extraPokeyMask;
    private int iirAccLeft;
    private int iirAccRight;
    final byte[] poly17Lookup = new byte[16385];
    final byte[] poly9Lookup = new byte[511];
    int readySamplesEnd;
    int readySamplesStart;
    int sampleFactor;
    int sampleOffset;

    public PokeyPair() {
        int n;
        int n2 = 511;
        for (n = 0; n < 511; ++n) {
            n2 = (((n2 >> 5 ^ n2) & 1) << 8) + (n2 >> 1);
            this.poly9Lookup[n] = (byte)n2;
        }
        n2 = 131071;
        for (n = 0; n < 16385; ++n) {
            n2 = (((n2 >> 5 ^ n2) & 0xFF) << 9) + (n2 >> 8);
            this.poly17Lookup[n] = (byte)(n2 >> 1);
        }
    }

    final int endFrame(int n) {
        this.basePokey.endFrame(this, n);
        if (this.extraPokeyMask != 0) {
            this.extraPokey.endFrame(this, n);
        }
        this.sampleOffset += n * this.sampleFactor;
        this.readySamplesStart = 0;
        this.readySamplesEnd = this.sampleOffset >> 20;
        this.sampleOffset &= 0xFFFFF;
        return this.readySamplesEnd;
    }

    final int generate(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.readySamplesEnd;
        int n5 = this.readySamplesStart;
        if (n2 < n4 - n5) {
            n4 = n5 + n2;
        } else {
            n2 = n4 - n5;
        }
        int n6 = this.iirAccLeft;
        int n7 = this.iirAccRight;
        while (n5 < n4) {
            int n8;
            if ((n8 = (n6 += this.basePokey.deltaBuffer[n5] - (n6 * 3 >> 10)) >> 11) < -32767) {
                n8 = -32767;
            } else if (n8 > Short.MAX_VALUE) {
                n8 = Short.MAX_VALUE;
            }
            switch (n3) {
                case 0: {
                    byArray[n++] = (byte)((n8 >> 8) + 128);
                    break;
                }
                case 1: {
                    byArray[n++] = (byte)n8;
                    byArray[n++] = (byte)(n8 >> 8);
                    break;
                }
                case 2: {
                    byArray[n++] = (byte)(n8 >> 8);
                    byArray[n++] = (byte)n8;
                }
            }
            if (this.extraPokeyMask != 0) {
                if ((n8 = (n7 += this.extraPokey.deltaBuffer[n5] - (n7 * 3 >> 10)) >> 11) < -32767) {
                    n8 = -32767;
                } else if (n8 > Short.MAX_VALUE) {
                    n8 = Short.MAX_VALUE;
                }
                switch (n3) {
                    case 0: {
                        byArray[n++] = (byte)((n8 >> 8) + 128);
                        break;
                    }
                    case 1: {
                        byArray[n++] = (byte)n8;
                        byArray[n++] = (byte)(n8 >> 8);
                        break;
                    }
                    case 2: {
                        byArray[n++] = (byte)(n8 >> 8);
                        byArray[n++] = (byte)n8;
                    }
                }
            }
            ++n5;
        }
        if (n5 == this.readySamplesEnd) {
            n6 += this.basePokey.deltaBuffer[n5] + this.basePokey.deltaBuffer[n5 + 1];
            n7 += this.extraPokey.deltaBuffer[n5] + this.extraPokey.deltaBuffer[n5 + 1];
        }
        this.readySamplesStart = n5;
        this.iirAccLeft = n6;
        this.iirAccRight = n7;
        return n2;
    }

    final void initialize(boolean bl, boolean bl2) {
        this.extraPokeyMask = bl2 ? 16 : 0;
        this.basePokey.initialize();
        this.extraPokey.initialize();
        this.sampleFactor = bl ? 25837 : 26075;
        this.sampleOffset = 0;
        this.readySamplesStart = 0;
        this.readySamplesEnd = 0;
        this.iirAccLeft = 0;
        this.iirAccRight = 0;
    }

    final boolean isSilent() {
        return this.basePokey.isSilent() && this.extraPokey.isSilent();
    }

    final int peek(int n, int n2) {
        Pokey pokey = (n & this.extraPokeyMask) != 0 ? this.extraPokey : this.basePokey;
        switch (n & 0xF) {
            case 10: {
                if (pokey.init) {
                    return 255;
                }
                int n3 = n2 + pokey.polyIndex;
                if ((pokey.audctl & 0x80) != 0) {
                    return this.poly9Lookup[n3 % 511] & 0xFF;
                }
                int n4 = (n3 %= 131071) >> 3;
                return ((this.poly17Lookup[n4] & 0xFF) >> (n3 &= 7)) + ((this.poly17Lookup[n4 + 1] & 0xFF) << 8 - n3) & 0xFF;
            }
            case 14: {
                return pokey.irqst;
            }
        }
        return 255;
    }

    final int poke(int n, int n2, int n3) {
        Pokey pokey = (n & this.extraPokeyMask) != 0 ? this.extraPokey : this.basePokey;
        return pokey.poke(this, n, n2, n3);
    }

    final void startFrame() {
        PokeyPair.clear(this.basePokey.deltaBuffer);
        if (this.extraPokeyMask != 0) {
            PokeyPair.clear(this.extraPokey.deltaBuffer);
        }
    }

    private static void clear(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
    }
}

