/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import net.sf.asap.PokeyChannel;
import net.sf.asap.PokeyPair;

class Pokey {
    int audctl;
    final PokeyChannel[] channels = new PokeyChannel[]{new PokeyChannel(), new PokeyChannel(), new PokeyChannel(), new PokeyChannel()};
    final int[] deltaBuffer = new int[888];
    private int divCycles;
    boolean init;
    int irqst;
    int polyIndex;
    private int reloadCycles1;
    private int reloadCycles3;
    private int skctl;

    Pokey() {
    }

    final void addDelta(PokeyPair pokeyPair, int n, int n2) {
        int n3 = n * pokeyPair.sampleFactor + pokeyPair.sampleOffset;
        int n4 = (n2 >> 16) * (n3 >> 4 & 0xFFFF);
        int n5 = n3 >>= 20;
        this.deltaBuffer[n5] = this.deltaBuffer[n5] + (n2 - n4);
        int n6 = n3 + 1;
        this.deltaBuffer[n6] = this.deltaBuffer[n6] + n4;
    }

    final int checkIrq(int n, int n2) {
        int n3 = 3;
        while (true) {
            int n4;
            if (n >= (n4 = this.channels[n3].timerCycle)) {
                this.irqst &= ~(n3 + 1);
                this.channels[n3].timerCycle = 0x800000;
            } else if (n2 > n4) {
                n2 = n4;
            }
            if (n3 == 0) break;
            n3 >>= 1;
        }
        return n2;
    }

    final void endFrame(PokeyPair pokeyPair, int n) {
        int n2;
        this.generateUntilCycle(pokeyPair, n);
        this.polyIndex += n;
        int n3 = n2 = (this.audctl & 0x80) != 0 ? 237615 : 60948015;
        if (this.polyIndex >= 2 * n2) {
            this.polyIndex -= n2;
        }
        for (int i = 0; i < 4; ++i) {
            int n4 = this.channels[i].tickCycle;
            if (n4 == 0x800000) continue;
            this.channels[i].tickCycle = n4 - n;
        }
    }

    final void generateUntilCycle(PokeyPair pokeyPair, int n) {
        while (true) {
            int n2 = n;
            for (int i = 0; i < 4; ++i) {
                int n3 = this.channels[i].tickCycle;
                if (n2 <= n3) continue;
                n2 = n3;
            }
            if (n2 == n) break;
            if (n2 == this.channels[2].tickCycle) {
                if ((this.audctl & 4) != 0 && this.channels[0].delta > 0 && this.channels[0].mute == 0) {
                    this.channels[0].slope(this, pokeyPair, n2);
                }
                this.channels[2].doTick(this, pokeyPair, n2, 2);
            }
            if (n2 == this.channels[3].tickCycle) {
                if ((this.audctl & 8) != 0) {
                    this.channels[2].tickCycle = n2 + this.reloadCycles3;
                }
                if ((this.audctl & 2) != 0 && this.channels[1].delta > 0 && this.channels[1].mute == 0) {
                    this.channels[1].slope(this, pokeyPair, n2);
                }
                this.channels[3].doTick(this, pokeyPair, n2, 3);
            }
            if (n2 == this.channels[0].tickCycle) {
                if ((this.skctl & 0x88) == 8) {
                    this.channels[1].tickCycle = n2 + this.channels[1].periodCycles;
                }
                this.channels[0].doTick(this, pokeyPair, n2, 0);
            }
            if (n2 != this.channels[1].tickCycle) continue;
            if ((this.audctl & 0x10) != 0) {
                this.channels[0].tickCycle = n2 + this.reloadCycles1;
            } else if ((this.skctl & 8) != 0) {
                this.channels[0].tickCycle = n2 + this.channels[0].periodCycles;
            }
            this.channels[1].doTick(this, pokeyPair, n2, 1);
        }
    }

    private void initMute(int n) {
        boolean bl = this.init;
        int n2 = this.audctl;
        this.channels[0].setMute(bl && (n2 & 0x40) == 0, 2, n);
        this.channels[1].setMute(bl && (n2 & 0x50) != 80, 2, n);
        this.channels[2].setMute(bl && (n2 & 0x20) == 0, 2, n);
        this.channels[3].setMute(bl && (n2 & 0x28) != 40, 2, n);
    }

    final void initialize() {
        for (int i = 0; i < 4; ++i) {
            this.channels[i].initialize();
        }
        this.audctl = 0;
        this.skctl = 3;
        this.irqst = 255;
        this.init = false;
        this.divCycles = 28;
        this.reloadCycles1 = 28;
        this.reloadCycles3 = 28;
        this.polyIndex = 60948015;
        Pokey.clear(this.deltaBuffer);
    }

    final boolean isSilent() {
        for (int i = 0; i < 4; ++i) {
            if ((this.channels[i].audc & 0xF) == 0) continue;
            return false;
        }
        return true;
    }

    final void mute(int n) {
        for (int i = 0; i < 4; ++i) {
            this.channels[i].setMute((n & 1 << i) != 0, 4, 0);
        }
    }

    final int poke(PokeyPair pokeyPair, int n, int n2, int n3) {
        int n4 = 0x800000;
        block0 : switch (n & 0xF) {
            case 0: {
                if (n2 == this.channels[0].audf) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.channels[0].audf = n2;
                switch (this.audctl & 0x50) {
                    case 0: {
                        this.channels[0].periodCycles = this.divCycles * (n2 + 1);
                        break;
                    }
                    case 16: {
                        this.channels[1].periodCycles = this.divCycles * (n2 + (this.channels[1].audf << 8) + 1);
                        this.reloadCycles1 = this.divCycles * (n2 + 1);
                        this.channels[1].muteUltrasound(n3);
                        break;
                    }
                    case 64: {
                        this.channels[0].periodCycles = n2 + 4;
                        break;
                    }
                    case 80: {
                        this.channels[1].periodCycles = n2 + (this.channels[1].audf << 8) + 7;
                        this.reloadCycles1 = n2 + 4;
                        this.channels[1].muteUltrasound(n3);
                    }
                }
                this.channels[0].muteUltrasound(n3);
                break;
            }
            case 1: {
                this.channels[0].setAudc(this, pokeyPair, n2, n3);
                break;
            }
            case 2: {
                if (n2 == this.channels[1].audf) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.channels[1].audf = n2;
                switch (this.audctl & 0x50) {
                    case 0: 
                    case 64: {
                        this.channels[1].periodCycles = this.divCycles * (n2 + 1);
                        break;
                    }
                    case 16: {
                        this.channels[1].periodCycles = this.divCycles * (this.channels[0].audf + (n2 << 8) + 1);
                        break;
                    }
                    case 80: {
                        this.channels[1].periodCycles = this.channels[0].audf + (n2 << 8) + 7;
                    }
                }
                this.channels[1].muteUltrasound(n3);
                break;
            }
            case 3: {
                this.channels[1].setAudc(this, pokeyPair, n2, n3);
                break;
            }
            case 4: {
                if (n2 == this.channels[2].audf) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.channels[2].audf = n2;
                switch (this.audctl & 0x28) {
                    case 0: {
                        this.channels[2].periodCycles = this.divCycles * (n2 + 1);
                        break;
                    }
                    case 8: {
                        this.channels[3].periodCycles = this.divCycles * (n2 + (this.channels[3].audf << 8) + 1);
                        this.reloadCycles3 = this.divCycles * (n2 + 1);
                        this.channels[3].muteUltrasound(n3);
                        break;
                    }
                    case 32: {
                        this.channels[2].periodCycles = n2 + 4;
                        break;
                    }
                    case 40: {
                        this.channels[3].periodCycles = n2 + (this.channels[3].audf << 8) + 7;
                        this.reloadCycles3 = n2 + 4;
                        this.channels[3].muteUltrasound(n3);
                    }
                }
                this.channels[2].muteUltrasound(n3);
                break;
            }
            case 5: {
                this.channels[2].setAudc(this, pokeyPair, n2, n3);
                break;
            }
            case 6: {
                if (n2 == this.channels[3].audf) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.channels[3].audf = n2;
                switch (this.audctl & 0x28) {
                    case 0: 
                    case 32: {
                        this.channels[3].periodCycles = this.divCycles * (n2 + 1);
                        break;
                    }
                    case 8: {
                        this.channels[3].periodCycles = this.divCycles * (this.channels[2].audf + (n2 << 8) + 1);
                        break;
                    }
                    case 40: {
                        this.channels[3].periodCycles = this.channels[2].audf + (n2 << 8) + 7;
                    }
                }
                this.channels[3].muteUltrasound(n3);
                break;
            }
            case 7: {
                this.channels[3].setAudc(this, pokeyPair, n2, n3);
                break;
            }
            case 8: {
                if (n2 == this.audctl) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.audctl = n2;
                this.divCycles = (n2 & 1) != 0 ? 114 : 28;
                switch (n2 & 0x50) {
                    case 0: {
                        this.channels[0].periodCycles = this.divCycles * (this.channels[0].audf + 1);
                        this.channels[1].periodCycles = this.divCycles * (this.channels[1].audf + 1);
                        break;
                    }
                    case 16: {
                        this.channels[0].periodCycles = this.divCycles << 8;
                        this.channels[1].periodCycles = this.divCycles * (this.channels[0].audf + (this.channels[1].audf << 8) + 1);
                        this.reloadCycles1 = this.divCycles * (this.channels[0].audf + 1);
                        break;
                    }
                    case 64: {
                        this.channels[0].periodCycles = this.channels[0].audf + 4;
                        this.channels[1].periodCycles = this.divCycles * (this.channels[1].audf + 1);
                        break;
                    }
                    case 80: {
                        this.channels[0].periodCycles = 256;
                        this.channels[1].periodCycles = this.channels[0].audf + (this.channels[1].audf << 8) + 7;
                        this.reloadCycles1 = this.channels[0].audf + 4;
                    }
                }
                this.channels[0].muteUltrasound(n3);
                this.channels[1].muteUltrasound(n3);
                switch (n2 & 0x28) {
                    case 0: {
                        this.channels[2].periodCycles = this.divCycles * (this.channels[2].audf + 1);
                        this.channels[3].periodCycles = this.divCycles * (this.channels[3].audf + 1);
                        break;
                    }
                    case 8: {
                        this.channels[2].periodCycles = this.divCycles << 8;
                        this.channels[3].periodCycles = this.divCycles * (this.channels[2].audf + (this.channels[3].audf << 8) + 1);
                        this.reloadCycles3 = this.divCycles * (this.channels[2].audf + 1);
                        break;
                    }
                    case 32: {
                        this.channels[2].periodCycles = this.channels[2].audf + 4;
                        this.channels[3].periodCycles = this.divCycles * (this.channels[3].audf + 1);
                        break;
                    }
                    case 40: {
                        this.channels[2].periodCycles = 256;
                        this.channels[3].periodCycles = this.channels[2].audf + (this.channels[3].audf << 8) + 7;
                        this.reloadCycles3 = this.channels[2].audf + 4;
                    }
                }
                this.channels[2].muteUltrasound(n3);
                this.channels[3].muteUltrasound(n3);
                this.initMute(n3);
                break;
            }
            case 9: {
                for (int i = 0; i < 4; ++i) {
                    this.channels[i].doStimer(n3);
                }
                break;
            }
            case 14: {
                this.irqst |= n2 ^ 0xFF;
                int n5 = 3;
                while (true) {
                    if ((n2 & this.irqst & n5 + 1) != 0) {
                        if (this.channels[n5].timerCycle == 0x800000) {
                            int n6;
                            for (n6 = this.channels[n5].tickCycle; n6 < n3; n6 += this.channels[n5].periodCycles) {
                            }
                            this.channels[n5].timerCycle = n6;
                            if (n4 > n6) {
                                n4 = n6;
                            }
                        }
                    } else {
                        this.channels[n5].timerCycle = 0x800000;
                    }
                    if (n5 == 0) break block0;
                    n5 >>= 1;
                }
            }
            case 15: {
                boolean bl;
                if (n2 == this.skctl) break;
                this.generateUntilCycle(pokeyPair, n3);
                this.skctl = n2;
                boolean bl2 = bl = (n2 & 3) == 0;
                if (this.init && !bl) {
                    this.polyIndex = ((this.audctl & 0x80) != 0 ? 237614 : 60948014) - n3;
                }
                this.init = bl;
                this.initMute(n3);
                this.channels[2].setMute((n2 & 0x10) != 0, 8, n3);
                this.channels[3].setMute((n2 & 0x10) != 0, 8, n3);
                break;
            }
        }
        return n4;
    }

    private static void clear(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
    }
}

