/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import java.io.DataInputStream;
import java.io.IOException;
import net.sf.asap.ASAP6502;
import net.sf.asap.ASAPInfo;
import net.sf.asap.ByteWriter;
import net.sf.asap.StringConsumer;

public class ASAPWriter {
    public static final int MAX_DURATION_LENGTH = 9;
    private static final int[] CI_CONST_ARRAY_1 = new int[]{3, -9, -10, -10};
    private static final int[] CI_CONST_ARRAY_2 = new int[]{-14, -16, -17, -17};

    public static int durationToString(byte[] byArray, int n) {
        if (!ASAPWriter.secondsToString(byArray, 0, n)) {
            return 0;
        }
        if ((n %= 1000) == 0) {
            return 5;
        }
        byArray[5] = 46;
        ASAPWriter.twoDigitsToString(byArray, 6, n / 10);
        if ((n %= 10) == 0) {
            return 8;
        }
        byArray[8] = (byte)(48 + n);
        return 9;
    }

    public static void enumSaveExts(StringConsumer stringConsumer, ASAPInfo aSAPInfo, byte[] byArray, int n) {
        switch (aSAPInfo.type) {
            case 0: 
            case 1: {
                stringConsumer.run("sap");
                String string = aSAPInfo.getOriginalModuleExt(byArray, n);
                if (string != null) {
                    stringConsumer.run(string);
                }
                stringConsumer.run("xex");
                break;
            }
            case 2: {
                stringConsumer.run("sap");
                if (aSAPInfo.fastplay != 312) break;
                stringConsumer.run("xex");
                break;
            }
            case 3: {
                stringConsumer.run("sap");
                break;
            }
            default: {
                stringConsumer.run(aSAPInfo.getOriginalModuleExt(byArray, n));
                stringConsumer.run("sap");
                stringConsumer.run("xex");
            }
        }
    }

    private static int formatXexInfoText(byte[] byArray, int n, int n2, String string, boolean bl) {
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c;
            if ((c = string.charAt(n4++)) == ' ') {
                int n5;
                if (bl && n4 < n3 && string.charAt(n4) == '&') {
                    n5 = 1;
                    while (n4 + n5 < n3 && (string.charAt(n4 + n5) != ' ' || n4 + n5 + 1 >= n3 || string.charAt(n4 + n5 + 1) != '&')) {
                        ++n5;
                    }
                    if (n5 <= 32 && n % 32 + 1 + n5 > 32) {
                        n = ASAPWriter.padXexInfo(byArray, n, 1);
                        continue;
                    }
                }
                n5 = 0;
                while (n4 + n5 < n3 && string.charAt(n4 + n5) != ' ') {
                    ++n5;
                }
                if (n5 <= 32 && n % 32 + 1 + n5 > 32) {
                    n = ASAPWriter.padXexInfo(byArray, n, 0);
                    continue;
                }
            }
            byArray[n++] = (byte)c;
        }
        return ASAPWriter.padXexInfo(byArray, n, n2);
    }

    private static int padXexInfo(byte[] byArray, int n, int n2) {
        while (n % 32 != n2) {
            byArray[n++] = 32;
        }
        return n;
    }

    private static boolean secondsToString(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n2 >= 6000000) {
            return false;
        }
        ASAPWriter.twoDigitsToString(byArray, n, (n2 /= 1000) / 60);
        byArray[n + 2] = 58;
        ASAPWriter.twoDigitsToString(byArray, n + 3, n2 % 60);
        return true;
    }

    private static void twoDigitsToString(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(48 + n2 / 10);
        byArray[n + 1] = (byte)(48 + n2 % 10);
    }

    public static void write(String string, ByteWriter byteWriter, ASAPInfo aSAPInfo, byte[] byArray, int n, boolean bl) throws Exception {
        int n2;
        int n3 = ASAPInfo.getPackedExt(string);
        switch (n3) {
            case 7364979: {
                ASAPWriter.writeExecutable(byteWriter, null, aSAPInfo, byArray, n);
                return;
            }
            case 7890296: {
                int[] nArray = new int[2];
                ASAPWriter.writeExecutable(byteWriter, nArray, aSAPInfo, byArray, n);
                switch (aSAPInfo.type) {
                    case 2: {
                        if (aSAPInfo.fastplay != 312) {
                            throw new Exception("Impossible conversion");
                        }
                        ASAPWriter.writeBytes(byteWriter, ASAPWriter.getBinaryResource("xexd.obx", 117), 2, 117);
                        ASAPWriter.writeWord(byteWriter, nArray[0]);
                        if (nArray[1] < 0) {
                            byteWriter.run(96);
                            byteWriter.run(96);
                            byteWriter.run(96);
                        } else {
                            byteWriter.run(76);
                            ASAPWriter.writeWord(byteWriter, nArray[1]);
                        }
                        byteWriter.run(aSAPInfo.defaultSong);
                        break;
                    }
                    case 3: {
                        throw new Exception("Impossible conversion");
                    }
                    default: {
                        ASAPWriter.writeBytes(byteWriter, ASAPWriter.getBinaryResource("xexb.obx", 183), 2, 183);
                        ASAPWriter.writeWord(byteWriter, nArray[0]);
                        byteWriter.run(76);
                        ASAPWriter.writeWord(byteWriter, nArray[1]);
                        byteWriter.run(aSAPInfo.defaultSong);
                        byteWriter.run(aSAPInfo.fastplay & 1);
                        byteWriter.run((aSAPInfo.fastplay >> 1) % 156);
                        byteWriter.run((aSAPInfo.fastplay >> 1) % 131);
                        byteWriter.run(aSAPInfo.fastplay / 312);
                        byteWriter.run(aSAPInfo.fastplay / 262);
                    }
                }
                if (bl) {
                    ASAPWriter.writeXexInfo(byteWriter, aSAPInfo);
                }
                ASAPWriter.writeWord(byteWriter, 736);
                ASAPWriter.writeWord(byteWriter, 737);
                ASAPWriter.writeWord(byteWriter, bl ? 256 : 292);
                return;
            }
        }
        String string2 = aSAPInfo.getOriginalModuleExt(byArray, n);
        if (string2 != null && (n3 == (n2 = string2.charAt(0) + (string2.charAt(1) << 8) + (string2.charAt(2) << 16) | 0x202020) || n3 == 3698036 && n2 == 6516084)) {
            ASAPWriter.writeNative(byteWriter, aSAPInfo, byArray, n);
            return;
        }
        throw new Exception("Impossible conversion");
    }

    private static void writeBytes(ByteWriter byteWriter, byte[] byArray, int n, int n2) {
        while (n < n2) {
            byteWriter.run(byArray[n++] & 0xFF);
        }
    }

    private static void writeCmcInit(ByteWriter byteWriter, int[] nArray, ASAPInfo aSAPInfo) {
        if (nArray == null) {
            return;
        }
        ASAPWriter.writeWord(byteWriter, 4064);
        ASAPWriter.writeWord(byteWriter, 4080);
        byteWriter.run(72);
        byteWriter.run(162);
        byteWriter.run(aSAPInfo.music & 0xFF);
        byteWriter.run(160);
        byteWriter.run(aSAPInfo.music >> 8);
        byteWriter.run(169);
        byteWriter.run(112);
        byteWriter.run(32);
        ASAPWriter.writeWord(byteWriter, nArray[1] + 3);
        ASAPWriter.writePlaTaxLda0(byteWriter);
        byteWriter.run(76);
        ASAPWriter.writeWord(byteWriter, nArray[1] + 3);
        nArray[0] = 4064;
        nArray[1] = nArray[1] + 6;
    }

    private static void writeDec(ByteWriter byteWriter, int n) {
        if (n >= 10) {
            ASAPWriter.writeDec(byteWriter, n / 10);
            n %= 10;
        }
        byteWriter.run(48 + n);
    }

    private static void writeDecSapTag(ByteWriter byteWriter, String string, int n) {
        ASAPWriter.writeString(byteWriter, string);
        ASAPWriter.writeDec(byteWriter, n);
        byteWriter.run(13);
        byteWriter.run(10);
    }

    static void writeExecutable(ByteWriter byteWriter, int[] nArray, ASAPInfo aSAPInfo, byte[] byArray, int n) throws Exception {
        byte[] byArray2 = ASAP6502.getPlayerRoutine(aSAPInfo);
        int n2 = -1;
        int n3 = -1;
        if (byArray2 != null) {
            n2 = ASAPInfo.getWord(byArray2, 2);
            n3 = ASAPInfo.getWord(byArray2, 4);
            if (aSAPInfo.music <= n3) {
                throw new Exception("Module address conflicts with the player routine");
            }
        }
        switch (aSAPInfo.type) {
            case 0: {
                ASAPWriter.writeExecutableFromSap(byteWriter, nArray, aSAPInfo, 66, byArray, n);
                break;
            }
            case 1: {
                ASAPWriter.writeExecutableFromSap(byteWriter, nArray, aSAPInfo, 67, byArray, n);
                ASAPWriter.writeCmcInit(byteWriter, nArray, aSAPInfo);
                break;
            }
            case 2: {
                ASAPWriter.writeExecutableFromSap(byteWriter, nArray, aSAPInfo, 68, byArray, n);
                break;
            }
            case 3: {
                ASAPWriter.writeExecutableFromSap(byteWriter, nArray, aSAPInfo, 83, byArray, n);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 67, -1, n2);
                byteWriter.run(255);
                byteWriter.run(255);
                ASAPWriter.writeBytes(byteWriter, byArray, 2, n);
                ASAPWriter.writeBytes(byteWriter, byArray2, 2, n3 - n2 + 7);
                ASAPWriter.writeCmcInit(byteWriter, nArray, aSAPInfo);
                break;
            }
            case 8: {
                int n4 = ASAPWriter.writeExecutableHeaderForSongPos(byteWriter, nArray, aSAPInfo, n2, 5, 7, 259);
                if (n == 11270) {
                    ASAPWriter.writeBytes(byteWriter, byArray, 0, 4);
                    ASAPWriter.writeWord(byteWriter, 19456);
                    ASAPWriter.writeBytes(byteWriter, byArray, 6, n);
                    byteWriter.run(0);
                } else {
                    ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                }
                ASAPWriter.writeWord(byteWriter, n4);
                ASAPWriter.writeWord(byteWriter, n3);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writeBytes(byteWriter, aSAPInfo.songPos, 0, aSAPInfo.songs);
                    byteWriter.run(170);
                    byteWriter.run(188);
                    ASAPWriter.writeWord(byteWriter, n4);
                } else {
                    byteWriter.run(160);
                    byteWriter.run(0);
                }
                byteWriter.run(76);
                ASAPWriter.writeWord(byteWriter, n2 + 256);
                ASAPWriter.writeBytes(byteWriter, byArray2, 6, n3 - n2 + 7);
                break;
            }
            case 9: {
                int n5 = ASAPWriter.writeExecutableHeaderForSongPos(byteWriter, nArray, aSAPInfo, n2, 13, 17, 3);
                ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                ASAPWriter.writeWord(byteWriter, n5);
                ASAPWriter.writeWord(byteWriter, n3);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writeBytes(byteWriter, aSAPInfo.songPos, 0, aSAPInfo.songs);
                    byteWriter.run(72);
                }
                byteWriter.run(160);
                byteWriter.run(aSAPInfo.music & 0xFF);
                byteWriter.run(162);
                byteWriter.run(aSAPInfo.music >> 8);
                byteWriter.run(169);
                byteWriter.run(0);
                byteWriter.run(32);
                ASAPWriter.writeWord(byteWriter, n2);
                if (aSAPInfo.songs != 1) {
                    byteWriter.run(104);
                    byteWriter.run(168);
                    byteWriter.run(190);
                    ASAPWriter.writeWord(byteWriter, n5);
                } else {
                    byteWriter.run(162);
                    byteWriter.run(0);
                }
                byteWriter.run(169);
                byteWriter.run(2);
                ASAPWriter.writeBytes(byteWriter, byArray2, 6, n3 - n2 + 7);
                break;
            }
            case 10: {
                ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, 3200, 1539);
                ASAPWriter.writeBytes(byteWriter, byArray, 0, ASAPInfo.getWord(byArray, 4) - aSAPInfo.music + 7);
                ASAPWriter.writeWord(byteWriter, 3200);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writeWord(byteWriter, 3210 + aSAPInfo.songs);
                    byteWriter.run(168);
                    byteWriter.run(185);
                    ASAPWriter.writeWord(byteWriter, 3211);
                } else {
                    ASAPWriter.writeWord(byteWriter, 3208);
                    byteWriter.run(169);
                    byteWriter.run(0);
                }
                byteWriter.run(162);
                byteWriter.run(aSAPInfo.music & 0xFF);
                byteWriter.run(160);
                byteWriter.run(aSAPInfo.music >> 8);
                byteWriter.run(76);
                ASAPWriter.writeWord(byteWriter, 1536);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writeBytes(byteWriter, aSAPInfo.songPos, 0, aSAPInfo.songs);
                }
                ASAPWriter.writeBytes(byteWriter, byArray2, 2, n3 - n2 + 7);
                break;
            }
            case 11: {
                int n6 = n2 + CI_CONST_ARRAY_1[(byArray[37] & 0xFF) - 1];
                int n7 = n6 + CI_CONST_ARRAY_2[(byArray[37] & 0xFF) - 1];
                if (aSAPInfo.songs != 1) {
                    n7 -= 3;
                }
                ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, n7, n6);
                ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                ASAPWriter.writeWord(byteWriter, n7);
                ASAPWriter.writeWord(byteWriter, n3);
                if (aSAPInfo.songs != 1) {
                    byteWriter.run(72);
                }
                byteWriter.run(160);
                byteWriter.run(aSAPInfo.music & 0xFF);
                byteWriter.run(162);
                byteWriter.run(aSAPInfo.music >> 8);
                byteWriter.run(169);
                byteWriter.run(112);
                byteWriter.run(32);
                ASAPWriter.writeWord(byteWriter, n2);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writePlaTaxLda0(byteWriter);
                } else {
                    byteWriter.run(169);
                    byteWriter.run(96);
                }
                switch (byArray[37]) {
                    case 2: {
                        byteWriter.run(6);
                        byteWriter.run(0);
                        byteWriter.run(76);
                        ASAPWriter.writeWord(byteWriter, n2);
                        byteWriter.run(165);
                        byteWriter.run(0);
                        byteWriter.run(230);
                        byteWriter.run(0);
                        byteWriter.run(74);
                        byteWriter.run(144);
                        byteWriter.run(5);
                        byteWriter.run(176);
                        byteWriter.run(6);
                        break;
                    }
                    case 3: 
                    case 4: {
                        byteWriter.run(160);
                        byteWriter.run(1);
                        byteWriter.run(132);
                        byteWriter.run(0);
                        byteWriter.run(208);
                        byteWriter.run(10);
                        byteWriter.run(198);
                        byteWriter.run(0);
                        byteWriter.run(208);
                        byteWriter.run(12);
                        byteWriter.run(160);
                        byteWriter.run(byArray[37] & 0xFF);
                        byteWriter.run(132);
                        byteWriter.run(0);
                        byteWriter.run(208);
                        byteWriter.run(3);
                    }
                }
                ASAPWriter.writeBytes(byteWriter, byArray2, 6, n3 - n2 + 7);
                break;
            }
            case 12: {
                ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, 4992, 2051);
                ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                ASAPWriter.writeWord(byteWriter, 4992);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writeWord(byteWriter, 5008);
                    byteWriter.run(72);
                } else {
                    ASAPWriter.writeWord(byteWriter, 5006);
                }
                byteWriter.run(160);
                byteWriter.run(aSAPInfo.music & 0xFF);
                byteWriter.run(162);
                byteWriter.run(aSAPInfo.music >> 8);
                byteWriter.run(169);
                byteWriter.run(112);
                byteWriter.run(32);
                ASAPWriter.writeWord(byteWriter, 2048);
                if (aSAPInfo.songs != 1) {
                    ASAPWriter.writePlaTaxLda0(byteWriter);
                } else {
                    byteWriter.run(169);
                    byteWriter.run(0);
                    byteWriter.run(170);
                }
                byteWriter.run(76);
                ASAPWriter.writeWord(byteWriter, 2048);
                ASAPWriter.writeBytes(byteWriter, byArray2, 2, n3 - n2 + 7);
                break;
            }
            case 13: {
                ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, n2, n2 + 3);
                ASAPWriter.writeWord(byteWriter, 65535);
                ASAPWriter.writeWord(byteWriter, aSAPInfo.music);
                ASAPWriter.writeWord(byteWriter, aSAPInfo.music + n - 1);
                ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                ASAPWriter.writeBytes(byteWriter, byArray2, 2, n3 - n2 + 7);
            }
        }
    }

    private static void writeExecutableFromSap(ByteWriter byteWriter, int[] nArray, ASAPInfo aSAPInfo, int n, byte[] byArray, int n2) {
        ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, n, aSAPInfo.init, aSAPInfo.player);
        ASAPWriter.writeBytes(byteWriter, byArray, aSAPInfo.headerLen, n2);
    }

    private static void writeExecutableHeader(ByteWriter byteWriter, int[] nArray, ASAPInfo aSAPInfo, int n, int n2, int n3) {
        if (nArray == null) {
            ASAPWriter.writeSapHeader(byteWriter, aSAPInfo, n, n2, n3);
        } else {
            nArray[0] = n2;
            nArray[1] = n3;
        }
    }

    private static int writeExecutableHeaderForSongPos(ByteWriter byteWriter, int[] nArray, ASAPInfo aSAPInfo, int n, int n2, int n3, int n4) {
        if (aSAPInfo.songs != 1) {
            ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, n - n3, n + n4);
            return n - n3 - aSAPInfo.songs;
        }
        ASAPWriter.writeExecutableHeader(byteWriter, nArray, aSAPInfo, 66, n - n2, n + n4);
        return n - n2;
    }

    private static void writeHexSapTag(ByteWriter byteWriter, String string, int n) {
        if (n < 0) {
            return;
        }
        ASAPWriter.writeString(byteWriter, string);
        for (int i = 12; i >= 0; i -= 4) {
            int n2;
            byteWriter.run(n2 + ((n2 = n >> i & 0xF) < 10 ? 48 : 55));
        }
        byteWriter.run(13);
        byteWriter.run(10);
    }

    private static void writeNative(ByteWriter byteWriter, ASAPInfo aSAPInfo, byte[] byArray, int n) throws Exception {
        switch (aSAPInfo.type) {
            case 0: 
            case 1: {
                int n2 = aSAPInfo.getRmtSapOffset(byArray, n);
                if (n2 > 0) {
                    byteWriter.run(255);
                    byteWriter.run(255);
                    ASAPWriter.writeBytes(byteWriter, byArray, n2, n);
                    break;
                }
                int n3 = ASAPInfo.getWord(byArray, aSAPInfo.headerLen + 4) - ASAPInfo.getWord(byArray, aSAPInfo.headerLen + 2) + 7;
                if (n3 < 7 || aSAPInfo.headerLen + n3 >= n) {
                    throw new Exception("Cannot extract module from SAP");
                }
                if (aSAPInfo.init == 1024 && aSAPInfo.player == 1027) {
                    ASAPWriter.writeBytes(byteWriter, byArray, aSAPInfo.headerLen + 6, aSAPInfo.headerLen + n3);
                    break;
                }
                ASAPWriter.writeBytes(byteWriter, byArray, aSAPInfo.headerLen, aSAPInfo.headerLen + n3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int n4 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeBytes(byteWriter, byArray, 6, 26);
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n4, byArray, 26, 64);
                ASAPWriter.writeBytes(byteWriter, byArray, 154, n);
                break;
            }
            case 8: {
                int n5 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeBytes(byteWriter, byArray, 6, n);
                break;
            }
            case 9: {
                int n6 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeRelocatedWords(byteWriter, n6, byArray, 6, 192);
                ASAPWriter.writeBytes(byteWriter, byArray, 198, 454);
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n6, byArray, 454, 4);
                ASAPWriter.writeBytes(byteWriter, byArray, 462, n);
                break;
            }
            case 10: {
                int n7 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeBytes(byteWriter, byArray, 6, 14);
                int n8 = ASAPInfo.getWord(byArray, 2);
                int n9 = ASAPInfo.getWord(byArray, 16);
                int n10 = n9 - n8 - 8;
                ASAPWriter.writeRelocatedWords(byteWriter, n7, byArray, 14, n10);
                int n11 = ASAPInfo.getWord(byArray, 18) - n9;
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n7, byArray, 14 + n10, n11);
                int n12 = 6 + ASAPInfo.getWord(byArray, 20) - n8;
                ASAPWriter.writeBytes(byteWriter, byArray, 14 + n10 + (n11 << 1), n12);
                int n13 = 7 + ASAPInfo.getWord(byArray, 4) - n8;
                while (n12 + 3 < n13) {
                    int n14 = n12 + (byArray[9] & 0xFF) - 48;
                    if (byArray[n12] == -2) {
                        byteWriter.run(254);
                        byteWriter.run(byArray[n12 + 1] & 0xFF);
                        ASAPWriter.writeWord(byteWriter, ASAPInfo.getWord(byArray, n12 + 2) + n7);
                        n12 += 4;
                    }
                    if (n14 > n13) {
                        n14 = n13;
                    }
                    ASAPWriter.writeBytes(byteWriter, byArray, n12, n14);
                    n12 = n14;
                }
                ASAPWriter.writeBytes(byteWriter, byArray, n12, n13);
                if (n < n13 + 5) break;
                ASAPWriter.writeRelocatedWords(byteWriter, n7, byArray, n13, 4);
                ASAPWriter.writeBytes(byteWriter, byArray, n13 + 4, n);
                break;
            }
            case 11: {
                int n15 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeBytes(byteWriter, byArray, 6, 38);
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n15, byArray, 38, 64);
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n15, byArray, 166, 128);
                ASAPWriter.writeBytes(byteWriter, byArray, 422, n);
                break;
            }
            case 12: {
                int n16 = ASAPWriter.writeNativeHeader(byteWriter, aSAPInfo, byArray);
                ASAPWriter.writeBytes(byteWriter, byArray, 6, 134);
                ASAPWriter.writeRelocatedBytes(byteWriter, n16, byArray, 134, 774, 128, 0);
                ASAPWriter.writeRelocatedLowHigh(byteWriter, n16, byArray, 262, 256);
                ASAPWriter.writeRelocatedBytes(byteWriter, n16, byArray, 134, 774, 128, 8);
                ASAPWriter.writeBytes(byteWriter, byArray, 902, n);
                break;
            }
            case 13: {
                ASAPWriter.writeBytes(byteWriter, byArray, 0, n);
                break;
            }
            default: {
                throw new Exception("Impossible conversion");
            }
        }
    }

    private static int writeNativeHeader(ByteWriter byteWriter, ASAPInfo aSAPInfo, byte[] byArray) throws Exception {
        int n = aSAPInfo.music - ASAPInfo.getWord(byArray, 2);
        int n2 = ASAPInfo.getWord(byArray, 4) + n;
        if (n2 > 65535) {
            throw new Exception("Address set too high");
        }
        byteWriter.run(255);
        byteWriter.run(255);
        ASAPWriter.writeWord(byteWriter, aSAPInfo.music);
        ASAPWriter.writeWord(byteWriter, n2);
        return n;
    }

    private static void writePlaTaxLda0(ByteWriter byteWriter) {
        byteWriter.run(104);
        byteWriter.run(170);
        byteWriter.run(169);
        byteWriter.run(0);
    }

    private static void writeRelocatedBytes(ByteWriter byteWriter, int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n4; ++i) {
            int n6 = (byArray[n2 + i] & 0xFF) + ((byArray[n3 + i] & 0xFF) << 8);
            if (n6 != 0 && n6 != 65535) {
                n6 += n;
            }
            byteWriter.run(n6 >> n5 & 0xFF);
        }
    }

    private static void writeRelocatedLowHigh(ByteWriter byteWriter, int n, byte[] byArray, int n2, int n3) {
        ASAPWriter.writeRelocatedBytes(byteWriter, n, byArray, n2, n2 + n3, n3, 0);
        ASAPWriter.writeRelocatedBytes(byteWriter, n, byArray, n2, n2 + n3, n3, 8);
    }

    private static void writeRelocatedWords(ByteWriter byteWriter, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; i += 2) {
            int n4 = (byArray[n2 + i] & 0xFF) + ((byArray[n2 + i + 1] & 0xFF) << 8);
            if (n4 != 0 && n4 != 65535) {
                n4 += n;
            }
            ASAPWriter.writeWord(byteWriter, n4);
        }
    }

    private static void writeSapHeader(ByteWriter byteWriter, ASAPInfo aSAPInfo, int n, int n2, int n3) {
        ASAPWriter.writeString(byteWriter, "SAP\r\n");
        ASAPWriter.writeTextSapTag(byteWriter, "AUTHOR ", aSAPInfo.author);
        ASAPWriter.writeTextSapTag(byteWriter, "NAME ", aSAPInfo.title);
        ASAPWriter.writeTextSapTag(byteWriter, "DATE ", aSAPInfo.date);
        if (aSAPInfo.songs > 1) {
            ASAPWriter.writeDecSapTag(byteWriter, "SONGS ", aSAPInfo.songs);
            if (aSAPInfo.defaultSong > 0) {
                ASAPWriter.writeDecSapTag(byteWriter, "DEFSONG ", aSAPInfo.defaultSong);
            }
        }
        if (aSAPInfo.channels > 1) {
            ASAPWriter.writeString(byteWriter, "STEREO\r\n");
        }
        if (aSAPInfo.ntsc) {
            ASAPWriter.writeString(byteWriter, "NTSC\r\n");
        }
        ASAPWriter.writeString(byteWriter, "TYPE ");
        byteWriter.run(n);
        byteWriter.run(13);
        byteWriter.run(10);
        if (aSAPInfo.fastplay != 312 || aSAPInfo.ntsc) {
            ASAPWriter.writeDecSapTag(byteWriter, "FASTPLAY ", aSAPInfo.fastplay);
        }
        if (n == 67) {
            ASAPWriter.writeHexSapTag(byteWriter, "MUSIC ", aSAPInfo.music);
        }
        ASAPWriter.writeHexSapTag(byteWriter, "INIT ", n2);
        ASAPWriter.writeHexSapTag(byteWriter, "PLAYER ", n3);
        ASAPWriter.writeHexSapTag(byteWriter, "COVOX ", aSAPInfo.covoxAddr);
        for (int i = 0; i < aSAPInfo.songs && aSAPInfo.durations[i] >= 0; ++i) {
            ASAPWriter.writeString(byteWriter, "TIME ");
            byte[] byArray = new byte[9];
            ASAPWriter.writeBytes(byteWriter, byArray, 0, ASAPWriter.durationToString(byArray, aSAPInfo.durations[i]));
            if (aSAPInfo.loops[i]) {
                ASAPWriter.writeString(byteWriter, " LOOP");
            }
            byteWriter.run(13);
            byteWriter.run(10);
        }
    }

    private static void writeString(ByteWriter byteWriter, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byteWriter.run(string.charAt(i));
        }
    }

    private static void writeTextSapTag(ByteWriter byteWriter, String string, String string2) {
        ASAPWriter.writeString(byteWriter, string);
        byteWriter.run(34);
        if (string2.length() == 0) {
            string2 = "<?>";
        }
        ASAPWriter.writeString(byteWriter, string2);
        byteWriter.run(34);
        byteWriter.run(13);
        byteWriter.run(10);
    }

    private static void writeWord(ByteWriter byteWriter, int n) {
        byteWriter.run(n & 0xFF);
        byteWriter.run(n >> 8 & 0xFF);
    }

    private static void writeXexInfo(ByteWriter byteWriter, ASAPInfo aSAPInfo) {
        int n;
        int n2;
        byte[] byArray = new byte[256];
        int n3 = ASAPWriter.formatXexInfoText(byArray, 0, 0, aSAPInfo.title.length() == 0 ? "(untitled)" : aSAPInfo.title, false);
        byte[] byArray2 = new byte[256];
        if (aSAPInfo.author.length() > 0) {
            byArray2[0] = 98;
            byArray2[1] = 121;
            byArray2[2] = 32;
            n2 = ASAPWriter.formatXexInfoText(byArray2, 3, 0, aSAPInfo.author, true);
        } else {
            n2 = 0;
        }
        byte[] byArray3 = new byte[256];
        int n4 = ASAPWriter.formatXexInfoText(byArray3, 0, 19, aSAPInfo.date, false);
        n4 = ASAPWriter.formatXexInfoText(byArray3, n4, 27, aSAPInfo.channels > 1 ? " STEREO" : "   MONO", false);
        int n5 = aSAPInfo.durations[aSAPInfo.defaultSong];
        n4 = n5 > 0 && ASAPWriter.secondsToString(byArray3, n4, n5 + 999) ? (n4 += 5) : ASAPWriter.padXexInfo(byArray3, n4, 0);
        int n6 = n3 + n2 + n4;
        int n7 = n6 / 32;
        int n8 = 64592 - n4;
        int n9 = n8 - n2 - 8 - n3;
        ASAPWriter.writeWord(byteWriter, n9);
        ASAPWriter.writeBytes(byteWriter, ASAPWriter.getBinaryResource("xexinfo.obx", 178), 4, 6);
        ASAPWriter.writeBytes(byteWriter, byArray, 0, n3);
        for (n = 0; n < 8; ++n) {
            byteWriter.run(85);
        }
        ASAPWriter.writeBytes(byteWriter, byArray2, 0, n2);
        ASAPWriter.writeBytes(byteWriter, byArray3, 0, n4);
        for (n = n7; n < 26; ++n) {
            byteWriter.run(112);
        }
        byteWriter.run(48);
        ASAPWriter.writeXexInfoTextDl(byteWriter, n9, n3, n3 - 32);
        byteWriter.run(8);
        byteWriter.run(0);
        for (n = 0; n < n2; n += 32) {
            byteWriter.run(2);
        }
        byteWriter.run(16);
        for (n = 0; n < n4; n += 32) {
            byteWriter.run(2);
        }
        ASAPWriter.writeBytes(byteWriter, ASAPWriter.getBinaryResource("xexinfo.obx", 178), 6, 178);
    }

    private static void writeXexInfoTextDl(ByteWriter byteWriter, int n, int n2, int n3) {
        byteWriter.run(n3 == 0 ? 98 : 66);
        ASAPWriter.writeWord(byteWriter, n);
        for (int i = 32; i < n2; i += 32) {
            byteWriter.run(i == n3 ? 34 : 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBinaryResource(String string, int n) {
        DataInputStream dataInputStream = new DataInputStream(ASAPWriter.class.getResourceAsStream(string));
        byte[] byArray = new byte[n];
        try {
            try {
                dataInputStream.readFully(byArray);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        return byArray;
    }
}

