/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import java.io.ByteArrayOutputStream;
import net.sf.asap.ASAPInfo;
import net.sf.asap.ASAPWriter;
import net.sf.asap.ByteWriter;

public class ASAPMusicRoutine {
    private final byte[] binary;
    private final int initAddress;
    private final boolean fulltime;
    private final int playerAddress;
    private final int playerRate;

    public ASAPMusicRoutine(String string, byte[] byArray, int n) throws Exception {
        ASAPInfo aSAPInfo = new ASAPInfo();
        aSAPInfo.load(string, byArray, n);
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int[] nArray = new int[2];
        ASAPWriter.writeExecutable(new ByteWriter(){

            public void run(int n) {
                byteArrayOutputStream.write(n);
            }
        }, nArray, aSAPInfo, byArray, n);
        this.binary = byteArrayOutputStream.toByteArray();
        this.initAddress = nArray[0];
        this.fulltime = aSAPInfo.type == 2;
        this.playerAddress = nArray[1];
        this.playerRate = aSAPInfo.fastplay;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public int getInitAddress() {
        return this.initAddress;
    }

    public boolean isFulltime() {
        return this.fulltime;
    }

    public int getPlayerAddress() {
        return this.playerAddress;
    }

    public int getPlayerRate() {
        return this.playerRate;
    }
}

