/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

public class ASAPInfo {
    String author;
    int channels;
    public static final String COPYRIGHT = "This program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published\nby the Free Software Foundation; either version 2 of the License,\nor (at your option) any later version.";
    int covoxAddr;
    public static final String CREDITS = "Another Slight Atari Player (C) 2005-2014 Piotr Fusik\nCMC, MPT, TMC, TM2 players (C) 1994-2005 Marcin Lewandowski\nRMT player (C) 2002-2005 Radek Sterba\nDLT player (C) 2009 Marek Konopka\nCMS player (C) 1999 David Spilka\nFC player (C) 2011 Jerzy Kut\n";
    String date;
    int defaultSong;
    final int[] durations = new int[32];
    int fastplay;
    private String filename;
    int headerLen;
    int init;
    final boolean[] loops = new boolean[32];
    public static final int MAX_MODULE_LENGTH = 65000;
    public static final int MAX_SONGS = 32;
    public static final int MAX_TEXT_LENGTH = 127;
    int music;
    boolean ntsc;
    int player;
    final byte[] songPos = new byte[32];
    int songs;
    String title;
    int type;
    public static final String VERSION = "3.2.0";
    public static final int VERSION_MAJOR = 3;
    public static final int VERSION_MICRO = 0;
    public static final int VERSION_MINOR = 2;
    public static final String YEARS = "2005-2014";
    private static final byte[] CI_CONST_ARRAY_1 = new byte[]{16, 8, 4, 3, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1};

    private void addSong(int n) {
        this.durations[this.songs++] = (int)((long)(n * this.fastplay) * 38000L / 591149L);
    }

    private static int afterFF(byte[] byArray, int n, int n2) throws Exception {
        while (n2 < n) {
            if (byArray[n2++] != -1) continue;
            return n2;
        }
        throw new Exception("Module too short");
    }

    private int checkDate() {
        int n = this.date.length();
        switch (n) {
            case 10: {
                if (!this.checkTwoDateDigits(0) || this.date.charAt(2) != '/') {
                    return -1;
                }
            }
            case 7: {
                if (!this.checkTwoDateDigits(n - 7) || this.date.charAt(n - 5) != '/') {
                    return -1;
                }
            }
            case 4: {
                if (!this.checkTwoDateDigits(n - 4) || !this.checkTwoDateDigits(n - 2)) {
                    return -1;
                }
                return n;
            }
        }
        return -1;
    }

    private boolean checkTwoDateDigits(int n) {
        char c = this.date.charAt(n);
        char c2 = this.date.charAt(n + 1);
        return c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9';
    }

    private static void checkValidChar(int n) throws Exception {
        if (!ASAPInfo.isValidChar(n)) {
            throw new Exception("Invalid character");
        }
    }

    private static void checkValidText(String string) throws Exception {
        int n = string.length();
        if (n > 127) {
            throw new Exception("Text too long");
        }
        for (int i = 0; i < n; ++i) {
            ASAPInfo.checkValidChar(string.charAt(i));
        }
    }

    public final String getAuthor() {
        return this.author;
    }

    public final int getChannels() {
        return this.channels;
    }

    public final int getCovoxAddress() {
        return this.covoxAddr;
    }

    public final String getDate() {
        return this.date;
    }

    public final int getDayOfMonth() {
        int n = this.checkDate();
        if (n != 10) {
            return -1;
        }
        return this.getTwoDateDigits(0);
    }

    public final int getDefaultSong() {
        return this.defaultSong;
    }

    public final int getDuration(int n) {
        return this.durations[n];
    }

    public static String getExtDescription(String string) throws Exception {
        switch (string.length() >> 1 == 1 ? string.charAt(0) + (string.charAt(1) << 8) + (string.length() == 3 ? string.charAt(2) << 16 : 0) | 0x202020 : 0) {
            case 7364979: {
                return "Slight Atari Player";
            }
            case 0x636D63: {
                return "Chaos Music Composer";
            }
            case 0x336D63: {
                return "CMC \"3/4\"";
            }
            case 7499107: {
                return "CMC \"Rzog\"";
            }
            case 7564643: {
                return "Stereo Double CMC";
            }
            case 6516068: {
                return "DoublePlay CMC";
            }
            case 7629924: {
                return "Delta Music Composer";
            }
            case 7630957: {
                return "Music ProTracker";
            }
            case 6582381: {
                return "MPT DoublePlay";
            }
            case 7630194: {
                return "Raster Music Tracker";
            }
            case 3698036: 
            case 6516084: {
                return "Theta Music Composer 1.x";
            }
            case 3304820: {
                return "Theta Music Composer 2.x";
            }
            case 2122598: {
                return "Future Composer";
            }
            case 7890296: {
                return "Atari 8-bit executable";
            }
        }
        throw new Exception("Unknown extension");
    }

    public final int getInitAddress() {
        return this.init;
    }

    public final boolean getLoop(int n) {
        return this.loops[n];
    }

    public final int getMonth() {
        int n = this.checkDate();
        if (n < 7) {
            return -1;
        }
        return this.getTwoDateDigits(n - 7);
    }

    public final int getMusicAddress() {
        return this.music;
    }

    public final String getOriginalModuleExt(byte[] byArray, int n) {
        switch (this.type) {
            case 0: {
                if ((this.init == 1019 || this.init == 1017) && this.player == 1283) {
                    return "dlt";
                }
                if ((this.init == 1267 || this.init == 1263) && this.player == 1283 || this.init == 62707 && this.player == 62723) {
                    return this.fastplay == 156 ? "mpd" : "mpt";
                }
                if (this.init == 3200 || this.getRmtSapOffset(byArray, n) > 0) {
                    return "rmt";
                }
                if (this.init == 1269 || this.init == 62709 || this.init == 1266 || (this.init == 1255 || this.init == 62695 || this.init == 1252) && this.fastplay == 156 || (this.init == 1253 || this.init == 62693 || this.init == 1250) && (this.fastplay == 104 || this.fastplay == 78)) {
                    return "tmc";
                }
                if (this.init == 4224 && this.player == 1283 || this.init == 4992 && this.player == 2051) {
                    return "tm2";
                }
                if (this.init == 1024 && this.player == 1027) {
                    return "fc";
                }
                return null;
            }
            case 1: {
                if ((this.player == 1280 || this.player == 62720) && n >= 1024) {
                    if (this.fastplay == 156) {
                        return "dmc";
                    }
                    if (this.channels > 1) {
                        return "cms";
                    }
                    if (byArray[n - 170] == 30) {
                        return "cmr";
                    }
                    if (byArray[n - 909] == 48) {
                        return "cm3";
                    }
                    return "cmc";
                }
                return null;
            }
            case 4: {
                return this.fastplay == 156 ? "dmc" : "cmc";
            }
            case 5: {
                return "cm3";
            }
            case 6: {
                return "cmr";
            }
            case 7: {
                return "cms";
            }
            case 8: {
                return "dlt";
            }
            case 9: {
                return this.fastplay == 156 ? "mpd" : "mpt";
            }
            case 10: {
                return "rmt";
            }
            case 11: {
                return "tmc";
            }
            case 12: {
                return "tm2";
            }
            case 13: {
                return "fc";
            }
        }
        return null;
    }

    static int getPackedExt(String string) {
        int n = 0;
        int n2 = string.length();
        while (--n2 > 0) {
            char c = string.charAt(n2);
            if (c <= ' ' || c > 'z') {
                return 0;
            }
            if (c == '.') {
                return n | 0x202020;
            }
            n = (n << 8) + c;
        }
        return 0;
    }

    public final int getPlayerAddress() {
        return this.player;
    }

    public final int getPlayerRateHz() {
        int n = this.ntsc ? 15699 : 15556;
        return (n + (this.fastplay >> 1)) / this.fastplay;
    }

    public final int getPlayerRateScanlines() {
        return this.fastplay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getRmtInstrumentFrames(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = ASAPInfo.getWord(byArray, 2) - 6;
        n = ASAPInfo.getWord(byArray, 14) - n6 + (n << 1);
        if (byArray[n + 1] == 0) {
            return 0;
        }
        n = ASAPInfo.getWord(byArray, n) - n6;
        int n7 = byArray[12] & 0xFF;
        int n8 = n5 = n3 * n7;
        int n9 = (byArray[n] & 0xFF) + 1 + n5 * 3;
        int n10 = byArray[n + 3] & 0xFF;
        int n11 = (byArray[n + 2] & 0xFF) + 3;
        if (n10 >= n11) {
            return 0;
        }
        int n12 = byArray[n + 6] & 0xFF;
        int n13 = byArray[n + 7] & 0xFF;
        if (n9 >= n11) {
            n9 = (n9 - n11) % (n11 - n10) + n10;
        } else {
            do {
                n4 = byArray[n + n9] & 0xFF;
                if (bl) {
                    n4 >>= 4;
                }
                if ((n4 & 0xF) >= CI_CONST_ARRAY_1[n2]) {
                    n8 = n5 + 1;
                }
                ++n5;
            } while ((n9 += 3) < n11);
        }
        if (n12 == 0) {
            return n8 / n7;
        }
        n4 = 128;
        boolean bl2 = false;
        while (true) {
            if (n9 >= n11) {
                if (bl2) return n8 / n7;
                bl2 = true;
                n9 = n10;
            }
            int n14 = byArray[n + n9] & 0xFF;
            if (bl) {
                n14 >>= 4;
            }
            if ((n14 & 0xF) >= CI_CONST_ARRAY_1[n2]) {
                n8 = n5 + 1;
                bl2 = false;
            }
            ++n5;
            n9 += 3;
            if ((n4 -= n12) >= 0) continue;
            n4 += 256;
            if (--n2 <= n13) return n8 / n7;
        }
    }

    final int getRmtSapOffset(byte[] byArray, int n) {
        if (this.player != 13315) {
            return -1;
        }
        int n2 = this.headerLen + ASAPInfo.getWord(byArray, this.headerLen + 4) - ASAPInfo.getWord(byArray, this.headerLen + 2) + 7;
        if (n2 + 6 >= n || byArray[n2 + 4] != 82 || byArray[n2 + 5] != 77 || byArray[n2 + 6] != 84) {
            return -1;
        }
        return n2;
    }

    public final int getSapHeaderLength() {
        return this.headerLen;
    }

    public final int getSongs() {
        return this.songs;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getTitleOrFilename() {
        return this.title.length() > 0 ? this.title : this.filename;
    }

    private int getTwoDateDigits(int n) {
        return (this.date.charAt(n) - 48) * 10 + this.date.charAt(n + 1) - 48;
    }

    public final int getTypeLetter() {
        switch (this.type) {
            case 0: {
                return 66;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 68;
            }
            case 3: {
                return 83;
            }
        }
        return 0;
    }

    static int getWord(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    public final int getYear() {
        int n = this.checkDate();
        if (n < 0) {
            return -1;
        }
        return this.getTwoDateDigits(n - 4) * 100 + this.getTwoDateDigits(n - 2);
    }

    private static int guessPackedExt(byte[] byArray, int n) throws Exception {
        if (ASAPInfo.validateSap(byArray, n)) {
            return 7364979;
        }
        if (ASAPInfo.validateFc(byArray, n)) {
            return 2122598;
        }
        if (ASAPInfo.validateRmt(byArray, n)) {
            return 7630194;
        }
        throw new Exception("Unknown format");
    }

    private static boolean hasStringAt(byte[] byArray, int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if ((byArray[n + i] & 0xFF) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDltPatternEnd(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            int n3;
            int n4 = byArray[8198 + (i << 8) + n] & 0xFF;
            if (n4 >= 64 || (byArray[n3 = 6 + (n4 << 7) + (n2 << 1)] & 0x80) != 0 || (byArray[n3 + 1] & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isDltTrackEmpty(byte[] byArray, int n) {
        return (byArray[8198 + n] & 0xFF) >= 67 && (byArray[8454 + n] & 0xFF) >= 64 && (byArray[8710 + n] & 0xFF) >= 64 && (byArray[8966 + n] & 0xFF) >= 64;
    }

    private static boolean isFcSongEnd(byte[] byArray, int[] nArray) {
        boolean bl = true;
        block4: for (int i = 0; i < 3; ++i) {
            if (nArray[i] >= 256) {
                return true;
            }
            switch (byArray[3 + (i << 8) + nArray[i]]) {
                case -2: {
                    return true;
                }
                case -1: {
                    continue block4;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public final boolean isNtsc() {
        return this.ntsc;
    }

    public static boolean isOurExt(String string) {
        return ASAPInfo.isOurPackedExt(string.length() >> 1 == 1 ? string.charAt(0) + (string.charAt(1) << 8) + (string.length() == 3 ? string.charAt(2) << 16 : 0) | 0x202020 : 0);
    }

    public static boolean isOurFile(String string) {
        return ASAPInfo.isOurPackedExt(ASAPInfo.getPackedExt(string));
    }

    private static boolean isOurPackedExt(int n) {
        switch (n) {
            case 2122598: 
            case 3304820: 
            case 0x336D63: 
            case 3698036: 
            case 0x636D63: 
            case 6516068: 
            case 6516084: 
            case 6582381: 
            case 7364979: 
            case 7499107: 
            case 7564643: 
            case 7629924: 
            case 7630194: 
            case 7630957: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidChar(int n) {
        return n >= 32 && n <= 124 && n != 96 && n != 123;
    }

    public final void load(String string, byte[] byArray, int n) throws Exception {
        int n2;
        int n3;
        if (string != null) {
            n3 = string.length();
            int n4 = 0;
            n2 = -1;
            int n5 = n3;
            while (--n5 >= 0) {
                char c = string.charAt(n5);
                if (c == '/' || c == '\\') {
                    n4 = n5 + 1;
                    break;
                }
                if (c != '.') continue;
                n2 = n5;
            }
            if (n2 < 0) {
                throw new Exception("Filename has no extension");
            }
            if ((n2 -= n4) > 127) {
                n2 = 127;
            }
            this.filename = string.substring(n4, n4 + n2);
            n2 = ASAPInfo.getPackedExt(string);
        } else {
            this.filename = "";
            n2 = ASAPInfo.guessPackedExt(byArray, n);
        }
        this.author = "";
        this.title = "";
        this.date = "";
        this.channels = 1;
        this.songs = 1;
        this.defaultSong = 0;
        for (n3 = 0; n3 < 32; ++n3) {
            this.durations[n3] = -1;
            this.loops[n3] = false;
        }
        this.ntsc = false;
        this.fastplay = 312;
        this.music = -1;
        this.init = -1;
        this.player = -1;
        this.covoxAddr = -1;
        this.headerLen = 0;
        switch (n2) {
            case 7364979: {
                this.parseSap(byArray, n);
                return;
            }
            case 0x636D63: {
                this.parseCmc(byArray, n, 4);
                return;
            }
            case 0x336D63: {
                this.parseCmc(byArray, n, 5);
                return;
            }
            case 7499107: {
                this.parseCmc(byArray, n, 6);
                return;
            }
            case 7564643: {
                this.channels = 2;
                this.parseCmc(byArray, n, 7);
                return;
            }
            case 6516068: {
                this.fastplay = 156;
                this.parseCmc(byArray, n, 4);
                return;
            }
            case 7629924: {
                this.parseDlt(byArray, n);
                return;
            }
            case 7630957: {
                this.parseMpt(byArray, n);
                return;
            }
            case 6582381: {
                this.fastplay = 156;
                this.parseMpt(byArray, n);
                return;
            }
            case 7630194: {
                this.parseRmt(byArray, n);
                return;
            }
            case 3698036: 
            case 6516084: {
                this.parseTmc(byArray, n);
                return;
            }
            case 3304820: {
                this.parseTm2(byArray, n);
                return;
            }
            case 2122598: {
                this.parseFc(byArray, n);
                return;
            }
        }
        throw new Exception("Unknown filename extension");
    }

    private void parseCmc(byte[] byArray, int n, int n2) throws Exception {
        if (n < 774) {
            throw new Exception("Module too short");
        }
        this.type = n2;
        this.parseModule(byArray, n);
        int n3 = 84;
        while (--n3 >= 0 && (byArray[518 + n3] & 0xFF) >= 176 && (byArray[603 + n3] & 0xFF) >= 64 && (byArray[688 + n3] & 0xFF) >= 64 && (this.channels != 2 || (byArray[774 + n3] & 0xFF) >= 176 && (byArray[859 + n3] & 0xFF) >= 64 && (byArray[944 + n3] & 0xFF) >= 64)) {
        }
        this.songs = 0;
        this.parseCmcSong(byArray, 0);
        for (int i = 0; i < n3 && this.songs < 32; ++i) {
            if (byArray[518 + i] != -113 && byArray[518 + i] != -17) continue;
            this.parseCmcSong(byArray, i + 1);
        }
    }

    private void parseCmcSong(byte[] byArray, int n) {
        int n2 = byArray[25] & 0xFF;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[85];
        block11: while (n >= 0 && n < 85) {
            int n7;
            if (n == n5 && n6 > 0) {
                for (n7 = 0; n7 < 85; ++n7) {
                    if ((byArray2[n7] & 0xFF) != 1 && (byArray2[n7] & 0xFF) != 3) continue;
                    byArray2[n7] = 0;
                }
                --n6;
                n = n4;
            }
            if (byArray2[n] != 0) {
                if ((byArray2[n] & 0xFF) == 1) break;
                this.loops[this.songs] = true;
                break;
            }
            byArray2[n] = 1;
            n7 = byArray[518 + n] & 0xFF;
            int n8 = byArray[603 + n] & 0xFF;
            int n9 = byArray[688 + n] & 0xFF;
            if (n7 == 254 || n8 == 254 || n9 == 254) {
                ++n;
                continue;
            }
            switch (n7 |= this.type == 7 ? 7 : 15) {
                case 135: 
                case 167: {
                    ++n;
                    continue block11;
                }
                case 143: {
                    n = -1;
                    continue block11;
                }
                case 151: {
                    if (n8 < 128) {
                        n3 += n8;
                        if (n9 < 128) {
                            n3 += n9 * 50;
                        }
                    }
                    ++n;
                    continue block11;
                }
                case 159: {
                    n = n8;
                    continue block11;
                }
                case 175: {
                    n -= n8;
                    continue block11;
                }
                case 191: {
                    n += n8;
                    continue block11;
                }
                case 207: {
                    if (n8 < 128) {
                        n2 = n8;
                        ++n;
                        continue block11;
                    }
                    n = -1;
                    continue block11;
                }
                case 223: {
                    n4 = ++n;
                    n5 = n + n8;
                    n6 = n9 - 1;
                    continue block11;
                }
                case 239: {
                    this.loops[this.songs] = true;
                    n = -1;
                    continue block11;
                }
            }
            n8 = n6 > 0 ? 3 : 2;
            for (n7 = 0; n7 < 85; ++n7) {
                if ((byArray2[n7] & 0xFF) != 1) continue;
                byArray2[n7] = (byte)n8;
            }
            n3 += n2 * (this.type == 5 ? 48 : 64);
            ++n;
        }
        this.addSong(n3);
    }

    private static int parseDec(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        if (byArray[n] == 13) {
            throw new Exception("Missing number");
        }
        int n4 = 0;
        do {
            if ((n3 = byArray[n++] & 0xFF) == 13) {
                return n4;
            }
            if (n3 >= 48 && n3 <= 57) continue;
            throw new Exception("Invalid number");
        } while ((n4 = 10 * n4 + n3 - 48) <= n2);
        throw new Exception("Number too big");
    }

    private void parseDlt(byte[] byArray, int n) throws Exception {
        if (n != 11270 && n != 11271) {
            throw new Exception("Invalid module length");
        }
        this.type = 8;
        this.parseModule(byArray, n);
        if (this.music != 8192) {
            throw new Exception("Unsupported module address");
        }
        boolean[] blArray = new boolean[128];
        this.songs = 0;
        for (int i = 0; i < 128 && this.songs < 32; ++i) {
            if (blArray[i]) continue;
            this.parseDltSong(byArray, blArray, i);
        }
        if (this.songs == 0) {
            throw new Exception("No songs found");
        }
    }

    private void parseDltSong(byte[] byArray, boolean[] blArray, int n) {
        while (n < 128 && !blArray[n] && ASAPInfo.isDltTrackEmpty(byArray, n)) {
            blArray[n++] = true;
        }
        this.songPos[this.songs] = (byte)n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 6;
        while (n < 128) {
            if (blArray[n]) {
                bl = true;
                break;
            }
            blArray[n] = true;
            int n4 = byArray[8198 + n] & 0xFF;
            if (n4 == 64 || ASAPInfo.isDltTrackEmpty(byArray, n)) break;
            if (n4 == 65) {
                n = byArray[8326 + n] & 0xFF;
                continue;
            }
            if (n4 == 66) {
                n3 = byArray[8326 + n++] & 0xFF;
                continue;
            }
            for (int i = 0; i < 64 && !ASAPInfo.isDltPatternEnd(byArray, n, i); ++i) {
                n2 += n3;
            }
            ++n;
        }
        if (n2 > 0) {
            this.loops[this.songs] = bl;
            this.addSong(n2);
        }
    }

    public static int parseDuration(String string) throws Exception {
        int n = 0;
        int n2 = string.length();
        if (n >= n2) {
            throw new Exception("Invalid duration");
        }
        int n3 = string.charAt(n) - 48;
        if (n3 < 0 || n3 > 9) {
            throw new Exception("Invalid duration");
        }
        int n4 = n3;
        if (++n < n2) {
            n3 = string.charAt(n) - 48;
            if (n3 >= 0 && n3 <= 9) {
                ++n;
                n4 = 10 * n4 + n3;
            }
            if (n < n2 && string.charAt(n) == ':') {
                if (++n >= n2) {
                    throw new Exception("Invalid duration");
                }
                n3 = string.charAt(n) - 48;
                if (n3 < 0 || n3 > 5) {
                    throw new Exception("Invalid duration");
                }
                n4 = (6 * n4 + n3) * 10;
                if (++n >= n2) {
                    throw new Exception("Invalid duration");
                }
                n3 = string.charAt(n) - 48;
                if (n3 < 0 || n3 > 9) {
                    throw new Exception("Invalid duration");
                }
                ++n;
                n4 += n3;
            }
        }
        n4 *= 1000;
        if (n >= n2) {
            return n4;
        }
        if (string.charAt(n) != '.') {
            throw new Exception("Invalid duration");
        }
        if (++n >= n2) {
            throw new Exception("Invalid duration");
        }
        n3 = string.charAt(n) - 48;
        if (n3 < 0 || n3 > 9) {
            throw new Exception("Invalid duration");
        }
        n4 += 100 * n3;
        if (++n >= n2) {
            return n4;
        }
        n3 = string.charAt(n) - 48;
        if (n3 < 0 || n3 > 9) {
            throw new Exception("Invalid duration");
        }
        n4 += 10 * n3;
        if (++n >= n2) {
            return n4;
        }
        n3 = string.charAt(n) - 48;
        if (n3 < 0 || n3 > 9) {
            throw new Exception("Invalid duration");
        }
        ++n;
        return n4 += n3;
    }

    private void parseFc(byte[] byArray, int n) throws Exception {
        int n2;
        if (!ASAPInfo.validateFc(byArray, n)) {
            throw new Exception("Invalid FC file");
        }
        this.type = 13;
        this.player = 1024;
        this.music = 2560;
        this.songs = 0;
        this.headerLen = -1;
        int[] nArray = new int[64];
        int n3 = 899;
        for (n2 = 0; n2 < 64; ++n2) {
            nArray[n2] = n3;
            n3 = ASAPInfo.afterFF(byArray, n, n3);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            n3 = ASAPInfo.afterFF(byArray, n, n3);
        }
        n2 = 0;
        while (n2 < 256 && this.songs < 32) {
            int n4;
            int n5;
            int[] nArray2 = new int[3];
            for (int i = 0; i < 3; ++i) {
                nArray2[i] = n2;
            }
            int[] nArray3 = new int[3];
            int[] nArray4 = new int[3];
            int[] nArray5 = new int[3];
            int n6 = 0;
            this.loops[this.songs] = true;
            while (!ASAPInfo.isFcSongEnd(byArray, nArray2)) {
                block5: for (n5 = 0; n5 < 3; ++n5) {
                    n4 = byArray[3 + (n5 << 8) + nArray2[n5]] & 0xFF;
                    if (n4 == 255) continue;
                    int n7 = n5;
                    int n8 = nArray3[n7];
                    nArray3[n7] = n8 - 1;
                    if (n8 > 0) continue;
                    while (nArray2[n5] < 256) {
                        n4 = byArray[3 + (n5 << 8) + nArray2[n5]] & 0xFF;
                        if (n4 < 64) {
                            int n9 = n5;
                            int n10 = nArray5[n9];
                            nArray5[n9] = n10 + 1;
                            int n11 = byArray[nArray[n4] + n10] & 0xFF;
                            if (n11 < 64) {
                                nArray3[n5] = nArray4[n5];
                                continue block5;
                            }
                            if (n11 < 96) {
                                nArray4[n5] = n11 - 64;
                                continue;
                            }
                            if (n11 != 255) continue;
                            nArray3[n5] = 0;
                            nArray4[n5] = 0;
                            nArray5[n5] = 0;
                            int n12 = n5;
                            nArray2[n12] = nArray2[n12] + 1;
                            continue;
                        }
                        if (n4 == 64) {
                            int n13 = n5;
                            nArray2[n13] = nArray2[n13] + 2;
                            continue;
                        }
                        if (n4 == 254) {
                            this.loops[this.songs] = false;
                            continue block5;
                        }
                        if (n4 == 255) continue block5;
                        int n14 = n5;
                        nArray2[n14] = nArray2[n14] + 1;
                    }
                }
                if (ASAPInfo.isFcSongEnd(byArray, nArray2)) break;
                n6 += byArray[2] & 0xFF;
            }
            n2 = -1;
            for (n5 = 0; n5 < 3; ++n5) {
                n4 = nArray2[n5];
                if (nArray5[n5] > 0) {
                    ++n4;
                }
                if (n2 >= n4) continue;
                n2 = n4;
            }
            if (++n2 > 256) continue;
            this.addSong(n6);
        }
    }

    private static int parseHex(byte[] byArray, int n) throws Exception {
        if (byArray[n] == 13) {
            throw new Exception("Missing number");
        }
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = byArray[n++] & 0xFF) == 13) {
                return n2;
            }
            if (n2 > 4095) {
                throw new Exception("Number too big");
            }
            n2 <<= 4;
            if (n3 >= 48 && n3 <= 57) {
                n2 += n3 - 48;
                continue;
            }
            if (n3 >= 65 && n3 <= 70) {
                n2 += n3 - 65 + 10;
                continue;
            }
            if (n3 < 97 || n3 > 102) break;
            n2 += n3 - 97 + 10;
        }
        throw new Exception("Invalid number");
    }

    private void parseModule(byte[] byArray, int n) throws Exception {
        if (!(byArray[0] == -1 && byArray[1] == -1 || byArray[0] == 0 && byArray[1] == 0)) {
            throw new Exception("Invalid two leading bytes of the module");
        }
        this.music = ASAPInfo.getWord(byArray, 2);
        int n2 = ASAPInfo.getWord(byArray, 4);
        if (this.music <= 55295 && n2 >= 53248) {
            throw new Exception("Module address conflicts with hardware registers");
        }
        int n3 = n2 + 1 - this.music;
        if (6 + n3 != n) {
            if (this.type != 10 || 11 + n3 > n) {
                throw new Exception("Module length doesn't match headers");
            }
            int n4 = ASAPInfo.getWord(byArray, 6 + n3);
            if (n4 != this.music + n3) {
                throw new Exception("Invalid address of RMT info");
            }
            int n5 = ASAPInfo.getWord(byArray, 8 + n3) + 1 - n4;
            if (10 + n3 + n5 != n) {
                throw new Exception("Invalid RMT info block");
            }
        }
    }

    private void parseMpt(byte[] byArray, int n) throws Exception {
        if (n < 464) {
            throw new Exception("Module too short");
        }
        this.type = 9;
        this.parseModule(byArray, n);
        int n2 = ASAPInfo.getWord(byArray, 2) + 458;
        if ((byArray[454] & 0xFF) + ((byArray[458] & 0xFF) << 8) != n2) {
            throw new Exception("Invalid address of the first track");
        }
        int n3 = (byArray[455] & 0xFF) + ((byArray[459] & 0xFF) << 8) - n2 >> 1;
        if (n3 > 254) {
            throw new Exception("Song too long");
        }
        boolean[] blArray = new boolean[256];
        this.songs = 0;
        for (int i = 0; i < n3 && this.songs < 32; ++i) {
            if (blArray[i]) continue;
            this.songPos[this.songs] = (byte)i;
            this.parseMptSong(byArray, blArray, n3, i);
        }
        if (this.songs == 0) {
            throw new Exception("No songs found");
        }
    }

    private void parseMptSong(byte[] byArray, boolean[] blArray, int n, int n2) {
        int n3 = ASAPInfo.getWord(byArray, 2) - 6;
        int n4 = byArray[463] & 0xFF;
        int n5 = 0;
        byte[] byArray2 = new byte[256];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        while (n2 < n) {
            int n6;
            if (byArray2[n2] != 0) {
                if ((byArray2[n2] & 0xFF) == 1) break;
                this.loops[this.songs] = true;
                break;
            }
            byArray2[n2] = 1;
            blArray[n2] = true;
            int n7 = byArray[464 + n2 * 2] & 0xFF;
            if (n7 == 255) {
                n2 = byArray[465 + n2 * 2] & 0xFF;
                continue;
            }
            for (n6 = 3; n6 >= 0; --n6) {
                n7 = (byArray[454 + n6] & 0xFF) + ((byArray[458 + n6] & 0xFF) << 8) - n3;
                if ((n7 = byArray[n7 + n2 * 2] & 0xFF) >= 64) break;
                n7 <<= 1;
                nArray[n6] = (n7 = ASAPInfo.getWord(byArray, 70 + n7)) == 0 ? 0 : n7 - n3;
                nArray3[n6] = 0;
            }
            if (n6 >= 0) break;
            for (n7 = 0; n7 < n; ++n7) {
                if ((byArray2[n7] & 0xFF) != 1) continue;
                byArray2[n7] = 2;
            }
            int n8 = byArray[462] & 0xFF;
            while (--n8 >= 0) {
                for (n6 = 3; n6 >= 0; --n6) {
                    if (nArray[n6] == 0) continue;
                    int n9 = n6;
                    nArray3[n9] = nArray3[n9] - 1;
                    if (nArray3[n9] >= 0) continue;
                    while (true) {
                        int n10 = n6;
                        int n11 = nArray[n10];
                        nArray[n10] = n11 + 1;
                        n7 = byArray[n11] & 0xFF;
                        if (n7 < 64 || n7 == 254) break;
                        if (n7 < 128) continue;
                        if (n7 < 192) {
                            nArray2[n6] = n7 - 128;
                            continue;
                        }
                        if (n7 < 208) continue;
                        if (n7 < 224) {
                            n4 = n7 - 207;
                            continue;
                        }
                        n8 = 0;
                    }
                    nArray3[n6] = nArray2[n6];
                }
                n5 += n4;
            }
            ++n2;
        }
        if (n5 > 0) {
            this.addSong(n5);
        }
    }

    private void parseRmt(byte[] byArray, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        if (!ASAPInfo.validateRmt(byArray, n)) {
            throw new Exception("Invalid RMT file");
        }
        switch (byArray[9]) {
            case 52: {
                n4 = 2;
                break;
            }
            case 56: {
                this.channels = 2;
                n4 = 3;
                break;
            }
            default: {
                throw new Exception("Unsupported number of channels");
            }
        }
        int n5 = byArray[12] & 0xFF;
        if (n5 < 1 || n5 > 4) {
            throw new Exception("Unsupported player call rate");
        }
        this.type = 10;
        this.parseModule(byArray, n);
        int n6 = ASAPInfo.getWord(byArray, 4) + 1 - this.music;
        int n7 = ASAPInfo.getWord(byArray, 4) + 1 - ASAPInfo.getWord(byArray, 20);
        if (n4 == 3 && (n7 & 4) != 0 && byArray[6 + n6 - 4] == -2) {
            n7 += 4;
        }
        if ((n7 >>= n4) >= 256) {
            throw new Exception("Song too long");
        }
        boolean[] blArray = new boolean[256];
        this.songs = 0;
        for (int i = 0; i < n7 && this.songs < 32; ++i) {
            if (blArray[i]) continue;
            this.songPos[this.songs] = (byte)i;
            this.parseRmtSong(byArray, blArray, n7, n4, i);
        }
        this.fastplay = 312 / n5;
        this.player = 1536;
        if (this.songs == 0) {
            throw new Exception("No songs found");
        }
        byte[] byArray2 = new byte[127];
        for (n3 = 0; n3 < 127 && 10 + n6 + n3 < n && (n2 = byArray[10 + n6 + n3]) != 0; ++n3) {
            byArray2[n3] = ASAPInfo.isValidChar(n2 & 0xFF) ? n2 : 32;
        }
        this.title = new String(byArray2, 0, n3);
    }

    private void parseRmtSong(byte[] byArray, boolean[] blArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = ASAPInfo.getWord(byArray, 2) - 6;
        int n8 = byArray[11] & 0xFF;
        int n9 = 0;
        int n10 = ASAPInfo.getWord(byArray, 20) - n7;
        int n11 = ASAPInfo.getWord(byArray, 16) - n7;
        int n12 = ASAPInfo.getWord(byArray, 18) - n7;
        byte[] byArray2 = new byte[256];
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[8];
        int[] nArray5 = new int[8];
        int[] nArray6 = new int[8];
        int[] nArray7 = new int[8];
        while (n3 < n) {
            if (byArray2[n3] != 0) {
                if ((byArray2[n3] & 0xFF) == 1) break;
                this.loops[this.songs] = true;
                break;
            }
            byArray2[n3] = 1;
            blArray[n3] = true;
            if (byArray[n10 + (n3 << n2)] == -2) {
                n3 = byArray[n10 + (n3 << n2) + 1] & 0xFF;
                continue;
            }
            for (n6 = 0; n6 < 1 << n2; ++n6) {
                n5 = byArray[n10 + (n3 << n2) + n6] & 0xFF;
                if (n5 == 255) {
                    nArray3[n6] = 256;
                    continue;
                }
                nArray2[n6] = nArray[n6] = (byArray[n11 + n5] & 0xFF) + ((byArray[n12 + n5] & 0xFF) << 8) - n7;
                if (nArray2[n6] < 0) {
                    return;
                }
                nArray3[n6] = 0;
            }
            for (n6 = 0; n6 < n; ++n6) {
                if ((byArray2[n6] & 0xFF) != 1) continue;
                byArray2[n6] = 2;
            }
            n6 = byArray[10] & 0xFF;
            while (--n6 >= 0) {
                for (n5 = 0; n5 < 1 << n2; ++n5) {
                    block19: {
                        int n13 = n5;
                        nArray3[n13] = nArray3[n13] - 1;
                        if (nArray3[n13] > 0) continue;
                        while (true) {
                            int n14 = n5;
                            int n15 = nArray2[n14];
                            nArray2[n14] = n15 + 1;
                            n4 = byArray[n15] & 0xFF;
                            if ((n4 & 0x3F) < 62) {
                                int n16 = n5;
                                int n17 = nArray2[n16];
                                nArray2[n16] = n17 + 1;
                                if (((n4 += (byArray[n17] & 0xFF) << 8) & 0x3F) != 61) {
                                    nArray4[n5] = n4 >> 10;
                                    nArray5[n5] = n9;
                                }
                                nArray6[n5] = n4 >> 6 & 0xF;
                                nArray7[n5] = n9;
                                break block19;
                            }
                            if (n4 == 62) {
                                int n18 = n5;
                                int n19 = nArray2[n18];
                                nArray2[n18] = n19 + 1;
                                nArray3[n5] = byArray[n19] & 0xFF;
                                break block19;
                            }
                            if ((n4 & 0x3F) == 62) {
                                nArray3[n5] = n4 >> 6;
                                break block19;
                            }
                            if ((n4 & 0xBF) == 63) {
                                int n20 = n5;
                                int n21 = nArray2[n20];
                                nArray2[n20] = n21 + 1;
                                n8 = byArray[n21] & 0xFF;
                                continue;
                            }
                            if (n4 != 191) break;
                            nArray2[n5] = nArray[n5] + (byArray[nArray2[n5]] & 0xFF);
                        }
                        n6 = -1;
                    }
                    if (n6 < 0) break;
                }
                if (n6 < 0) continue;
                n9 += n8;
            }
            ++n3;
        }
        n6 = 0;
        for (n5 = 0; n5 < 1 << n2; ++n5) {
            n4 = nArray5[n5];
            if (n6 >= (n4 += ASAPInfo.getRmtInstrumentFrames(byArray, nArray4[n5], nArray6[n5], nArray7[n5] - n4, n5 >= 4))) continue;
            n6 = n4;
        }
        if (n9 > n6) {
            if (n9 - n6 > 100) {
                this.loops[this.songs] = false;
            }
            n9 = n6;
        }
        if (n9 > 0) {
            this.addSong(n9);
        }
    }

    private void parseSap(byte[] byArray, int n) throws Exception {
        if (!ASAPInfo.validateSap(byArray, n)) {
            throw new Exception("Invalid SAP file");
        }
        this.fastplay = -1;
        int n2 = 0;
        int n3 = 5;
        int n4 = 0;
        while (byArray[n3] != -1) {
            int n5;
            if (n3 + 8 >= n) {
                throw new Exception("Missing binary part");
            }
            if (ASAPInfo.hasStringAt(byArray, n3, "AUTHOR ")) {
                n5 = ASAPInfo.parseText(byArray, n3 + 7);
                if (n5 > 0) {
                    this.author = new String(byArray, n3 + 7 + 1, n5);
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "NAME ")) {
                n5 = ASAPInfo.parseText(byArray, n3 + 5);
                if (n5 > 0) {
                    this.title = new String(byArray, n3 + 5 + 1, n5);
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "DATE ")) {
                n5 = ASAPInfo.parseText(byArray, n3 + 5);
                if (n5 > 0) {
                    this.date = new String(byArray, n3 + 5 + 1, n5);
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "SONGS ")) {
                this.songs = ASAPInfo.parseDec(byArray, n3 + 6, 32);
                if (this.songs < 1) {
                    throw new Exception("Number too small");
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "DEFSONG ")) {
                this.defaultSong = ASAPInfo.parseDec(byArray, n3 + 8, 31);
                if (this.defaultSong < 0) {
                    throw new Exception("Number too small");
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "STEREO\r")) {
                this.channels = 2;
            } else if (ASAPInfo.hasStringAt(byArray, n3, "NTSC\r")) {
                this.ntsc = true;
            } else if (ASAPInfo.hasStringAt(byArray, n3, "TIME ")) {
                if (n4 >= 32) {
                    throw new Exception("Too many TIME tags");
                }
                n3 += 5;
                n5 = 0;
                while (byArray[n3 + n5] != 13) {
                    ++n5;
                }
                if (n5 > 5 && ASAPInfo.hasStringAt(byArray, n3 + n5 - 5, " LOOP")) {
                    this.loops[n4] = true;
                    n5 -= 5;
                }
                if (n5 > 9) {
                    throw new Exception("Invalid TIME tag");
                }
                String string = new String(byArray, n3, n5);
                int n6 = ASAPInfo.parseDuration(string);
                this.durations[n4++] = n6;
            } else if (ASAPInfo.hasStringAt(byArray, n3, "TYPE ")) {
                n2 = byArray[n3 + 5] & 0xFF;
            } else if (ASAPInfo.hasStringAt(byArray, n3, "FASTPLAY ")) {
                this.fastplay = ASAPInfo.parseDec(byArray, n3 + 9, Short.MAX_VALUE);
                if (this.fastplay < 1) {
                    throw new Exception("Number too small");
                }
            } else if (ASAPInfo.hasStringAt(byArray, n3, "MUSIC ")) {
                this.music = ASAPInfo.parseHex(byArray, n3 + 6);
            } else if (ASAPInfo.hasStringAt(byArray, n3, "INIT ")) {
                this.init = ASAPInfo.parseHex(byArray, n3 + 5);
            } else if (ASAPInfo.hasStringAt(byArray, n3, "PLAYER ")) {
                this.player = ASAPInfo.parseHex(byArray, n3 + 7);
            } else if (ASAPInfo.hasStringAt(byArray, n3, "COVOX ")) {
                this.covoxAddr = ASAPInfo.parseHex(byArray, n3 + 6);
                if (this.covoxAddr != 54784) {
                    throw new Exception("COVOX should be D600");
                }
                this.channels = 2;
            }
            while (byArray[n3++] != 13) {
                if (n3 < n) continue;
                throw new Exception("Malformed SAP header");
            }
            if (byArray[n3++] == 10) continue;
            throw new Exception("Malformed SAP header");
        }
        if (this.defaultSong >= this.songs) {
            throw new Exception("DEFSONG too big");
        }
        switch (n2) {
            case 66: {
                if (this.player < 0) {
                    throw new Exception("Missing PLAYER tag");
                }
                if (this.init < 0) {
                    throw new Exception("Missing INIT tag");
                }
                this.type = 0;
                break;
            }
            case 67: {
                if (this.player < 0) {
                    throw new Exception("Missing PLAYER tag");
                }
                if (this.music < 0) {
                    throw new Exception("Missing MUSIC tag");
                }
                this.type = 1;
                break;
            }
            case 68: {
                if (this.init < 0) {
                    throw new Exception("Missing INIT tag");
                }
                this.type = 2;
                break;
            }
            case 83: {
                if (this.init < 0) {
                    throw new Exception("Missing INIT tag");
                }
                this.type = 3;
                if (this.fastplay >= 0) break;
                this.fastplay = 78;
                break;
            }
            default: {
                throw new Exception("Unsupported TYPE");
            }
        }
        if (this.fastplay < 0) {
            int n7 = this.fastplay = this.ntsc ? 262 : 312;
        }
        if (byArray[n3 + 1] != -1) {
            throw new Exception("Invalid binary header");
        }
        this.headerLen = n3;
    }

    private static int parseText(byte[] byArray, int n) throws Exception {
        if (byArray[n] != 34) {
            throw new Exception("Missing quote");
        }
        if (ASAPInfo.hasStringAt(byArray, n + 1, "<?>\"\r")) {
            return 0;
        }
        int n2 = 0;
        int n3;
        while ((n3 = byArray[n + 1 + n2] & 0xFF) != 34 || byArray[n + 2 + n2] != 13) {
            ASAPInfo.checkValidChar(n3);
            ++n2;
        }
        return n2;
    }

    private void parseTm2(byte[] byArray, int n) throws Exception {
        int n2;
        if (n < 932) {
            throw new Exception("Module too short");
        }
        this.type = 12;
        this.parseModule(byArray, n);
        int n3 = byArray[37] & 0xFF;
        if (n3 < 1 || n3 > 4) {
            throw new Exception("Unsupported player call rate");
        }
        this.fastplay = 312 / n3;
        this.player = 2048;
        if (byArray[31] != 0) {
            this.channels = 2;
        }
        int n4 = 65535;
        for (n3 = 0; n3 < 128; ++n3) {
            n2 = (byArray[134 + n3] & 0xFF) + ((byArray[774 + n3] & 0xFF) << 8);
            if (n2 == 0 || n2 >= n4) continue;
            n4 = n2;
        }
        for (n3 = 0; n3 < 256; ++n3) {
            n2 = (byArray[262 + n3] & 0xFF) + ((byArray[518 + n3] & 0xFF) << 8);
            if (n2 == 0 || n2 >= n4) continue;
            n4 = n2;
        }
        if (902 + (n4 -= ASAPInfo.getWord(byArray, 2) + 896) >= n) {
            throw new Exception("Module too short");
        }
        do {
            if (n4 > 0) continue;
            throw new Exception("No songs found");
        } while ((n2 = byArray[918 + (n4 -= 17)] & 0xFF) == 0 || n2 >= 128);
        this.songs = 0;
        this.parseTm2Song(byArray, 0);
        for (n3 = 0; n3 < n4 && this.songs < 32; n3 += 17) {
            n2 = byArray[918 + n3] & 0xFF;
            if (n2 != 0 && n2 < 128) continue;
            this.parseTm2Song(byArray, n3 + 17);
        }
        byte[] byArray2 = new byte[127];
        int n5 = ASAPInfo.parseTmcTitle(byArray2, 0, byArray, 39);
        n5 = ASAPInfo.parseTmcTitle(byArray2, n5, byArray, 71);
        n5 = ASAPInfo.parseTmcTitle(byArray2, n5, byArray, 103);
        this.title = new String(byArray2, 0, n5);
    }

    private void parseTm2Song(byte[] byArray, int n) {
        int n2;
        int n3 = ASAPInfo.getWord(byArray, 2) - 6;
        int n4 = (byArray[36] & 0xFF) + 1;
        int n5 = 0;
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        while ((n2 = byArray[918 + n] & 0xFF) != 0) {
            int n6;
            int n7;
            if (n2 >= 128) {
                this.loops[this.songs] = true;
                break;
            }
            for (n7 = 7; n7 >= 0; --n7) {
                n6 = byArray[917 + n - 2 * n7] & 0xFF;
                nArray[n7] = (byArray[262 + n6] & 0xFF) + ((byArray[518 + n6] & 0xFF) << 8) - n3;
                nArray2[n7] = 0;
            }
            while (--n2 >= 0) {
                block3: for (n7 = 7; n7 >= 0; --n7) {
                    int n8 = n7;
                    nArray2[n8] = nArray2[n8] - 1;
                    if (nArray2[n8] >= 0) continue;
                    while (true) {
                        int n9 = n7;
                        int n10 = nArray[n9];
                        nArray[n9] = n10 + 1;
                        n6 = byArray[n10] & 0xFF;
                        if (n6 == 0) {
                            int n11 = n7;
                            nArray[n11] = nArray[n11] + 1;
                            continue block3;
                        }
                        if (n6 < 64) {
                            int n12 = n7;
                            int n13 = nArray[n12];
                            nArray[n12] = n13 + 1;
                            if ((byArray[n13] & 0xFF) < 128) continue block3;
                            int n14 = n7;
                            nArray[n14] = nArray[n14] + 1;
                            continue block3;
                        }
                        if (n6 < 128) {
                            int n15 = n7;
                            nArray[n15] = nArray[n15] + 1;
                            continue block3;
                        }
                        if (n6 == 128) {
                            int n16 = n7;
                            int n17 = nArray[n16];
                            nArray[n16] = n17 + 1;
                            nArray2[n7] = byArray[n17] & 0xFF;
                            continue block3;
                        }
                        if (n6 < 192) continue block3;
                        if (n6 >= 208) break;
                        n4 = n6 - 191;
                    }
                    if (n6 < 224) {
                        int n18 = n7;
                        nArray[n18] = nArray[n18] + 1;
                        continue;
                    }
                    if (n6 < 240) {
                        int n19 = n7;
                        nArray[n19] = nArray[n19] + 2;
                        continue;
                    }
                    nArray2[n7] = n6 < 255 ? n6 - 240 : 64;
                }
                n5 += n4;
            }
            n += 17;
        }
        this.addSong(n5);
    }

    private void parseTmc(byte[] byArray, int n) throws Exception {
        if (n < 464) {
            throw new Exception("Module too short");
        }
        this.type = 11;
        this.parseModule(byArray, n);
        this.channels = 2;
        int n2 = 0;
        while (byArray[102 + n2] == 0) {
            if (++n2 < 64) continue;
            throw new Exception("No instruments");
        }
        int n3 = ((byArray[102 + n2] & 0xFF) << 8) + (byArray[38 + n2] & 0xFF) - ASAPInfo.getWord(byArray, 2) - 432;
        if (437 + n3 >= n) {
            throw new Exception("Module too short");
        }
        do {
            if (n3 > 0) continue;
            throw new Exception("No songs found");
        } while ((byArray[437 + (n3 -= 16)] & 0xFF) >= 128);
        this.songs = 0;
        this.parseTmcSong(byArray, 0);
        for (n2 = 0; n2 < n3 && this.songs < 32; n2 += 16) {
            if ((byArray[437 + n2] & 0xFF) < 128) continue;
            this.parseTmcSong(byArray, n2 + 16);
        }
        n2 = byArray[37] & 0xFF;
        if (n2 < 1 || n2 > 4) {
            throw new Exception("Unsupported player call rate");
        }
        this.fastplay = 312 / n2;
        byte[] byArray2 = new byte[127];
        int n4 = ASAPInfo.parseTmcTitle(byArray2, 0, byArray, 6);
        this.title = new String(byArray2, 0, n4);
    }

    private void parseTmcSong(byte[] byArray, int n) {
        int n2 = ASAPInfo.getWord(byArray, 2) - 6;
        int n3 = (byArray[36] & 0xFF) + 1;
        int n4 = 0;
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        while ((byArray[437 + n] & 0xFF) < 128) {
            int n5;
            int n6;
            for (n6 = 7; n6 >= 0; --n6) {
                n5 = byArray[437 + n - 2 * n6] & 0xFF;
                nArray[n6] = (byArray[166 + n5] & 0xFF) + ((byArray[294 + n5] & 0xFF) << 8) - n2;
                nArray2[n6] = 0;
            }
            n6 = 64;
            while (--n6 >= 0) {
                block3: for (n5 = 7; n5 >= 0; --n5) {
                    int n7;
                    int n8 = n5;
                    nArray2[n8] = nArray2[n8] - 1;
                    if (nArray2[n8] >= 0) continue;
                    do {
                        int n9 = n5;
                        int n10 = nArray[n9];
                        nArray[n9] = n10 + 1;
                        n7 = byArray[n10] & 0xFF;
                        if (n7 < 64) {
                            int n11 = n5;
                            nArray[n11] = nArray[n11] + 1;
                            continue block3;
                        }
                        if (n7 == 64) {
                            int n12 = n5;
                            int n13 = nArray[n12];
                            nArray[n12] = n13 + 1;
                            n7 = byArray[n13] & 0xFF;
                            if ((n7 & 0x7F) == 0) {
                                n6 = 0;
                            } else {
                                n3 = (n7 & 0x7F) + 1;
                            }
                            if (n7 < 128) continue block3;
                            int n14 = n5;
                            nArray[n14] = nArray[n14] + 1;
                            continue block3;
                        }
                        if (n7 >= 128) continue;
                        int n15 = n5;
                        int n16 = nArray[n15];
                        nArray[n15] = n16 + 1;
                        n7 = byArray[n16] & 0x7F;
                        if (n7 == 0) {
                            n6 = 0;
                        } else {
                            n3 = n7 + 1;
                        }
                        int n17 = n5;
                        nArray[n17] = nArray[n17] + 1;
                        continue block3;
                    } while (n7 < 192);
                    nArray2[n5] = n7 - 191;
                }
                n4 += n3;
            }
            n += 16;
        }
        if ((byArray[436 + n] & 0xFF) < 128) {
            this.loops[this.songs] = true;
        }
        this.addSong(n4);
    }

    private static int parseTmcTitle(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2 + 29;
        while (byArray2[n3] == 32) {
            if (--n3 >= n2) continue;
            return n;
        }
        if (n > 0) {
            byArray[n++] = 32;
            byArray[n++] = 124;
            byArray[n++] = 32;
        }
        while (n2 <= n3) {
            int n4 = byArray2[n2++] & 0x7F;
            switch (n4) {
                case 20: {
                    n4 = 42;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 12: 
                case 14: 
                case 15: 
                case 19: {
                    n4 += 96;
                    break;
                }
                case 24: 
                case 26: {
                    n4 = 122;
                    break;
                }
                default: {
                    if (ASAPInfo.isValidChar(n4)) break;
                    n4 = 32;
                }
            }
            byArray[n++] = (byte)n4;
        }
        return n;
    }

    public final void setAuthor(String string) throws Exception {
        ASAPInfo.checkValidText(string);
        this.author = string;
    }

    public final void setDate(String string) throws Exception {
        ASAPInfo.checkValidText(string);
        this.date = string;
    }

    public final void setDefaultSong(int n) throws Exception {
        if (n < 0 || n >= this.songs) {
            throw new Exception("Song out of range");
        }
        this.defaultSong = n;
    }

    public final void setDuration(int n, int n2) throws Exception {
        if (n < 0 || n >= this.songs) {
            throw new Exception("Song out of range");
        }
        this.durations[n] = n2;
    }

    public final void setLoop(int n, boolean bl) throws Exception {
        if (n < 0 || n >= this.songs) {
            throw new Exception("Song out of range");
        }
        this.loops[n] = bl;
    }

    public final void setMusicAddress(int n) throws Exception {
        if (n < 0 || n >= 65535) {
            throw new Exception("Invalid music address");
        }
        this.music = n;
    }

    public final void setTitle(String string) throws Exception {
        ASAPInfo.checkValidText(string);
        this.title = string;
    }

    private static boolean validateFc(byte[] byArray, int n) {
        if (n < 899) {
            return false;
        }
        return byArray[0] == 38 && byArray[1] == 35;
    }

    private static boolean validateRmt(byte[] byArray, int n) {
        if (n < 48) {
            return false;
        }
        return byArray[6] == 82 && byArray[7] == 77 && byArray[8] == 84 && byArray[13] == 1;
    }

    private static boolean validateSap(byte[] byArray, int n) {
        return n >= 30 && ASAPInfo.hasStringAt(byArray, 0, "SAP\r\n");
    }
}

