/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import net.sf.asap.ASAP6502;
import net.sf.asap.ASAPInfo;
import net.sf.asap.Cpu6502;
import net.sf.asap.Pokey;
import net.sf.asap.PokeyPair;

public class ASAP {
    private int blocksPlayed;
    private int consol;
    private final byte[] covox = new byte[4];
    private final Cpu6502 cpu = new Cpu6502();
    private int currentDuration;
    private int currentSong;
    int cycle;
    private boolean gtiaOrCovoxPlayedThisFrame;
    final byte[] memory = new byte[65536];
    private final ASAPInfo moduleInfo = new ASAPInfo();
    int nextEventCycle;
    private int nextPlayerCycle;
    private int nextScanlineCycle;
    private int nmist;
    final PokeyPair pokeys = new PokeyPair();
    public static final int SAMPLE_RATE = 44100;
    private int silenceCycles = 0;
    private int silenceCyclesCounter;
    private int tmcPerFrameCounter;

    private void call6502(int n) {
        this.memory[53760] = 32;
        this.memory[53761] = (byte)n;
        this.memory[53762] = (byte)(n >> 8);
        this.memory[53763] = -46;
        this.cpu.pc = 53760;
    }

    private void call6502Player() {
        int n = this.moduleInfo.player;
        switch (this.moduleInfo.type) {
            case 0: {
                this.call6502(n);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.call6502(n + 6);
                break;
            }
            case 2: {
                if (n < 0) break;
                int n2 = this.cpu.s;
                this.memory[256 + n2] = (byte)(this.cpu.pc >> 8);
                n2 = n2 - 1 & 0xFF;
                this.memory[256 + n2] = (byte)this.cpu.pc;
                this.cpu.s = n2 - 1 & 0xFF;
                this.memory[53760] = 8;
                this.memory[53761] = 72;
                this.memory[53762] = -118;
                this.memory[53763] = 72;
                this.memory[53764] = -104;
                this.memory[53765] = 72;
                this.memory[53766] = 32;
                this.memory[53767] = (byte)n;
                this.memory[53768] = (byte)(n >> 8);
                this.memory[53769] = 104;
                this.memory[53770] = -88;
                this.memory[53771] = 104;
                this.memory[53772] = -86;
                this.memory[53773] = 104;
                this.memory[53774] = 64;
                this.cpu.pc = 53760;
                break;
            }
            case 3: {
                int n3 = (this.memory[69] & 0xFF) - 1;
                this.memory[69] = (byte)n3;
                if (n3 != 0) break;
                this.memory[45179] = (byte)((this.memory[45179] & 0xFF) + 1);
                break;
            }
            case 8: {
                this.call6502(n + 259);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                this.call6502(n + 3);
                break;
            }
            case 11: {
                if (--this.tmcPerFrameCounter <= 0) {
                    this.tmcPerFrameCounter = this.memory[this.moduleInfo.music + 31] & 0xFF;
                    this.call6502(n + 3);
                    break;
                }
                this.call6502(n + 6);
            }
        }
    }

    public final void detectSilence(int n) {
        this.silenceCyclesCounter = this.silenceCycles = n * 1773447;
    }

    private int do6502Frame() {
        this.nextEventCycle = 0;
        this.nextScanlineCycle = 0;
        this.nmist = this.nmist == 0 ? 1 : 2;
        int n = this.moduleInfo.ntsc ? 29868 : 35568;
        this.cpu.doFrame(this, n);
        this.cycle -= n;
        if (this.nextPlayerCycle != 0x800000) {
            this.nextPlayerCycle -= n;
        }
        int n2 = 3;
        while (true) {
            this.pokeys.basePokey.channels[n2].endFrame(n);
            this.pokeys.extraPokey.channels[n2].endFrame(n);
            if (n2 == 0) break;
            n2 >>= 1;
        }
        return n;
    }

    private void do6502Init(int n, int n2, int n3, int n4) throws Exception {
        this.cpu.pc = n;
        this.cpu.a = n2 & 0xFF;
        this.cpu.x = n3 & 0xFF;
        this.cpu.y = n4 & 0xFF;
        this.memory[53760] = -46;
        this.memory[510] = -1;
        this.memory[511] = -47;
        this.cpu.s = 253;
        for (int i = 0; i < 50; ++i) {
            this.do6502Frame();
            if (this.cpu.pc != 53760) continue;
            return;
        }
        throw new Exception("INIT routine didn't return");
    }

    private int doFrame() {
        this.gtiaOrCovoxPlayedThisFrame = false;
        this.pokeys.startFrame();
        int n = this.do6502Frame();
        this.pokeys.endFrame(n);
        return n;
    }

    public final int generate(byte[] byArray, int n, int n2) {
        return this.generateAt(byArray, 0, n, n2);
    }

    private int generateAt(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (this.silenceCycles > 0 && this.silenceCyclesCounter <= 0) {
            return 0;
        }
        int n5 = this.moduleInfo.channels - 1 + (n3 != 0 ? 1 : 0);
        int n6 = n2 >> n5;
        if (this.currentDuration > 0 && n6 > (n4 = ASAP.millisecondsToBlocks(this.currentDuration)) - this.blocksPlayed) {
            n6 = n4 - this.blocksPlayed;
        }
        n4 = 0;
        while (true) {
            int n7 = this.pokeys.generate(byArray, n + (n4 << n5), n6 - n4, n3);
            this.blocksPlayed += n7;
            if ((n4 += n7) >= n6) break;
            int n8 = this.doFrame();
            if (this.silenceCycles <= 0) continue;
            if (this.pokeys.isSilent() && !this.gtiaOrCovoxPlayedThisFrame) {
                this.silenceCyclesCounter -= n8;
                if (this.silenceCyclesCounter > 0) continue;
                break;
            }
            this.silenceCyclesCounter = this.silenceCycles;
        }
        return n4 << n5;
    }

    public final int getBlocksPlayed() {
        return this.blocksPlayed;
    }

    public final ASAPInfo getInfo() {
        return this.moduleInfo;
    }

    public final int getPokeyChannelVolume(int n) {
        Pokey pokey = (n & 4) == 0 ? this.pokeys.basePokey : this.pokeys.extraPokey;
        return pokey.channels[n & 3].audc & 0xF;
    }

    public final int getPosition() {
        return this.blocksPlayed * 10 / 441;
    }

    public final int getWavHeader(byte[] byArray, int n, boolean bl) {
        int n2 = n != 0 ? 1 : 0;
        int n3 = this.moduleInfo.channels << n2;
        int n4 = 44100 * n3;
        int n5 = ASAP.millisecondsToBlocks(this.currentDuration);
        int n6 = (n5 - this.blocksPlayed) * n3;
        ASAP.putLittleEndian(byArray, 8, 1163280727);
        ASAP.putLittleEndians(byArray, 12, 544501094, 16);
        byArray[20] = 1;
        byArray[21] = 0;
        byArray[22] = (byte)this.moduleInfo.channels;
        byArray[23] = 0;
        ASAP.putLittleEndians(byArray, 24, 44100, n4);
        byArray[32] = (byte)n3;
        byArray[33] = 0;
        byArray[34] = (byte)(8 << n2);
        byArray[35] = 0;
        int n7 = 36;
        if (bl) {
            int n8 = this.moduleInfo.getYear();
            if (this.moduleInfo.title.length() > 0 || this.moduleInfo.author.length() > 0 || n8 > 0) {
                ASAP.putLittleEndian(byArray, 44, 1330007625);
                n7 = ASAP.putWavMetadata(byArray, 48, 1296125513, this.moduleInfo.title);
                n7 = ASAP.putWavMetadata(byArray, n7, 1414676809, this.moduleInfo.author);
                if (n8 > 0) {
                    ASAP.putLittleEndians(byArray, n7, 1146241865, 6);
                    for (int i = 3; i >= 0; --i) {
                        byArray[n7 + 8 + i] = (byte)(48 + n8 % 10);
                        n8 /= 10;
                    }
                    byArray[n7 + 12] = 0;
                    byArray[n7 + 13] = 0;
                    n7 += 14;
                }
                ASAP.putLittleEndians(byArray, 36, 1414744396, n7 - 44);
            }
        }
        ASAP.putLittleEndians(byArray, 0, 1179011410, n7 + n6);
        ASAP.putLittleEndians(byArray, n7, 1635017060, n6);
        return n7 + 8;
    }

    final void handleEvent() {
        int n = this.cycle;
        if (n >= this.nextScanlineCycle) {
            if (n - this.nextScanlineCycle < 50) {
                this.cycle = n += 9;
            }
            this.nextScanlineCycle += 114;
            if (n >= this.nextPlayerCycle) {
                this.call6502Player();
                this.nextPlayerCycle += 114 * this.moduleInfo.fastplay;
            }
        }
        int n2 = this.nextScanlineCycle;
        n2 = this.pokeys.basePokey.checkIrq(n, n2);
        this.nextEventCycle = n2 = this.pokeys.extraPokey.checkIrq(n, n2);
    }

    public final void load(String string, byte[] byArray, int n) throws Exception {
        this.moduleInfo.load(string, byArray, n);
        byte[] byArray2 = ASAP6502.getPlayerRoutine(this.moduleInfo);
        if (byArray2 != null) {
            int n2 = ASAPInfo.getWord(byArray2, 2);
            int n3 = ASAPInfo.getWord(byArray2, 4);
            if (this.moduleInfo.music <= n3) {
                throw new Exception("Module address conflicts with the player routine");
            }
            this.memory[19456] = 0;
            if (this.moduleInfo.type == 13) {
                System.arraycopy(byArray, 0, this.memory, this.moduleInfo.music, n);
            } else {
                System.arraycopy(byArray, 6, this.memory, this.moduleInfo.music, n - 6);
            }
            System.arraycopy(byArray2, 6, this.memory, n2, n3 + 1 - n2);
            if (this.moduleInfo.player < 0) {
                this.moduleInfo.player = n2;
            }
            return;
        }
        ASAP.clear(this.memory);
        int n4 = this.moduleInfo.headerLen + 2;
        while (n4 + 5 <= n) {
            int n5 = ASAPInfo.getWord(byArray, n4);
            int n6 = ASAPInfo.getWord(byArray, n4 + 2) + 1 - n5;
            if (n6 <= 0 || n4 + n6 > n) {
                throw new Exception("Invalid binary block");
            }
            System.arraycopy(byArray, n4 += 4, this.memory, n5, n6);
            if ((n4 += n6) == n) {
                return;
            }
            if (n4 + 7 > n || byArray[n4] != -1 || byArray[n4 + 1] != -1) continue;
            n4 += 2;
        }
        throw new Exception("Invalid binary block");
    }

    private static int millisecondsToBlocks(int n) {
        return n * 441 / 10;
    }

    public final void mutePokeyChannels(int n) {
        this.pokeys.basePokey.mute(n);
        this.pokeys.extraPokey.mute(n >> 4);
    }

    final int peekHardware(int n) {
        switch (n & 0xFF1F) {
            case 53268: {
                return this.moduleInfo.ntsc ? 15 : 1;
            }
            case 53279: {
                return ~this.consol & 0xF;
            }
            case 53770: 
            case 53774: 
            case 53786: 
            case 53790: {
                return this.pokeys.peek(n, this.cycle);
            }
            case 53772: 
            case 53775: 
            case 53788: 
            case 53791: {
                return 255;
            }
            case 54283: 
            case 54299: {
                if (this.cycle > (this.moduleInfo.ntsc ? 29868 : 35568)) {
                    return 0;
                }
                return this.cycle / 228;
            }
            case 54287: 
            case 54303: {
                switch (this.nmist) {
                    case 0: {
                        return 31;
                    }
                    case 2: {
                        return 95;
                    }
                }
                return this.cycle < 28291 ? 31 : 95;
            }
        }
        return this.memory[n] & 0xFF;
    }

    public final void playSong(int n, int n2) throws Exception {
        if (n < 0 || n >= this.moduleInfo.songs) {
            throw new Exception("Song number out of range");
        }
        this.currentSong = n;
        this.currentDuration = n2;
        this.nextPlayerCycle = 0x800000;
        this.blocksPlayed = 0;
        this.silenceCyclesCounter = this.silenceCycles;
        this.cycle = 0;
        this.cpu.nz = 0;
        this.cpu.c = 0;
        this.cpu.vdi = 0;
        this.nmist = 1;
        this.consol = 8;
        this.covox[0] = -128;
        this.covox[1] = -128;
        this.covox[2] = -128;
        this.covox[3] = -128;
        this.pokeys.initialize(this.moduleInfo.ntsc, this.moduleInfo.channels > 1);
        this.mutePokeyChannels(255);
        switch (this.moduleInfo.type) {
            case 0: {
                this.do6502Init(this.moduleInfo.init, n, 0, 0);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.do6502Init(this.moduleInfo.player + 3, 112, this.moduleInfo.music, this.moduleInfo.music >> 8);
                this.do6502Init(this.moduleInfo.player + 3, 0, n, 0);
                break;
            }
            case 2: 
            case 3: {
                this.cpu.pc = this.moduleInfo.init;
                this.cpu.a = n;
                this.cpu.x = 0;
                this.cpu.y = 0;
                this.cpu.s = 255;
                break;
            }
            case 8: {
                this.do6502Init(this.moduleInfo.player + 256, 0, 0, this.moduleInfo.songPos[n] & 0xFF);
                break;
            }
            case 9: {
                this.do6502Init(this.moduleInfo.player, 0, this.moduleInfo.music >> 8, this.moduleInfo.music);
                this.do6502Init(this.moduleInfo.player, 2, this.moduleInfo.songPos[n] & 0xFF, 0);
                break;
            }
            case 10: {
                this.do6502Init(this.moduleInfo.player, this.moduleInfo.songPos[n] & 0xFF, this.moduleInfo.music, this.moduleInfo.music >> 8);
                break;
            }
            case 11: 
            case 12: {
                this.do6502Init(this.moduleInfo.player, 112, this.moduleInfo.music >> 8, this.moduleInfo.music);
                this.do6502Init(this.moduleInfo.player, 0, n, 0);
                this.tmcPerFrameCounter = 1;
                break;
            }
            case 13: {
                this.do6502Init(this.moduleInfo.player, n, 0, 0);
            }
        }
        this.mutePokeyChannels(0);
        this.nextPlayerCycle = 0;
    }

    final void pokeHardware(int n, int n2) {
        if (n >> 8 == 210) {
            int n3 = this.pokeys.poke(n, n2, this.cycle);
            if (this.nextEventCycle > n3) {
                this.nextEventCycle = n3;
            }
        } else if ((n & 0xFF0F) == 54282) {
            int n4 = this.cycle % 114;
            this.cycle += (n4 <= 106 ? 106 : 220) - n4;
        } else if ((n & 0xFF0F) == 54287) {
            this.nmist = this.cycle < 28292 ? 1 : 0;
        } else if ((n & 0xFF00) == this.moduleInfo.covoxAddr) {
            Pokey pokey = (n &= 3) == 0 || n == 3 ? this.pokeys.basePokey : this.pokeys.extraPokey;
            int n5 = n2 - (this.covox[n] & 0xFF);
            if (n5 != 0) {
                pokey.addDelta(this.pokeys, this.cycle, n5 << 17);
                this.covox[n] = (byte)n2;
                this.gtiaOrCovoxPlayedThisFrame = true;
            }
        } else if ((n & 0xFF1F) == 53279) {
            int n6 = (this.consol & 8) - (n2 & 8) << 20;
            if (n6 != 0) {
                this.pokeys.basePokey.addDelta(this.pokeys, this.cycle, n6);
                this.pokeys.extraPokey.addDelta(this.pokeys, this.cycle, n6);
                this.gtiaOrCovoxPlayedThisFrame = true;
            }
            this.consol = n2;
        } else {
            this.memory[n] = (byte)n2;
        }
    }

    private static void putLittleEndian(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    private static void putLittleEndians(byte[] byArray, int n, int n2, int n3) {
        ASAP.putLittleEndian(byArray, n, n2);
        ASAP.putLittleEndian(byArray, n + 4, n3);
    }

    private static int putWavMetadata(byte[] byArray, int n, int n2, String string) {
        int n3 = string.length();
        if (n3 > 0) {
            ASAP.putLittleEndians(byArray, n, n2, (n3 | 1) + 1);
            n += 8;
            for (int i = 0; i < n3; ++i) {
                byArray[n++] = (byte)string.charAt(i);
            }
            byArray[n++] = 0;
            if ((n3 & 1) == 0) {
                byArray[n++] = 0;
            }
        }
        return n;
    }

    public final void seek(int n) throws Exception {
        this.seekSample(ASAP.millisecondsToBlocks(n));
    }

    public final void seekSample(int n) throws Exception {
        if (n < this.blocksPlayed) {
            this.playSong(this.currentSong, this.currentDuration);
        }
        while (this.blocksPlayed + this.pokeys.readySamplesEnd < n) {
            this.blocksPlayed += this.pokeys.readySamplesEnd;
            this.doFrame();
        }
        this.pokeys.readySamplesStart = n - this.blocksPlayed;
        this.blocksPlayed = n;
    }

    private static void clear(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }
}

