/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asap;

import net.sf.asap.RandomAccessInputStream;

public class AATR {
    private int bytesPerSector;
    private RandomAccessInputStream content;
    private final byte[] directorySector = new byte[128];
    private int fileNo;
    private String filename;
    private int sector4Offset;

    private int getFilenamePart(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directorySector[n + i] & 0xFF;
            if (n3 == 32) {
                int n4 = i;
                while (++i < n2) {
                    if (this.directorySector[n + i] == 32) continue;
                    return -1;
                }
                return n4;
            }
            if (n3 >= 65 && n3 <= 90 || n3 >= 48 && n3 <= 57 || n3 == 95) continue;
            return -1;
        }
        return n2;
    }

    public final String nextFile() {
        int n;
        int n2;
        int n3;
        block4: while (true) {
            if (this.fileNo >= 63) {
                return null;
            }
            ++this.fileNo;
            n3 = (this.fileNo & 7) << 4;
            if (n3 == 0 && !this.readSector(361 + (this.fileNo >> 3), this.directorySector, 128)) {
                return null;
            }
            switch (this.directorySector[n3] & 0xD7) {
                case 0: {
                    return null;
                }
                case 3: 
                case 66: 
                case 70: {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            n2 = this.getFilenamePart(n3 + 5, 8);
            if (n2 >= 0 && (n = this.getFilenamePart(n3 + 13, 3)) >= 0 && (n2 != 0 || n != 0)) break;
        }
        this.filename = new String(this.directorySector, n3 + 5, n2);
        if (n > 0) {
            this.directorySector[n3 + 12] = 46;
            String string = new String(this.directorySector, n3 + 12, 1 + n);
            this.filename = this.filename + string;
        }
        return this.filename;
    }

    public final boolean open(RandomAccessInputStream randomAccessInputStream) {
        byte[] byArray = new byte[6];
        randomAccessInputStream.run(0, byArray, 6);
        if (byArray[0] != -106 || byArray[1] != 2) {
            return false;
        }
        this.bytesPerSector = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
        this.sector4Offset = 400;
        switch (this.bytesPerSector) {
            case 128: {
                break;
            }
            case 256: {
                if ((byArray[2] & 0xF) != 0) break;
                this.sector4Offset = 784;
                break;
            }
            default: {
                return false;
            }
        }
        this.content = randomAccessInputStream;
        this.fileNo = -1;
        return true;
    }

    public final int readCurrentFile(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = (this.fileNo & 7) << 4;
        int n4 = this.directorySector[n3 + 3] & 0xFF | (this.directorySector[n3 + 4] & 0xFF) << 8;
        boolean bl = (this.directorySector[n3] & 4) != 0;
        byte[] byArray2 = new byte[256];
        while (n4 != 0 && n > 0) {
            if (!this.readSector(n4, byArray2, this.bytesPerSector)) {
                return -1;
            }
            int n5 = byArray2[this.bytesPerSector - 1] & 0xFF;
            if (n5 > n) {
                n5 = n;
            }
            if (byArray != null) {
                System.arraycopy(byArray2, 0, byArray, n2, n5);
            }
            n2 += n5;
            n -= n5;
            n4 = byArray2[this.bytesPerSector - 3] & 0xFF;
            if (!bl) {
                n4 &= 3;
            }
            n4 = n4 << 8 | byArray2[this.bytesPerSector - 2] & 0xFF;
        }
        return n2;
    }

    public final int readFile(String string, byte[] byArray, int n) {
        String string2;
        do {
            if ((string2 = this.nextFile()) != null) continue;
            return -1;
        } while (!string2.equals(string));
        return this.readCurrentFile(byArray, n);
    }

    private boolean readSector(int n, byte[] byArray, int n2) {
        if (n < 4) {
            return false;
        }
        return this.content.run(this.sector4Offset + (n - 4) * this.bytesPerSector, byArray, n2);
    }
}

