// Eratosthenes Sieve benchmark
// 69 tick

uses crt, sysutils;

{$define FAST}

const
 size = 8191;
 iter_max = 1;

var
  flags: array [0..size] of boolean;

  iter: byte;
  starttime: cardinal;

{$ifdef FAST}
  i: word absolute $e0;
  k: word absolute $e2;
  prime: word absolute $e4;
  count: word absolute $e6;
{$else}
  i, k, prime, count: word;
{$endif}

begin

	writeln(iter_max,' iterations');

	starttime := GetTickCount;

	iter := 1;
	while iter <= iter_max do begin

		fillchar(flags, sizeof(flags), true);

		i:=0;
		count := 0;

		while i <= size do begin

			if flags[i] then begin

				prime := i shl 1 + 3;
				k := prime + i;

				while (k <= size) do begin
					flags[k] := false;
					inc(k, prime);
				end;
				inc(count);
			end;

		inc(i);
		end;

	inc(iter);
	end;

 writeln(count, ' primes');
 writeln(GetTickCount - starttime, ' tick');

 repeat until keypressed;

end.
